<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/**
 * PubML Ajax Handlers
 *
 * Handles AJAX requests via wp_ajax hook (both admin and front-end events)
 *
 * @author 		SynapseIndia
 * @category 	Core
 * @link		http://www.pubml.com
 * @package 	PubML/inc/AJAX 
 * @version     0.0.1
 */	

	// Process ajax New Book form.
	function pubml_new_book_creation() {
		global $pubml;	

		die(0);
	}

	add_action('wp_ajax_pubml_new_book_creation', 'pubml_new_book_creation');
	add_action('wp_ajax_nopriv_pubml_new_book_creation', 'pubml_new_book_creation');


   /*
	* Process ajax PUBML Webfont deletion.
	*
	* @access public
	* @return void
	*/
	function pubml_webfont_delete() {
		global $pubml, $wpdb;	
		$result = array();
		
		$target_id = $_POST['targetId'];
		$_pubml_fonts = get_option( 'pubml_fonts' );
		
		if(array_key_exists($target_id, $_pubml_fonts)){

			unset($_pubml_fonts[$target_id]);

			update_option('pubml_fonts', $_pubml_fonts);	

			$result['status'] = 'true';
			$result['msg'] = 'Deleted Successfully';		
		} else {
			$result['status'] = 'false';
			$result['msg'] = 'Could not deleted';
		}
		echo json_encode($result);
		exit();
		
	}

	add_action('wp_ajax_pubml_webfont_delete', 'pubml_webfont_delete');
	add_action('wp_ajax_nopriv_pubml_webfont_delete', 'pubml_webfont_delete');
	
	
	/*
	* Process ajax PUBML Webfont fallback associations.
	*
	* @access public
	* @return void
	*/
	function pubml_webfont_fallback_association() {
		global $pubml, $wpdb;	
		$result = array();
		
		$target_id = $_POST['targetId'];
		$_pubml_fonts = get_option( 'pubml_fonts' );
		
		if(array_key_exists($target_id, $_pubml_fonts)){
			
			$fallback_fonts = $_pubml_fonts[$target_id];
			
			$result['link'] = stripslashes($fallback_fonts['link']);
			$result['family'] = stripslashes($fallback_fonts['family']);
			$result['fallback'] = stripslashes($fallback_fonts['fallback']);
			$result['font_type'] = stripslashes($fallback_fonts['font_type']);
			$result['status'] = 'true';
			$result['msg'] = 'Successfully';		
		} else {
			$result['status'] = 'false';
			$result['msg'] = 'Could not Found';
		}
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_webfont_fallback_association', 'pubml_webfont_fallback_association');
	add_action('wp_ajax_nopriv_pubml_webfont_fallback_association', 'pubml_webfont_fallback_association');
	
		/*
	* Process ajax PUBML Webfont fallback_associate.
	*
	* @access public
	* @return void
	*/
	function fallback_association() {
		global $pubml, $wpdb;	
		$result = array();
		
		$source_webfont = $_POST['source_webfont'];
		$target_fallback = $_POST['target_fallback'];
		$_pubml_fonts = get_option( 'pubml_fonts' );
		
		if(array_key_exists($source_webfont, $_pubml_fonts)){

			$_pubml_fonts[$source_webfont]['fallback'] = $target_fallback;
			update_option('pubml_fonts', $_pubml_fonts);	
						
			$result['status'] = 'true';
			$result['msg'] = 'Successfully updated';		
		} else {
			$result['status'] = 'false';
			$result['msg'] = 'Could not Found';
		}
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_fallback_association', 'fallback_association');
	add_action('wp_ajax_nopriv_fallback_association', 'fallback_association');
	
		
	/*
	* Process ajax PUBML Media association.
	*
	* @access public
	* @return void
	*/
	function pubml_media_associate() {
		global $pubml;
		global $wpdb;
		$mid = $_POST['mid'];
		$wpdb->query($wpdb->prepare( "DELETE FROM {$wpdb->prefix}media_group_association WHERE media_id = %d",$mid) );
		if($_POST['sid']){
			foreach($_POST['sid'] as $sid){
		
					$wpdb->insert(
					$wpdb->prefix.'media_group_association',
						array(
								'book_id' => $_POST['bid'],
								'media_id' => $_POST['mid'],
								'associate_groups' =>$sid
							)
					);
			}
		}
		$result['data'] = '';
		$mygroups = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}media_group WHERE {$wpdb->prefix}media_group.book_id ={$_POST['bid']} ORDER BY {$wpdb->prefix}media_group.group_slug ASC", OBJECT);
		if ($mygroups) { 
			$count=1;
			foreach ( $mygroups as $group ) {
				if($count%2==0){$class='even';}
				else{$class='odd';}
				
				$related_groups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.book_id ={$_POST['bid']} AND  	{$wpdb->prefix}media_group_association.associate_groups ={$group->group_id} ", OBJECT);
				$preview_class = '';
				if ($related_groups) { 
					$preview_class = 'preview';
				}
				$grp_title = strlen($group->group_title) > 52 ? substr($group->group_title,0,52)."..." : $group->group_title;
				
				$result['data'] .='<li class="'.$class.' '.$group->group_id.'"><span style="float:left;width:5%;"><input type="checkbox" class="med_id" value='.$group->group_id.' /></span><span class="medgrp_title">'.stripslashes($grp_title).' ('.count($related_groups).')</span><span><span class="del_icon"><a href="javascript:void(0);" class="delete-group"><img src="'. PUBML_BASE_URL.'/images/delete.png" class="tbl_icon"></a></span><span class="view-media-group '.$preview_class.'"><a href="javascript:getMedia("'.$group->group_slug.'");" class="view-groupdata"><img src="'.PUBML_BASE_URL.'/images/search.png"                                                                                        class="tbl_icon"></a></span></span></li>';
				$count++;
		  }
	  }
 	 $result['msg'] = "<h5>Media association/Disassociation done successfully.</h5>";  
	
		echo json_encode($result);
		exit();	
	}

	add_action('wp_ajax_pubml_media_associate', 'pubml_media_associate');
	add_action('wp_ajax_nopriv_pubml_media_associate', 'pubml_media_associate');
	
	
	/*
	* Process ajax PUBML Media Update associate groups.
	*
	* @access public
	* @return void
	*/
	function pubml_media_associate_groups() {
		global $pubml;
		global $wpdb;
		$result = array();
		$mid = $_POST['mid'];
		$myrows = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.media_id ={$mid}",OBJECT);
			if (isset($myrows) && !empty($myrows)) {
				foreach($myrows as $group){
					$group_arr[] = $group->associate_groups;
				 }
				$result['groups'] = json_encode($group_arr);  
				$result['status'] = 'true';
				$result['msg'] = 'Successfully';
			} else {
				$result['data'] = '';
				$result['status'] = 'false';
				$result['msg'] = 'Could not found';		
			}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_associate_groups', 'pubml_media_associate_groups');
	add_action('wp_ajax_nopriv_pubml_media_associate_groups', 'pubml_media_associate_groups');	
	
	/*
	* Process ajax PUBML Helps Content to call the data respectively.
	*
	* @access public
	* @return void
	*/
	function pubml_helps() {
		global $pubml, $wpdb,$helps_array;
		$helps_array = $GLOBALS['helps_array'];
		$result = array();
		$help_key = $_POST['help_key'];
		
			if(array_key_exists($help_key, $helps_array)){
							
				$result['helpTitle'] = $helps_array[$help_key]['title'];
				$result['helpContent'] = $helps_array[$help_key]['content'];
				$result['status'] = 'true';
				$result['msg'] = 'Successfully';		
			} else {
				$result['helpTitle'] = 'Not Found';
				$result['helpContent'] = 'Data Not available';
				$result['status'] = 'false';
				$result['msg'] = 'Could not Found';
			}	
		echo json_encode($result);
		exit();		
	}

	// add_action('wp_ajax_pubml_helps', 'pubml_helps');
	// add_action('wp_ajax_nopriv_pubml_helps', 'pubml_helps');
	
	/*
	* Process ajax PUBML Media manage associate groups.
	*
	* @access public
	* @return void
	*/
	function pubml_media_manage_groups() {
		global $pubml;
		global $wpdb;
		$result = array();
		$title = stripslashes_deep($_POST['title']);
		$bid = stripslashes_deep($_POST['bid']);
		$grp_slug = sanitize_title($_POST['title']);
		if( $_POST && $_POST['operation']=='add'){
			$check_group = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}media_group WHERE {$wpdb->prefix}media_group.book_id ={$bid} AND {$wpdb->prefix}media_group.group_title ='{$title}'", OBJECT);
			if (!empty($check_group)) { 
				$result['status'] = 'error';
				$result['msg'] = 'Media Group Title already in use.';
			}
			else {
				$wpdb->insert(
				$wpdb->prefix.'media_group',
					array(
							'book_id' => $_POST['bid'],
							'group_title' => $_POST['title'],
							'group_slug' => $grp_slug 
						)
				);
				$result['status'] = 'true';
				$result['msg'] = 'Media Group added successfully';
				$result['data'] = '';
				$mygroups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group WHERE {$wpdb->prefix}media_group.book_id ={$_POST['bid']} ORDER BY {$wpdb->prefix}media_group.group_slug ASC", OBJECT);
				if ($mygroups) { 
					$count=1;
					foreach ( $mygroups as $group ) {
						if($count%2==0){$class='even';}
						else{$class='odd';}
						
						$related_groups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.book_id ={$_POST['bid']} AND  	{$wpdb->prefix}media_group_association.associate_groups ={$group->group_id} ", OBJECT);
						$preview_class = '';
						if ($related_groups) { 
							$preview_class = 'preview';
						}
						$grp_title = strlen($group->group_title) > 52 ? substr($group->group_title,0,52)."..." : $group->group_title;
						
						$result['data'] .='<li class="'.$class.' '.$group->group_id.'"><span style="float:left;width:5%;"><input type="checkbox" class="med_id" value='.$group->group_id.' /></span><span class="medgrp_title">'.stripslashes($grp_title).' ('.count($related_groups).')</span><span><span class="del_icon"><a href="javascript:void(0);" class="delete-group"><img src="'. PUBML_BASE_URL.'/images/delete.png" class="tbl_icon"></a></span><span class="view-media-group '.$preview_class.'"><a href="javascript:getMedia("'.$group->group_slug.'");" class="view-groupdata"><img src="'.PUBML_BASE_URL.'/images/search.png"                                                                                        class="tbl_icon"></a></span></span></li>';
						$count++;
				  }
			  }
			}
		}	
		else if($_POST && $_POST['operation']=='delete'){
				$gid = $_POST['gid'];
				$wpdb->query($wpdb->prepare("DELETE FROM {$wpdb->prefix}media_group WHERE group_id = %d",$gid) );
				$result['status'] = 'true';
				$result['msg'] = 'Media Group delete successfully';
				$mygroups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group WHERE {$wpdb->prefix}media_group.book_id ={$_POST['bid']} ORDER BY {$wpdb->prefix}media_group.group_slug ASC", OBJECT);
				if ($mygroups) { 
					$count=1;
					foreach ( $mygroups as $group ) {
						if($count%2==0){$class='even';}
						else{$class='odd';}
						
						$related_groups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.book_id ={$_POST['bid']} AND  	{$wpdb->prefix}media_group_association.associate_groups ={$group->group_id} ", OBJECT);
						$preview_class = '';
						if ($related_groups) { 
							$preview_class = 'preview';
						}
						$group_title = strlen($group->group_title) > 52 ? substr($group->group_title,0,52)."..." : $group->group_title;
						
						$result['data'] .='<li class="'.$class.' '.$group->group_id.'"><span style="float:left;width:5%;"><input type="checkbox" class="med_id" value='.$group->group_id.' /></span><span class="medgrp_title">'.stripslashes($group_title).' ('.count($related_groups).')</span><span><span class="del_icon"><a href="javascript:void(0);" class="delete-group"><img src="'. PUBML_BASE_URL.'/images/delete.png" class="tbl_icon"></a></span><span class="view-media-group '.$preview_class.'"><a href="javascript:getMedia("'.$group->group_slug.'");" class="view-groupdata"><img src="'.PUBML_BASE_URL.'/images/search.png" class="tbl_icon"></a></span></span></li>';
						$count++;
				  }
			 }
		}
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_manage_groups', 'pubml_media_manage_groups');
	add_action('wp_ajax_nopriv_pubml_media_manage_groups', 'pubml_media_manage_groups');
	
	/*
	* Process ajax PUBML Media Update associate groups.
	*
	* @access public
	* @return void
	*/
	function pubml_media_associate_show() {
		global $pubml;
		global $wpdb;
		$result = array();
		$gid = $_POST['gid'];
		$myrows = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.associate_groups ={$gid}",OBJECT);
			if (isset($myrows) && !empty($myrows)) {
				foreach($myrows as $group){
					$med_arr[] = $group->media_id;
				 }
				$result['med'] = json_encode($med_arr);  
				$result['status'] = 'true';
				$result['msg'] = 'Successfully';
			} else {
				$result['data'] = '';
				$result['status'] = 'false';
				$result['msg'] = 'Could not found';		
			}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_associate_show', 'pubml_media_associate_show');
	add_action('wp_ajax_nopriv_pubml_media_associate_show', 'pubml_media_associate_show');
	
		/*
	* Process ajax PUBML Media insert.
	*
	* @access public
	* @return void
	*/
	function pubml_media_insert_new() {
		global $pubml;
		global $wpdb;
		if($_POST && !empty($_POST['media_url'])){
				$media_slug = strtolower(str_replace(' ','-',$_POST['media_title']));
				if (strpos($_POST['media_url'],'maps') != false){
					$mtype='map';
				}
				else if (strpos($_POST['media_url'],'youtube') != false){
					$mtype='youtube';
				}
				else if (strpos($_POST['media_url'],'flickr') != false){
					$mtype='flickr';
				}
				else if (strpos($_POST['media_url'],'wordpress') != false){
					$mtype='wordpress';
				}
				else if (strpos($_POST['media_url'],'uploads') != false){
					$mtype='wordpress';
				}
				$wpdb->insert(
						$wpdb->prefix.'book_media',
						array(
								'book_id' => $_POST['bid'],
								'media_url' => $_POST['media_url'],
								'media_title' =>$_POST['media_title'],
								'media_slug' =>$media_slug,
								'media_type' => $mtype
							)
				);
				$result['status'] = 'true';
				$result['msg'] = 'Media Source added successfully';
		} 
		else {
				$result['status'] = 'false';
				$result['msg'] = 'Please enter media url and title';		
		}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_insert_new', 'pubml_media_insert_new');
	add_action('wp_ajax_nopriv_pubml_media_insert_new', 'pubml_media_insert_new');
	
	/*
	* Process ajax PUBML Media filtering.
	*
	* @access public
	* @return void
	*/
	function pubml_media_source_filter() {
		global $pubml;
		global $wpdb;
		if($_POST['sid']){
		$book_slug = $_POST['slug'];
		$filters = "'".implode("','",$_POST['sid'])."'";
			$media_query =  "SELECT * FROM {$wpdb->prefix}book_media WHERE {$wpdb->prefix}book_media.book_id ={$_POST['bid']} AND {$wpdb->prefix}book_media.media_type IN({$filters}) ORDER BY {$wpdb->prefix}book_media.media_title ASC";
			//echo $media_query ;
			$myrows = $wpdb->get_results($media_query, OBJECT);
			if ($myrows) {
				$i=1;
				$result['data'] = "";
				foreach ( $myrows as $media ) {
					if($i%2==0){$cls='even';}
					else{$cls='odd';}
					if (strpos($media->media_url,'maps') != false){
						$src='/images/media-icon-google-map.png';
					}
					else if (strpos($media->media_url,'youtube') != false){
						$src='/images/media-icon-youtube.png';
					}
					else if (strpos($media->media_url,'flickr') != false){
						$src='/images/media-icon-flickr.png';
					}
					else if (strpos($media->media_url,'wordpress') != false){
						$src='/images/media-icon-wp-image.png';
					}
					else if (strpos($media->media_url,'uploads') != false){
						$src='/images/media-icon-wp-image.png';
					}
					$med_title = strlen($media->media_title) > 30 ? substr($media->media_title,0,30)."..." : $media->media_title;
					$result['data'] .= '<div class="media-data '.$cls.'"><div>
					<img src="'.PUBML_BASE_URL.$src.'"  alt=""/><h4>'.stripslashes($med_title).'</h4><span style="float:right;"><a href="admin.php?page=book-media&book='. $book_slug.'&mid='.$media->media_id.'"><img src="'.PUBML_BASE_URL.'/images/edit.png" class="tbl_icon"></a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="admin.php?page=book-media-library&book='. $book_slug.'&mid='.$media->media_id.'"><img src="'. PUBML_BASE_URL.'/images/delete.png" class="tbl_icon"></a><a href="'.$media->media_url.'" target="_blank" class="view-med-source"><img src="'.PUBML_BASE_URL.'/images/search.png" class="tbl_icon"></a></span><input type="hidden" class="media-id-val" value="'.$media->media_id.'"/>
					</div>
					</div>';
					$i++;
				}
			
				$result['status'] = 'true';
			}
		else {
				$result['status'] = 'false';
				$result['data'] = '<div style="float: left;font-size: 22px;margin: 31%;" class="media-data">No results Found</div>';
		}
	}		
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_source_filter', 'pubml_media_source_filter');
	add_action('wp_ajax_nopriv_pubml_media_source_filter', 'pubml_media_source_filter');
	
	/*
	* Process ajax style insert.
	*
	* @access public
	* @return void
	*/
	function pubml_media_insert_style() {
		global $pubml;
		global $wpdb;
		$style_data = serialize($_POST);
		if($_POST ){
			if($_POST['style_val']== 0 ){
				$wpdb->insert(
						$wpdb->prefix.'book_style',
						array(
								'book_id' => $_POST['bid'],
								'style_name' => $_POST['style_name'],
								'style_data' =>$style_data,
								'type' => 'page-style'
							)
				);
				$result['msg'] = 'Page Style added successfully';
				
			}
			else{
				$wpdb->update($wpdb->prefix.'book_style', array('book_id'=>$_POST['bid'], 'style_name'=>$_POST['style_name'], 'style_data'=>$style_data,'type'=>'page-style'), array('id'=>$_POST['style_val']));	
				$result['msg'] = 'Page Style updated successfully';				
			}
			$result['data'] = pubml_page_styles_dropdown($name = 'page-style',$bid=$_POST['bid']);
			$result['status'] = 'true';
		} 
		else {
				$result['status'] = 'false';
				$result['msg'] = 'Failed';		
		}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_insert_style', 'pubml_media_insert_style');
	add_action('wp_ajax_nopriv_pubml_media_insert_style', 'pubml_media_insert_style');
	
	/*
	* Process ajax style insert.
	*
	* @access public
	* @return void
	*/
	function pubml_media_insert_page_style() {
		global $pubml;
		global $wpdb;
		$default_data = pubml_styles_default_values();
		$style_data = $_POST;
		$style_name = 'style-'.$_POST['bid'];

		if($_POST ){
			$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$_POST['bid']} AND {$wpdb->prefix}book_style.type='style'";
			$myrows = $wpdb->get_results($query, OBJECT);
			foreach($myrows as $rowdata){
				$mydata = $rowdata->style_data;
			}
			if($_POST['new_style']!= 1 && !empty($myrows)){
					$old_data = unserialize($mydata);
					$old_data[$_POST['style_val']] = $style_data;
					$updated_data = serialize($old_data);
					$wpdb->update($wpdb->prefix.'book_style', array('book_id'=>$_POST['bid'], 'style_data'=>$updated_data,'type'=>$_POST['style_type']), array('book_id'=>$_POST['bid'],'type'=>'style'));
					$result['msg'] = 'Style Updated successfully';
			}
			else if ($_POST['new_style']== 1 && !empty($myrows)){
				 $old_data = unserialize($mydata);
				 @$lastKey = end(array_keys($old_data));
				 $newKey = $lastKey + 1 ;
				 $old_data[$newKey] = $style_data;
				 $updated_data = serialize($old_data);
				 $wpdb->update($wpdb->prefix.'book_style', array('book_id'=>$_POST['bid'],'style_data'=>$updated_data,'type'=>$_POST['style_type']), array('book_id'=>$_POST['bid'],'type'=>'style'));
				$result['msg'] = 'Style Updated successfully';
			}
			else if ($_POST['new_style']== 1 && empty($myrows)){
				 $old_data = $default_data ;
				 $lastKey = end(array_keys($old_data));
				 $newKey = $lastKey + 1 ;
				 $old_data[$newKey] = $style_data;
				 $updated_data = serialize($old_data);
				$wpdb->insert(
						$wpdb->prefix.'book_style',
						array(
								'book_id' => $_POST['bid'],
								'style_name' => $style_name,
								'style_data' =>$updated_data ,
								'type' => $_POST['style_type']
							)
				);
				$result['status'] = 'true';
				$result['msg'] = 'Style added successfully';
			}
			else if ($_POST['new_style']!= 1 && empty($myrows)){
				 $old_data = $default_data ;
				 $old_data[$_POST['style_val']] = $style_data;
				 $updated_data = serialize($old_data);
				$wpdb->insert(
						$wpdb->prefix.'book_style',
						array(
								'book_id' => $_POST['bid'],
								'style_name' => $style_name,
								'style_data' =>$updated_data,
								'type' => $_POST['style_type']
							)
				);
				$result['status'] = 'true';
				$result['msg'] = 'Style Updated successfully';
			}
			$result['data'] = pubml_styles_dropdown($name = 'style',$bid=$_POST['bid']);
		}	  
		else {
				$result['status'] = 'false';
				$result['msg'] = 'Failed';		
		}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_insert_page_style', 'pubml_media_insert_page_style');
	add_action('wp_ajax_nopriv_pubml_media_insert_page_style', 'pubml_media_insert_page_style');
	
	/*
	* Process ajax style information.
	*
	* @access public
	* @return void
	*/
	function pubml_media_get_style() {
		global $pubml;
		global $wpdb;
		$style_data = serialize($_POST);
		if($_POST ){
			if($_POST['style_class']=='custom'){
					$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$_POST['bid']} AND {$wpdb->prefix}book_style.type='style'";
					$myrows = $wpdb->get_results($query, OBJECT);
					foreach($myrows as $row){
						$rowdata = unserialize($row->style_data);
						$result['data'] = $rowdata[$_POST['style_val']] ;
					}
			}
			else if($_POST['style_class']=='default'){
				$result['data']= pubml_styles_default_values($_POST['style_val']);
			}
				$result['status'] = 'true';
				$result['msg'] = 'Style added successfully';
		}  
		else {
				$result['status'] = 'false';
				$result['msg'] = 'Failed';		
		}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_get_style', 'pubml_media_get_style');
	
			/*
	* Process ajax style information.
	*
	* @access public
	* @return void
	*/
	function pubml_media_save_style_form() {
		global $pubml;
		global $wpdb;
		$serializedData = $_POST['style_data'];
		$bid = $_POST['bid'];
		$unserializedData = array();
		$alldata = parse_str($serializedData,$unserializedData);
		$all_data = serialize($unserializedData);
				
		$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$bid} AND {$wpdb->prefix}book_style.type='all-data'";
		$myrows = $wpdb->get_results($query, OBJECT);
		if($_POST){
				if(!empty($myrows)){
					$wpdb->update($wpdb->prefix.'book_style', array('style_name'=>'all-data', 'style_data'=>$all_data,'type'=>'all-data'), array('book_id'=>$bid,'type'=>'all-data'));	
				}
				else{	
					$wpdb->insert(
						$wpdb->prefix.'book_style',
						array(
							'book_id' => $bid,
							'style_name' => 'all-data',
							'style_data' =>$all_data,
							'type' => 'all-data'
						)
					);
				}
				$result['msg'] = 'Changes Saved';
			}
					
		else {
				$result['status'] = 'false';
				$result['msg'] = 'Failed';		
		}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_save_style_form', 'pubml_media_save_style_form');

		/*
	* Process ajax style information.
	*
	* @access public
	* @return void
	*/
	function pubml_media_delete_style() {
		global $pubml;
		global $wpdb;
		if($_POST ){
			$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$_POST['bid']} AND {$wpdb->prefix}book_style.type='style'";
			$myrows = $wpdb->get_results($query, OBJECT);
			if(!empty($myrows)){
			foreach($myrows as $data){
				$arr = unserialize($data->style_data);
			}
				foreach($arr as $key => $value){
					if ($key == $_POST['style_val']) unset($arr[$key]);
					$updated_data = serialize($arr);
				}
					$wpdb->update($wpdb->prefix.'book_style', array('book_id'=>$_POST['bid'], 'style_data'=>$updated_data), array('book_id'=>$_POST['bid'],'type' => 'style'));
					$result['msg'] = 'Style Deleted successfully';
					$result['data'] = pubml_styles_dropdown($name = 'style',$bid=$_POST['bid']);
			}
		}  
		else {
				$result['status'] = 'false';
				$result['msg'] = 'Failed';		
		}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_delete_style', 'pubml_media_delete_style');
	//add_action('wp_ajax_nopriv_pubml_media_delete_style', 'pubml_media_delete_style');
	
			/*
	* Process ajax style information.
	*
	* @access public
	* @return void
	*/
	function pubml_media_restore_style() {
		global $pubml;
		global $wpdb;
		if($_POST ){
				$data = pubml_styles_default_values();
				$style_data = serialize($data);
				$wpdb->update($wpdb->prefix.'book_style', array('book_id'=>$_POST['bid'], 'style_data'=>$style_data), array('book_id'=>$_POST['bid'],'type'=>'style'));
				$result['msg'] = 'Style Restored successfully';
				$result['data'] = pubml_styles_dropdown($name = 'style',$bid=$_POST['bid']);
		}  
		else {
				$result['status'] = 'false';
				$result['msg'] = 'Failed';		
		}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_restore_style', 'pubml_media_restore_style');
	
		/*
	* Process ajax get page styles information.
	*
	* @access public
	* @return void
	*/
	function pubml_media_get_page_style() {
		global $pubml;
		global $wpdb;
		if($_POST ){
					$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$_POST['bid']} AND {$wpdb->prefix}book_style.id={$_POST['style_val']}";
					$myrows = $wpdb->get_results($query, OBJECT);
					foreach($myrows as $row){
						$result['data'] = unserialize($row->style_data);
					}
				$result['status'] = 'true';
				$result['msg'] = 'Style added successfully';
		}  
		else {
				$result['status'] = 'false';
				$result['msg'] = 'Failed';		
		}				
		echo json_encode($result);
		exit();		
	}

	add_action('wp_ajax_pubml_media_get_page_style', 'pubml_media_get_page_style');
		
	/*****************************************************************************************/
	/********** Function start to generate book preview *************/
	/*****************************************************************************************/	

	function pubml_generate_preview(){
		$result = array();
			@$book_id = @$_POST['bookId'];
			@$showBadge = @$_POST['showBadge'];
		try{	
			$book_term = get_term($book_id,'book');
			$bookslug = $book_term->slug;  
			$upload_dir = wp_upload_dir();
			$del_folder = $upload_dir['basedir'].'/'.$bookslug;
			$data = pubml_generate_book($book_id, $showBadge);	// Return the status from the book form book generate function
			if(!empty($bookslug)){
				 if($del_folder != $upload_dir['basedir']){
					shell_exec("rm -r $del_folder");
				 }
			}
						
			$book_abs_path = str_replace(WP_CONTENT_URL, WP_CONTENT_DIR, $data);	

			if (!file_exists($book_abs_path)) {
				$result['bookId'] = $book_id;
					$result['status'] = 'false';
					$result['msg'] = 'Some thing went wrong! PubML eBook could not be generated';
					$result['error'] =  'pubml_not_created'; 
				echo json_encode($result);	
				exit(0);
			}				
			
			WP_Filesystem();
			$unzipfile = unzip_file( $book_abs_path, $upload_dir['basedir'].'/'); 
			if ( $unzipfile ) {
				$book_term = get_term($book_id,'book');
				$bookslug = $book_term->slug;  
				$filename = scandir($upload_dir['basedir'].'/'.$bookslug);
				unset($filename[0]);
				unset($filename[1]);
				foreach($filename as $indexfile){
					if($indexfile == 'index.html'){
						$result['preview'] = $bookslug.'/'.$indexfile;
					}
				}
				$result['status'] = 'true';
			} else {
				$result['status'] = 'false';
				$result['msg'] = 'There was an error unzipping the file.';       
			}
				echo json_encode($result);
				exit(0);
		}catch (Exception $e) {
			$result['status'] = 'false';
			$result['msg'] = 'Some thing went wrong [Caught exception: '. $e->getMessage(). ']'; 			
			$result['error'] =  'error';
			json_encode($result);
			exit(0);			
		}		
	}
	
	add_action('wp_ajax_pubml_generate_preview', 'pubml_generate_preview');
	add_action('wp_ajax_nopriv_pubml_generate_preview', 'pubml_generate_preview');
	
	