<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	*	Background File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used to manage book background data under styles section.
	*	---------------------------------------------------------------------
	*/
?>
<div class="styles-container" id="book-style-background">

				<div class="custom-back">
					<h3>Custom Screen Background</h3>
					<span>
						<a class="button button-primary button-large upload-book-background" id="upload-back-image" href="#">Choose a Background</a>
						<a class="button button-primary button-large" id="restore-back-image" href="javascript:void(0);">Restore Background</a>
						<span class="help openhelp" id="styles_background" style="margin-left:10px"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span>
						<input type="hidden" id="back-img-val" name="background[back-img-val]" value="<?php echo (!empty($data['background']['back-img-val'])) ? $data['background']['back-img-val'] :  PUBML_BASE_URL.'/images/custom_back.jpg'; ?>" />
					</span>

					<span style="float:right;">Upload paper textures and page backgrounds as seamless tiles at 72 ppi.<br/><br/>Large files add to the overall size of your webbook and increase loading times.<br/><br/>Leave these settings as is to use the default textures and colors.</span>

					<span class="back-radios">
						<?php
						$checked = (@$option == $data['background']['background-type'])? ' checked="checked"' : '';
						$v1 = 'unchecked';
						$v2 = 'unchecked';

						if (isset($data)) {
							$selected_radio = $data['background']['background-type'];

							if ($selected_radio == 'tile') {
								$v1 = 'checked';
							}

							else if ($selected_radio == 'full') {
							$v2 = 'checked';
								}

						}
						?>

						<span><input style="float:left;margin-right:3px;" type="radio" id="tile-screen" class="background-type" name="background[background-type]" value="tile" <?php echo $v1; ?> checked="checked" /><h5 style="float:left;margin-top:-6px;">Tile Background</h5></span>
						<span><input style="float:left;margin-right:3px;" type="radio" id="full-screen" class="background-type" name="background[background-type]" value="full" <?php echo $v2; ?> /><h5 style="float:left;margin-top:-6px;">Full-Screen Background</h5></span>
					</span>

					<span class="background-prev">
						<span  class="cus-image"><img class="cback" width="80" height="80" src="<?php echo (!empty($data['background']['back-img-val'])) ? $data['background']['back-img-val'] : PUBML_BASE_URL.'/images/custom_back_80x80.jpg'; ?>"><h6>Custom</h6></span>
						<span><img class="def-image" width="80" height="80" src="<?php echo PUBML_BASE_URL;?>/images/default_back_80x80.jpg"><h6>Default</h6></span>
						<input type="hidden" name="background[custom-image]" value="<?php echo (!empty($data['background']['back-img-val'])) ? $data['background']['back-img-val'] : PUBML_BASE_URL.'/images/custom_back.jpg'; ?>" />
						<input type="hidden" name="background[default-image]" value="<?php echo PUBML_BASE_URL;?>/images/default_back.jpg" />
						<input type="hidden" id="custom-image-thumb"  name="background[custom-image-thumb]" value="<?php echo (!empty($data['background']['custom-image-thumb'])) ? $data['background']['custom-image-thumb'] : PUBML_BASE_URL.'/images/custom_back_80x80.jpg'; ?>" />
						<input type="hidden" id="default-image-thumb" name="background[default-image-thumb]" value="<?php echo (!empty($data['background']['default-image-thumb'])) ? $data['background']['default-image-thumb'] : PUBML_BASE_URL.'/images/default_back_80x80.jpg'; ?>" />
						<input type="hidden"  id="restore-custom-img" value="<?php echo PUBML_BASE_URL.'/images/custom_back.jpg'; ?>" />
						<input type="hidden" id="restore-custom-img-thumb"  value="<?php echo PUBML_BASE_URL.'/images/custom_back_80x80.jpg'; ?>" />
						
					</span>
				</div>

				<div class="custom-back">
					<h3>Custom Paper Color</h3>
					<span>
						<a class="button button-primary button-large upload-book-background" id="upload-paper-image" href="#">Choose a Paper Texture</a>
						<span class="help openhelp" id="styles_background" style="margin-left:10px"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span>
						<input type="hidden" name="background[paper-img-val]" id="paper-img-val" value="<?php echo (!empty($data['background']['paper-img-val'])) ? $data['background']['paper-img-val'] : PUBML_BASE_URL.'/images/leftpage_white.png'; ?>" />
						<input type="hidden" name="background[def-paper-img-val]" id="def-paper-img-val" value="<?php echo (!empty($data['background']['def-paper-img-val'])) ? $data['background']['def-paper-img-val'] : PUBML_BASE_URL.'/images/default_paper.jpg'; ?>" />
					</span>
				<div>
					<span style="float:left;">
						 <h5>Select a Custom Paper Color from the color picker</h5>
						 <span>Current Color: <input class="color" name="background[color-val]" value="<?php echo (!empty($data['background']['color-val'])) ? $data['background']['color-val'] : 'F8EAD0'; ?>"></span>
					</span>
					<span style="float:right;">Choose a custom paper color even if you upload a custom paper texture.<br/><br/>The color will load immediately and the texture image will then load on top of it.</span>
				</div>
			</div>
		</div>