<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/**

 * PubML Book Export Section

 *

 * Functions to export the PubML Books and create the seprate zip files accordingly..

 *

 * @author 		SynapseIndia

 * @category 	Core

 * @package 	PubML/Functions/AJAX

 * @version     0.0.1

 */	

global $wpdb;

if(@$_GET['action']=='export'){

	$book_id = @$_GET['bookid'];

	echo $book_id;

	$book_slug = get_term_by('id', $book_id, 'book');

/**********************************************

************************************************/





	

    if (@$_GET["submit"] == 'Clear Old Zip Files') {

        clear_old_zips();

        print "<p>Old zip files deleted.</p>";

        exit(0);

    }

    //$in =  $_POST['selected_values'];

    $in =  '422,421,369,355,353,352,351';

	

	$chapt_array = fn_get_chapters($book_id);

	$array_in = implode(",", $chapt_array);

			

	$sql = "SELECT p.ID, u.ID as user_id, u.display_name, p.post_title, p.post_content, p.post_date, p.guid, ";

    $sql .= "SUM(LENGTH(p.post_content) - LENGTH(REPLACE(p.post_content, ' ', ''))+1) as words ";

	$sql .= "FROM " . $wpdb->prefix . "posts as p, ". $wpdb->prefix ."users as u ";

	//$sql .= "WHERE p.ID in (". rtrim($in, ",") . ") AND p.post_type = 'pubml_books' AND u.ID = p.post_author ";

	$sql .= "WHERE p.ID in (".$array_in.") AND p.post_type = 'pubml_books' AND u.ID = p.post_author ";

	$sql .= "GROUP BY p.ID ";

	$sql .= "ORDER BY p.post_date desc";

	

	echo $sql;	

	// die('Close');



	$rows = $wpdb->get_results($sql);

	

	// print "<pre>" . $sql . "</pre>";

	// die('Close');

	

	if ($rows) :

	

	

	    # create zip file

        $f = 'stories-'.time().'.zip';

        $upload_dir = wp_upload_dir();

        $dir = $upload_dir['path'];

	    $filename = $dir.'/'.$f;		

		



	    if ($upload_dir['error']) { 

	        print '<p>' . $upload_dir['error'] . '</p>';

	        exit(0);

	    }

        if (! is_dir($dir)) {

            

            print '<p>Upload directory: ' . $dir .'<br/>';

            print 'ERROR: Directory does not exist.<br/></p>';

            exit(0);

        }

        if (! is_writable($dir)) {

            print '<p>Upload directory: ' . $dir .'<br/>';

            print 'ERROR: Directory is not writable.<br/></p>';

            exit(0);        

        }



        $url = $upload_dir['url'] . '/'. $f;

	    $zip = new ZipArchive;

	    $res = $zip->open($filename, ZipArchive::CREATE) or die('Could not create file.');

	    if ($res == TRUE) {

	        $zip->addEmptyDir('stories');

            $export_posts_tag = get_option('export_posts_tag');

            $export_posts_tag_id = 0;



    		foreach ($rows as $row) {

    		    $xml = "";

                if ($export_posts_tag) {

    		        # update the status to printed

                    #$tag = get_or_create_tag($export_posts_tag);

                    #$wpdb->insert($wpdb->term_relationships, 

                    #    array('object_id' => $row->ID, 'term_taxonomy_id' => $tag['term_taxonomy_id'], 'term_order' => 0),

                    #    array('%d', '%s', '%d'));

                    

                    #$wpdb->query($sql);



                    $tag = get_term_by('name', $export_posts_tag, 'post_tag');

                    wp_set_object_terms($row->ID, $tag->name, 'post_tag', True);

                    clean_post_cache($row->ID);

                    # add export-posts-date meta

                    update_post_meta($row->ID, 'export-posts-date', date('Y-m-d'));

                    update_post_meta($row->ID, 'e_section_status', 'printed');

                }



                               

                

                $story = '';

				$html_story = $story . "\n" . $row->post_content;

				$xml_title = htmlspecialchars($row->post_title);

            

               # $story .= "\nWords: " . $row->words . ", Inches: " . export_posts_inches('inches', $row->ID);

                                    

    		    $xml .= "</". strtolower(strip_to_alpha_only($row->post_title)) .">\n";

    		    $extension = ".txt";

    		    if ($_GET['output'] != 'html') {

                    $story = strip_tags($story);

                } else {

                    $html_head = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n";

                    $html_head .= "\t\"http://www.w3.org/TR/html4/strict.dtd\">\n";

                    $html_head .= "<head>\n\t<title>" . $row->post_title . "</title>\n";

                    $html_head .= "\t<meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\">\n";

                    $html_head .= "</head>\n<body>\n";

                    

                    $html_tail = "\n</body>\n</html>\n";

                    $story = nl2br($html_story);

                    $story = $html_head . $story . $html_tail;

                }

                

                if ($_GET['output'] == 'html') { $extension = ".html"; }

                if ($_GET['output'] == 'xml') { $extension = ".xml"; }





               $story = iconv("UTF-8", "ascii//TRANSLIT", $story);



    		    $zip_name = "sections/" . $row->post_title . $extension;

    		    if ($_GET['output'] == 'xml') {

    		        $xml = preg_replace("/\r\n\r\n+/s","\r\n",$xml);        

    		        $zip->addFromString($zip_name, $xml);

    		    } else {

    		        $zip->addFromString($zip_name, $story);

    		    }

    		}

    		$zip->close();  

			

			print "<pre>" . $sql . "</pre>";

			die('Close'.$filename);



            # update tag_count

            if ($export_posts_tag) {

		        # update the status to printed

                $tag = get_or_create_tag($export_posts_tag);

                $update_tag_sql = "UPDATE " . $wpdb->term_taxonomy . " t SET count=". 

                $update_tag_sql .= "(SELECT count(l.object_id) FROM " . $wpdb->term_relationships . " l ";

                $update_tag_sql .= "WHERE l.term_taxonomy_id = " . $tag['term_taxonomy_id'] . ") ";

                $update_tag_sql .= "WHERE t.term_taxonomy_id = ". $tag['term_taxonomy_id'];

                $wpdb->query($update_tag_sql);

            }

            ?>



            <div id="content" class="narrowcolumn">



            	<p>

                You can download your zip file <a id="zip_url" href="<?php echo $url; ?>">here</a>.

            	</p>



            </div>



            <?php 

	    } else {

	        print "Could not create zip file";

	    }

	endif;

	



	

	

	

	

	

 /*********************************************

 ***********************************************/

}

	

// Function to returns all footnotes array	

function fn_get_footnotes($term_id) {	

	global $wpdb;

	$footnotes_array = array();

	$footnotes_query = query_posts(array( 

				'post_type' => 'pubml_footnotes',

				'showposts' => -1,

				'meta_query' => array(

					array(

						'key' => 'book',

						'value' => $term_id,

					)

				),

				'orderby' => 'title',

				'order' => 'ASC' )

			);	



	// The Loop

	if ( have_posts() ) {

		

		while ( have_posts() ) : the_post();

			$custom_footnote_image = get_post_meta(get_the_ID(),'custom_footnote_image',true);

			//$footnotes_array[] = (object)array(get_the_ID(), get_the_title(), $custom_footnote_image , get_the_content());

			array_push($footnotes_array,get_the_ID());

		endwhile;



	} else {

		// no posts found

	}

	/* Restore original Post Data */

	wp_reset_query();



	return $footnotes_array;	

}	



// Function to returns all chapters array

function fn_get_chapters($term_id) {	

	global $wpdb;

	$chapters_array = array();

	$chapters_query = query_posts(array( 

		'post_type' => 'pubml_books',

		'showposts' => -1,

		'tax_query' => array(

			array(

				'taxonomy' => 'book',

				'terms' => $term_id,

				'field' => 'term_id',

			)

		),

		'orderby' => 'title',

		'order' => 'ASC' )

	);	



	// The Loop

	if ( have_posts() ) {

		

		while ( have_posts() ) : the_post();

			//$chapters_array[] = (object)array(get_the_ID(), get_the_title(), get_the_content());

			array_push($chapters_array,get_the_ID());

		endwhile;



	} else {

		// no posts found

	}

	/* Restore original Post Data */

	wp_reset_query();



	return $chapters_array;	

}







function clear_old_zips() {

    $files = get_option('upload_path') . '/stories*.zip';

    $t = exec("rm $files", $r);

}



function get_status_list() {

    global $wpdb;

    $sql = "SELECT DISTINCT p.post_status FROM ".$wpdb->posts." p WHERE p.post_type='post' AND p.post_status <> 'trash'";

    $rows = $wpdb->get_results($sql);

    return $rows;

}





/**

 * Modifies a string to remove al non ASCII characters and spaces.

 */

function slugify($text)

{

    // replace non letter or digits by -

    $text = preg_replace('~[^\\pL\d]+~u', '-', $text);

 

    // trim

    $text = trim($text, '-');

 

    // transliterate

    if (function_exists('iconv'))

    {

        $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

    }

 

    // lowercase

    $text = strtolower($text);

 

    // remove unwanted characters

    $text = preg_replace('~[^-\w]+~', '', $text);

 

    if (empty($text))

    {

        return 'n-a';

    }

 

    return $text;

}





function replace_empty_lines($string)

{

    $string = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $string);

    return str_replace("\\n\\n", "\\n", $string);

}



function strip_to_alpha_only($string)

{

     $pattern = '/[^a-zA-Z]/';

     return preg_replace($pattern, '', $string);

}















//****************************************//

 

?>

<div id="book_meta">

        <h2 class="media-lib-icon"> &lt;PubML&gt;™ Book Export <i><?php echo $Book->name ;?></i></h2>

	

	<!--TABS------------------------------>

	<div class="primary_menu_bar">

		<?php fn_custom_tabs_main('My Books');?>

	</div>

		

	<div class="clear"></div>

		<div class="content_container book-export" style="float:left;">

		

		<?php 

		

		$fn_array = fn_get_footnotes($book_id);

		echo "<pre>";

			//print_r($fn_array);	

		echo "</pre>";

		

		$chapters_array = fn_get_chapters($book_id);

		echo "<pre>";

			//print_r($chapters_array);	

		echo "</pre>";

		

		

	

	

	//$loop = new WP_Query( array( 'post_status' => 'publish', 'post_type' => 'pubml_books', 'posts_per_page' => 20 ) );

	

	$sections_query = query_posts(array( 

		'post_type' => 'pubml_books',

		'showposts' => -1,

		'tax_query' => array(

			array(

				'taxonomy' => 'book',

				'terms' => $book_id,

				'field' => 'term_id',

			)

		),

		'orderby' => 'title',

		'order' => 'ASC' )

	);

	

	

	

	//die();

	echo '<pre>';

		//print_r($sections_query);

	echo '</pre>';	

	

	

	echo '<pre>';

		//print_r($rows);

	echo '</pre>';





	?>

		

		

		

			

		</div>

</div>

