<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/


	/*	

	*	Book Navigation File

	*	---------------------------------------------------------------------

	* 	@version	1.0

	* 	@author		SynapseIndia

	* 	@link		http://www.synapseindia.com

	*	---------------------------------------------------------------------

	*	This file is used to manage book navigation tabs.

	*	---------------------------------------------------------------------

	*/

	

$book_slug = @$_GET['book'];

$Book = get_term_by('slug', $book_slug, 'book');

$book_id=$Book->term_id;

$book_meta = get_option( "taxonomy_$book_id");

$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];

$edition_notes = ($book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';

// $tabs = query_posts(array( 

				// 'post_type' => 'pubml-navigation',

				// 'showposts' => -1,

				// 'meta_key' => 'sorting_status',

				// 'orderby' => 'meta_value_num', 

				// 'tax_query' => array(

					// array(

						// 'taxonomy' => 'book',

						// 'terms' => $book_slug,

						// 'field' => 'slug',

					// )

				// ),  

				// 'order' => 'ASC' )

			// );

			

			

// echo "<pre>"; print_r($Book); echo "</pre>";

// echo "<pre>"; print_r($tabs); echo "</pre>";

// exit;	





?>

<div id="book_meta">

<!--TABS------------------------------>

<div class="primary_menu_bar">

	<?php fn_custom_tabs_main('My Books');?>

</div>

<div class="clear"></div>

<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/navtabs_icon_64x64.png" width="64" height="64"  alt=""/></div>

<h2>Navigation tabs for <i><?php echo $Book->name;?><span style="font-size: 14px;font-style: normal;font-weight: bold;margin: 0;">&nbsp;(<?php echo $edition_notes ; ?>)</span></i><span class="help openhelp" id="tabs"><img src="<?php echo PUBML_BASE_URL;?>/images/help.png" style="margin-left: 10px;vertical-align: middle;"></span></h2>

<div class="secondary_menu_bar">

	<?php fn_custom_tabs_toc('Navigation');?>

</div>



	<div class="content_container" style="float:left;">

		<div class="settings_content">

			<div class="row-actionss" style="float:left;margin-right: 20px;width: 70%;">

				This section controls the order and content of the navigation tabs displayed above your web book. Drag and drop to change the order  of the tabs. The <b>Table of Contents</b> and <b>Settings</b> can be hidden or reordered but not edited.

			</div>

			<div class="row-actionss"  style="float:right">

				<a href="admin.php?page=book-new-tab&book=<?php echo $Book->slug;?>" class="button button-primary button-large">New Tab</a>

			</div>

			<div class="clear"></div>		

		<span class="instructions"><br/><strong>NOTE: </strong>Adding too many tabs may make your web book too wide for phones or tablets.</span>	

		</div>

	<div class="clear"></div>	

	<div id="info"></div>

	

	<ul id="test-list">		

		<div class="tbl_th" style="width:100%;float:left;clear:both; ">

				<div class="chapdata chap_edit">Edit</div>

				<div class="chapdata chap_del">Delete</div>

				<div class="chapdata chap_desc" style="float: left;">View</div>

				<div class="chapdata chap_date" style="float:right;width:135px;">Date Modified</div>			

		</div>

		<div class="clear"></div>

		

		<li id="listItem_1">

			<div class="name column-name chap_edit">

				<img src="<?php echo PUBML_BASE_URL;?>/images/edit.png" class="tbl_icon" style="opacity:0.4;">

			</div>

			<div class="chap_del">

				<img src="<?php echo PUBML_BASE_URL;?>/images/delete.png" class="tbl_icon" style="opacity:0.4;">

			</div>

			<div class="chap_desc">

				<span class="book_name"><strong>TOC</strong></span>

				<span class="move_page"> 

					<span style="padding: 0 10px 0 0; vertical-align: top;">

						<input type="checkbox" value="" class="">Hide Tab

					</span>

					<img src="<?php echo PUBML_BASE_URL;?>/images/move.png" alt="move" title="Move to set order" class="handle tbl_icon" />

				</span>						

			</div>					

		</li>

		<li id="listItem_2">

			<div class="name column-name chap_edit">

				<img src="<?php echo PUBML_BASE_URL;?>/images/edit.png" class="tbl_icon" style="opacity:0.4;">

			</div>

			<div class="chap_del">

				<img src="<?php echo PUBML_BASE_URL;?>/images/delete.png" class="tbl_icon" style="opacity:0.4;">

			</div>

			<div class="chap_desc">

				<span class="book_name"><strong>Settings</strong></span>

				<span class="move_page"> 

					<span style="padding: 0 10px 0 0; vertical-align: top;">

						<input type="checkbox" value="" class="">Hide Tab

					</span>

					<img src="<?php echo PUBML_BASE_URL;?>/images/move.png" alt="move" title="Move to set order" class="handle tbl_icon" />

				</span>						

			</div>					

		</li>



		<!-- Getting the list of books -->

		<?php



			$tabs = query_posts(array( 

				'post_type' => 'pubml-navigation',

				'showposts' => -1,

				'meta_key' => 'sorting_status',

				'orderby' => 'meta_value_num',

				'tax_query' => array(

					array(

						'taxonomy' => 'book',

						'terms' => $book_slug,

						'field' => 'slug',

					)

				),

				'order' => 'ASC' )

			);

			

			//die(count($tabs));



			foreach ($tabs as $tab) {

				$section_type = get_post_meta($tab->ID, 'section_type',true);	?>

				<li id="listItem_<?php echo $tab->ID;?>">

					<div class="name column-name chap_edit">

						<a href="admin.php?page=book-new-tab&tabs=<?php echo $tab->ID;?>&book=<?php echo $book_slug; ?>&action=edit"><img src="<?php echo PUBML_BASE_URL;?>/images/edit.png" class="tbl_icon"></a>

					</div>

					<div class="chap_del"><a href="JavaScript:void(0);" id="<?php echo $tab->ID;?>" class="delete-section-post"><img src="<?php echo PUBML_BASE_URL;?>/images/delete.png" class="tbl_icon"></a></div>

					<div class="chap_desc">

						<a href="admin.php?page=book-new-tab&tabs=<?php echo $tab->ID;?>&book=<?php echo $book_slug; ?>&action=edit"><span class="book_name"><strong><?php echo $tab->post_title; ?></strong></span>

						</a>

						<span class="move_page"> <span style="padding: 0 10px 0 0; vertical-align: top;"> <?php echo date("M. d, Y",strtotime($tab->post_modified)) ; ?> </span>

							<img src="<?php echo PUBML_BASE_URL;?>/images/move.png" alt="move" title="Move to set order" class="handle tbl_icon" />

						</span>

						

					</div>					

				</li>

		<?php } ?>

	</ul>	



	</div>

</div>

<?php

########### Print sorting js in footer

function sorting_script() { //javascript calling function above

global $post;

?>

<script type="text/javascript">

  // When the document is ready set up our sortable with it's inherant function(s)

  jQuery(document).ready(function() {



/* for sorting digital pages */

    jQuery("#test-list").sortable({

      handle : '.handle',

      update : function () {

		  var order = jQuery('#test-list').sortable('serialize');

		    var data = 'action=sortingQuestions&'+order;

			jQuery.ajax ({

				type: 'POST',

				url: ajaxurl,

				data: data,

				dataType:'json',

				success: function(response) {    



					if(response.status == 200){

						//jQuery("#info").show();

						//jQuery("#info").html('New order saved');

					}

				}

			});



      }

    });

});



</script>

<?php

}

add_action('admin_print_footer_scripts', 'sorting_script'); //Sorting script

?>

<!-- Script to remove section -->

<script type="text/javascript">

jQuery(document).ready(function($) {

	$(".delete-section-post" ).click(function() {

	var postid = $(this).attr('id');

	var data = {

		action: 'delete_post_custom',

		post_id: postid

	};

		$("#listItem_"+postid).css('background-color','#FF0000');

		if(confirm("Are you sure want to remove this section?")){

				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php

				$.post(ajaxurl, data, function(response) {

						$("#listItem_"+response.post_id).remove();



				}, "json");

		} else {

		$("#listItem_"+postid).css('background-color','#EEE');

		}

	});

});

</script>



