<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	

	*	New Navigation File

	*	---------------------------------------------------------------------

	* 	@version	1.0

	* 	@author		SynapseIndia

	* 	@link		http://www.synapseindia.com

	*	---------------------------------------------------------------------

	*	This file is used to add new navigation.

	*	---------------------------------------------------------------------

	*/

	

$book_slug = @$_GET['book'];

$Book = get_term_by('slug', $book_slug, 'book');

$action = @$_GET['action'];

$tabs_id = @$_GET['tabs'];

$tabs_type = @$_GET['tabs_type'];

if(!$tabs_type) { $tabs_type = 'text'; }



if($action=='edit') { 

	$act_type = 'edit'; 

	$tabs = get_post($tabs_id);

} else { 

	$act_type = 'add'; 

}

?>



<script>

	// Alert when you have unsaved changes in the forms Start

	var unSavedData = false;

	jQuery(document).ready(function($) {	

		jQuery(":input").change(function(){ //trigers change in all input fields including text type

			unSavedData = true;

		});

		jQuery("textarea").change(function(){ //trigers change in all input fields including text type

			unSavedData = true;

		});

		

		function unloadPage(){ 

			console.log(unSavedData);

			if(unSavedData){

				return "You have unsaved changes on this page. Do you want to leave this page and discard your changes or stay on this page?";

			}

		}

		window.onbeforeunload = unloadPage;	// Alert when you have unsaved changes in the forms Start

	});



</script>



<div id="book_meta">

<!--TABS------------------------------>

<div class="primary_menu_bar">

	<?php fn_custom_tabs_main('My Books');?>

</div>

<div class="clear"></div>

<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/new_section_icon_64x64.png" width="64" height="64"  alt=""/></div>

<h2>New Tabs for <i><?php echo @$Book->name;?></i><span class="help openhelp" id="tabs"><img src="<?php echo PUBML_BASE_URL;?>/images/help.png" style="margin-left: 10px;vertical-align: middle;"></span></h2>

<div class="secondary_menu_bar">

	<?php fn_custom_tabs_toc('Navigation');?>

</div>



	<div class="content_container">	

	<div id="message"></div>

	<div class="clear"></div>

	

		<form method="post" id="NewTabs" action="">

			<div class="div_section_title">

				<input type="text" name="pubml_post_title" class="tabs_title" id="tabs_title" placeholder="Enter tab title here" value="<?php echo @$tabs->post_title;?>">

			</div>

			<div class="section_desc">

				<?php			

					$tabs_content = @$tabs->post_content;

					$tabs_editor_id = 'pubml_post_content';

					wp_editor( $tabs_content, $tabs_editor_id );

				?>

				<div class="clear"></div>

				<div class="submit_section" style="margin: 10px; text-align: right; width: 98%;">

					<a href="admin.php?page=pubml-book-navigation&book=<?php echo $book_slug;?>" id="return_tabs" class="button_sec button-primary button-large">Return to Tab list</a>

					<input type="submit" id="save_section" name="save_section" value="Save Section"  class="button_sec button-primary button-large">

				</div>	

			</div>



			<div class="section_buttons">

				<input type="hidden" name="pubml_post_type" id="pubml_post_type" value="pubml-navigation">		

				<input type="hidden" name="tabs_type" id="tabs_type" value="<?php echo $tabs_type;?>">	

				<input type="hidden" name="pubml_post" value="<?php echo $tabs_id;?>">

				<input type="hidden" name="act_type" value="<?php echo $act_type;?>">				

			</div>

			<div class="clear"></div>

		</form>

	</div>

</div>



<?php

########### Print sorting js in footer

function submit_tabs_form() { //javascript calling function above

global $post;

?>

<script type="text/javascript">

/* Validation controller */

jQuery(function(){

    // Initialise the validator

jQuery('#NewTabs').validate();

    // Add the rules to the classname hooks

	jQuery.validator.addClassRules({

		tabs_title: {

			 required: true

		}

	});

});



	// When the document is ready set up our sortable with it's inherant function(s)

	jQuery(document).ready(function($) {	

	

	/* for sorting digital pages */

    jQuery("#NewTabs").submit(function( event ) {

	

		jQuery('#message').removeAttr( "class");

		jQuery('#message').html('').removeAttr( "style");

	

	 //validating text editor for text type section only

		var tabs_type = jQuery('#tabs_type').val();

		if(tabs_type=='text'){

			tinyMCE.triggerSave();			

		}

	//validating title for empty values

		var section_title = jQuery.trim(jQuery('.tabs_title').val());

		if(section_title==''){ return false; }

		  var tabs_data = jQuery(this).serialize();

		  var data = 'action=CreateSection&'+tabs_data;

			jQuery.ajax ({

				type: 'POST',

				url: ajaxurl,

				data: data,

				dataType:'json',

				success: function(response) {    



					if(response.status == 200){

						jQuery('#message').addClass('success');

						jQuery('#message').html('Section Saved').fadeOut(2500);

					}

					unSavedData = false;	

					if(response.act_type=='add'){

						location.href='admin.php?page=book-new-tab&tabs='+response.pubml_post_id+'&book='+response.book+'&action=edit';

					}

					

				}

			});



		// Stop form from submitting normally

		event.preventDefault();



    });

});



</script>

<?php

}

add_action('admin_print_footer_scripts', 'submit_tabs_form'); //Sorting script

add_action('admin_enqueue_scripts', 'section_media_uploader_scripts');

?>