<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/


	/*	

	*	New Section File

	*	---------------------------------------------------------------------

	* 	@version	1.0

	* 	@author		SynapseIndia

	* 	@link		http://www.synapseindia.com

	*	---------------------------------------------------------------------

	*	This file is used to add new chapters/sections.

	*	---------------------------------------------------------------------

	*/

	

$book_slug = @$_GET['book'];
$Book = get_term_by('slug', $book_slug, 'book');
$book_id=$Book->term_id;
$book_meta = get_option( "taxonomy_$book_id");
$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];
$edition_notes = ($book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';
$action = @$_GET['action'];
$section_id = @$_GET['section'];
$section_type = @$_GET['section_type'];
if(!$section_type) { $section_type = 'text'; }
wp_enqueue_script('wpdialogs'); 
wp_enqueue_style('wp-jquery-ui-dialog'); 

if($action=='edit') { 
	$act_type = 'edit'; 
	$section = get_post($section_id);
} else { 
	$act_type = 'add'; 
}

$_heading_title = ($act_type == 'add') ? 'New': 'Edit' ;



?>

<script>

	// Alert when you have unsaved changes in the forms Start

	var unSavedData = false;

	jQuery(document).ready(function($) {	

		jQuery(":input").change(function(){ //trigers change in all input fields including text type

			unSavedData = true;

		});

		jQuery("textarea").change(function(){ //trigers change in all input fields including text type

			unSavedData = true;

		});

		function unloadPage(){ 

			console.log(unSavedData);

			if(unSavedData){

				return "You have unsaved changes on this page. Do you want to leave this page and discard your changes or stay on this page?";

			}

		}

		window.onbeforeunload = unloadPage;	// Alert when you have unsaved changes in the forms Start

	});



</script>





<div id="book_meta">

<!--TABS------------------------------>

<div class="primary_menu_bar">

	<?php fn_custom_tabs_main('My Books');?>

</div>

<div class="clear"></div>

<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/new_section_icon_64x64.png" width="64" height="64"  alt=""/></div>

<h2><?php echo $_heading_title; ?> Section for <i><?php echo $Book->name;?><span style="font-size: 14px;font-style: normal;font-weight: bold;margin: 0;">&nbsp;(<?php echo $edition_notes ; ?>)</span></i></h2>

<div class="secondary_menu_bar">

	<?php fn_custom_tabs_toc('Table of Contents');?>

</div>



	<div class="content_container">	

	<div id="message"></div>

	<div class="clear"></div>

	<div class="settings_content">

	         
		<div class="row-actionss" style="max-width:800px;">
			<div style="float:right;">
			<a href="admin.php?page=book-new-section&book=<?php echo $Book->slug;?>&section_type=text" class="button button-primary button-large" style="margin-right: 10px;">New Text Section</a>

			<a href="admin.php?page=book-new-section&book=<?php echo $Book->slug;?>&section_type=image" class="button button-primary button-large">New Full-Page Image</a>
			</div>
		</div>

	</div>

	<div class="clear"></div>

	

		<form method="post" id="NewSection" action="">

			<div class="div_section_title">

				<input type="text" name="pubml_post_title" class="section_title" id="section_title" placeholder="Please enter section title here" value="<?php echo @$section->post_title;?>">

			</div>

			<div class="section_desc">

		<?php

				if($section_type=='image'){

					$custom_section_image = get_post_meta($section_id,'custom_section_image',true);

		?>

				<div class="section_main_image">

					<div class="sec_img">

						<div id='sec_img_div'>

							<?php if($custom_section_image) { ?><img src="<?php echo $custom_section_image;?>" class="custom_section_image">

							<?php } else { echo "<h1>Upload image for section</h1>"; }?>

						</div>

						<input type="hidden" name="custom_section_image" id="custom_section_image" value="<?php echo $custom_section_image;?>" />

					</div>

					<div class="sec_btns">

						<a class="button-primary button-large" data-editor="custom_section_image" id="upload_image_button" href="#">Upload/Add image</a>

						<a class="remove_img_btn button-primary button-large" id="remove_img_button" href="#">Remove Image</a>

					</div>

				</div>

		<?php

				} else {

					$Section_content = @$section->post_content;
					$Section_content = wpautop($Section_content);

					$Section_editor_id = 'pubml_post_content';
				
					$seprateCSS = '<style id="editorbookCSS">';
					$seprateCSS .= 'html { font-size: 62.5%; font-weight: normal; }';
					$seprateCSS .= pubml_style_editor_css($book_id);
					$seprateCSS .= '</style>';
					
					$settings = array('wpautop' => false, 'editor_css'=> $seprateCSS, 'tinymce' => array(
        'theme_advanced_buttons1' => 'bold,italic,underline',
        'theme_advanced_buttons2' => '',
        'theme_advanced_buttons3' => ''
    ));

					wp_editor( $Section_content, $Section_editor_id, $settings);

				}

				?>

			</div>



			<div class="section_buttons" style="max-width:800px;height:15px;">
				<div style="float:right">
				<input type="hidden" name="pubml_post_type" id="pubml_post_type" value="pubml_books">

				<input type="hidden" name="section_type" id="section_type" value="<?php echo $section_type;?>">

				<input type="hidden" name="pubml_post" value="<?php echo $section_id;?>">

				<input type="hidden" name="act_type" value="<?php echo $act_type;?>">

				<input type="submit" id="save_section" name="save_section" value="Save Section" class="button_sec button-primary button-large">
				</div>
			</div>

		</form>

	</div>

</div>



<?php

########### Print sorting js in footer

function submit_section_form() { //javascript calling function above

global $post;

?>

<script type="text/javascript">

/* Validation controller */

jQuery(function(){

    // Initialise the validator

jQuery('#NewSection').validate();

    // Add the rules to the classname hooks

	jQuery.validator.addClassRules({

		section_title: {

			 required: true

		}

	});

});



  // When the document is ready set up our sortable with it's inherant function(s)

	jQuery(document).ready(function($) { 
	/* for sorting digital pages */
    jQuery("#NewSection").submit(function( event ) {
		jQuery('#message').removeAttr( "class");
		jQuery('#message').html('').removeAttr( "style");
		//validating text editor for text type section only
		var section_type = jQuery('#section_type').val();
		if(section_type=='text'){
			tinyMCE.triggerSave();		
		}
	//validating title for empty values
		var section_title = jQuery.trim(jQuery('.section_title').val());
		if(section_title==''){ return false; }
		  var section_data = jQuery(this).serialize();
		  var data = 'action=CreateSection&'+section_data;
			jQuery.ajax ({
				type: 'POST',
				url: ajaxurl,
				data: data,
				dataType:'json',
				success: function(response) {    
					if(response.status == 200){
						jQuery('#message').addClass('success');
						jQuery('#message').html('Section Saved').fadeOut(2500);
					}
					unSavedData = false;
					if(response.act_type=='add'){
						location.href='admin.php?page=book-new-section&section='+response.pubml_post_id+'&book='+response.book+'&action=edit&section_type='+response.section_type;
					}
				}
			});
		// Stop form from submitting normally
		event.preventDefault();
    });



// Scripts for the media uploader

    var custom_uploader;

 

// Open wordpress media uploader



		$('#upload_image_button').click(function(e) {

	 

			e.preventDefault();

	 

			//If the uploader object has already been created, reopen the dialog

			if (custom_uploader) {

				custom_uploader.open();

				return;

			}

	 

			//Extend the wp.media object

			custom_uploader = wp.media.frames.file_frame = wp.media({

				title: 'Choose Image',

				button: {

					text: 'Choose Image'

				},

				multiple: false

			});

	 

			//When a file is selected, grab the URL and set it as the text field's value

			custom_uploader.on('select', function() {

				attachment = custom_uploader.state().get('selection').first().toJSON();

				$('#custom_section_image').val(attachment.url);

				$('#sec_img_div').html("<img src='"+attachment.url+"' class='custom_section_image'>");

				unSavedData = true;

			});

	 

			//Open the uploader dialog

			custom_uploader.open();

	 

		});



	// Remove image

		$('#remove_img_button').click(function(e) {

			jQuery('#sec_img_div').html('<h1>Upload image for section</h1>');

			jQuery('#custom_section_image').val('');



		});
		
		var styleContent = jQuery('style#editorbookCSS').html();
		setTimeout(function(){
			var $head = jQuery("iframe#pubml_post_content_ifr").contents().find("head");
			$head.append("<style>"+styleContent+"</style>");
		}, 1000);

			

});



</script>

<?php

}

add_action('admin_print_footer_scripts', 'submit_section_form'); //Sorting script

add_action('admin_enqueue_scripts', 'section_media_uploader_scripts');

?>