<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/


	/*	
	*	Sections File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used to manage sections listing.
	*	---------------------------------------------------------------------
	*/

$book_slug = @$_GET['book'];

$Book = get_term_by('slug', $book_slug, 'book');

$book_meta = get_option( "taxonomy_$Book->term_id");

$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];

$edition_notes = ($book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';

?>
<div id="book_meta">

<!--TABS------------------------------>

<div class="primary_menu_bar">

	<?php fn_custom_tabs_main('My Books');?>

</div>

<div class="clear"></div>

<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/table_of_contents_icon_64x64.png" width="64" height="64"  alt=""/></div>

<h2>Contents for <i><?php echo $Book->name;?><span style="font-size: 14px;font-style: normal;font-weight: bold;margin: 0;">&nbsp;(<?php echo $edition_notes ; ?>)</span></i><span class="help openhelp" id="toc"><img src="<?php echo PUBML_BASE_URL;?>/images/help.png" style="margin-left: 10px;vertical-align: middle;"></span></h2>

<div class="secondary_menu_bar">

	<?php fn_custom_tabs_toc('Table of Contents');?>

</div>



	<div class="content_container">

	<div class="settings_content">

	          <div class="row-actionss" style="float:left;margin-right: 20px;width: 702px;">
					In  &lt;PubML&gt;™ a "section" can be a chapter, a title page, am image, or any other kind of content.<br/>Use the buttons on the right to add new sections. Edit, delete, or drag and drop to reorder <br/>your eBook's sections below.<br><br>
                    <span style="color:#900";>Do not make a new section for your book cover. A cover is generated automatically from the cover<br>
image you uploaded when you created your eBook.</span>
				</div>
				<div class="row-actionss"  style="float:right">
					<a href="admin.php?page=book-new-section&book=<?php echo $Book->slug;?>&section_type=text" class="button button-primary button-large" style="margin-right: 10px;">New Text Section</a>

					<a href="admin.php?page=book-new-section&book=<?php echo $Book->slug;?>&section_type=image" class="button button-primary button-large">New Full-Page Image</a>
				</div>

	</div>

<div class="clear"></div>

<div id="info"></div>

<div class="cf nestable-lists">

    <div class="dd" id="nestable">

		<ol id="test-listsSS" class="dd-list">

		<!--<div class="tbl_th" style="width:100%;float:left;clear:both; ">

				<div class="chapdata chap_desc" style="float: left;">View</div>

				<div class="chapdata chap_desc" style="float: left;">Edition Notes</div>

				<div class="chapdata chap_edit">Edit</div>

				<div class="chapdata chap_del">Delete</div>			

		</div> -->

		<div class="clear"></div>

		<!-- Getting the list of books -->

		<?php



			$sections = query_posts(array( 
				'post_type' => 'pubml_books',
				'showposts' => -1,
				'meta_key' => 'sorting_status',
				'orderby' => 'meta_value_num', 
				'tax_query' => array(
					array(
						'taxonomy' => 'book',
						'terms' => $book_slug,
						'field' => 'slug',
						)
					),
				'meta_query' => array(
                    array(
                        'key' => 'toc_parent',
                        'compare' => 'NOT EXISTS'
						),
					),
				'order' => 'ASC' 
				)
			);

			

			foreach ($sections as $section) {

				$section_type = get_post_meta($section->ID, 'section_type',true);

?>

				<li class="toc-list-item dd-item" data-id="<?php echo $section->ID;?>" id="listItem_<?php echo $section->ID;?>">

					<div class="dd-handle" style="float:left;width:50%;height:30px;cursor:move;">

					<span style="float:left;" class="chap_desc"><a href="admin.php?page=book-new-section&section=<?php echo $section->ID;?>&book=<?php echo $book_slug; ?>&section_type=<?php echo $section_type;?>&action=edit"><span class="book_name"><strong><?php echo $section->post_title; ?></strong></span></a></span>

						<span class="move_page"> <span class="name column-name chap_edit"><a href="admin.php?page=book-new-section&section=<?php echo $section->ID;?>&book=<?php echo $book_slug; ?>&section_type=<?php echo $section_type;?>&action=edit"><img src="<?php echo PUBML_BASE_URL;?>/images/edit.png" class="tbl_icon"></a></span>

					<span class="chap_del"><a href="JavaScript:void(0);" id="<?php echo $section->ID;?>" class="delete-section-post"><img src="<?php echo PUBML_BASE_URL;?>/images/delete.png" class="tbl_icon"></a></span>

						</span>

					</div>

		<?php



			$child_sections = query_posts(array( 

				'post_type' => 'pubml_books',

				'showposts' => -1,

				'meta_key' => 'sorting_status',

				'orderby' => 'meta_value_num',

				'tax_query' => array(

					array(

						'taxonomy' => 'book',

						'terms' => $book_slug,

						'field' => 'slug',

					)

				),

				'meta_query' => array(

                  array(

                     'key' => 'toc_parent',

                     'value' => $section->ID

                  )),

				'order' => 'ASC' )

			);

			if(!empty($child_sections)){ ?>

			<ol id="test-listsSS" class="dd-list">

		<?php	foreach ($child_sections as $child_section) {

			 $chilid_section_type = get_post_meta($child_section->ID, 'section_type',true);

?>

				<li class="toc-list-item dd-item"  data-id="<?php echo $child_section->ID;?>" id="listItem_<?php echo $child_section->ID;?>">

					<div class="dd-handle" style="float:left;width:55%;height:30px;cursor:move;">

					<span  style="float:left;" class="chap_desc"><a href="admin.php?page=book-new-section&section=<?php echo $child_section->ID;?>&book=<?php echo $book_slug; ?>&section_type=<?php echo $child_section_type;?>&action=edit"><span class="book_name"><strong><?php echo $child_section->post_title; ?></strong></span></a> </span>

						<span class="move_page"> <span class="name column-name chap_edit"><a href="admin.php?page=book-new-section&section=<?php echo $child_section->ID;?>&book=<?php echo $book_slug; ?>&section_type=<?php echo $child_section_type;?>&action=edit"><img src="<?php echo PUBML_BASE_URL;?>/images/edit.png" class="tbl_icon"></a></span>

					<span class="chap_del"><a href="JavaScript:void(0);" id="<?php echo $child_section->ID;?>" class="delete-section-post"><img src="<?php echo PUBML_BASE_URL;?>/images/delete.png" class="tbl_icon"></a></span>

						</span>

					</div>

					</li>

		<?php	} ?>

			</ol>

<?php }		

?>

	

				</li>

<?php }



 ?>

	</ol>

	</div>

	</div>

	<?php //exit; ?>

		<div class="settings_content" style="clear: both;float: right; margin-top: 2%;">

	        <div class="row-actionss"  style="float:right">

				<a href="admin.php?page=book-new-section&book=<?php echo $Book->slug;?>&section_type=text" class="button button-primary button-large" style="margin-right: 10px;">New Text Section</a>

				<a href="admin.php?page=book-new-section&book=<?php echo $Book->slug;?>&section_type=image" class="button button-primary button-large">New Full-Page Image</a>

			</div>

		</div>

	<div class="clear"></div>

	</div>

</div>

<?php

########### Print sorting js in footer

function sorting_script() { //javascript calling function above

global $post;

?>

<script type="text/javascript">

  // When the document is ready set up our sortable with it's inherant function(s)

  jQuery(window).load(function() {



jQuery(".dd a").on("mousedown", function(event) { // mousedown prevent nestable click

    event.preventDefault();

    return false;

});



jQuery(".dd a").on("click", function(event) { // click event

    event.preventDefault();

    window.location = jQuery(this).attr("href");

    return false;

});

});

</script>

<?php

}

add_action('admin_print_footer_scripts', 'sorting_script'); //Sorting script

?>

<!-- Script to remove section -->

<script type="text/javascript">

jQuery(document).ready(function($) {

	$(".delete-section-post" ).click(function() {

	var postid = $(this).attr('id');

	var data = {

		action: 'delete_post_custom',

		post_id: postid

	};

$("#listItem_"+postid).css('background-color','#FF0000');

if(confirm("Are you sure want to remove this section?")){

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php

		$.post(ajaxurl, data, function(response) {

				$("#listItem_"+response.post_id).remove();



		}, "json");

} else {

$("#listItem_"+postid).css('background-color','#EEE');

}

	});

	

	

    var updateOutput = function(e)

    {

        var list   = e.length ? e : jQuery(e.target),

            output = list.data('output');

        if (window.JSON) {

            output.val(window.JSON.stringify(list.nestable('serialize')));//, null, 2));

        } else {

            output.val('JSON browser support required for this demo.');

        }

		

    };



    // activate Nestable for list 1

    jQuery('#nestable').nestable({

        group: 1

    })

    .on('change', updateList);

    



    // output initial serialised data

    updateOutput(jQuery('#nestable').data('output', jQuery('#nestable-output')));





});



function updateList(){

		jQuery.ajax ({

				type: 'POST',

				url: ajaxurl,

				data: {

					'action':'sortingToc',

					'parent_data' : jQuery('#nestable').nestable('toArray'), //jQuery('#nestable-output').val(),

				},

				dataType:'json',

				success: function(response) {    



					if(response.status == 200){



					}

				}

			});

}

</script>



