<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	*	Settings Tab File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used for settings tab data.
	*	---------------------------------------------------------------------
	*/
?>
	<div class="settings_content">
		<div class="license_left_content" >
			<p> &lt;PubML&gt;&trade; is "Publishing with HTML" - a sophisticated web publishing system designed for use by publishers of all sizes.
			<br><br>
			<p> &lt;PubML&gt;&trade; includes expert publishing and design guidance to help you produce excellent books.</p>
            <p><a href="http://pubml.com/products-and-plans/" target="_blank">Subscribe</a> to &lt;PubML&gt;&trade; to enable previewing, embedding, and export of eBooks.</p>
			<p>See our companion website at <a href="http://www.theworldsgreatestbook.com">http://www.theworldsgreatestbook.com</a></p>
			<p> &lt;PubML&gt;&trade; Publishing Tools export to ePub (for upload to Kindle, Nook, Google Books, Kobo, etc.) and to our unique and powerful  &lt;PubML&gt;&trade; web book format.</p>
			
			<h3>You are currently using  &lt;PubML&gt;&trade; version <?php  _e(PUBML_VERSION)?></h3>

			<form method="post" action="options.php">
			<?php settings_fields('pubml_ebook_license'); ?>
			<table class="form-table">
				<tbody>
					<tr valign="top">	
						<th scope="row" valign="top">
							<?php _e('License Key'); ?>
						</th>
						<td>
							<input id="pubml_ebook_license_key" name="pubml_ebook_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license ); ?>" />
							<label class="description" for="pubml_ebook_license_key"><?php _e('Enter your license key'); ?></label>
						</td>
					</tr>
					<?php //if( false !== $license ) { ?>
						<tr valign="top">	
							<th scope="row" valign="top">
								<?php _e('Activate License'); ?>
							</th>
							<td>
								<?php if( $status !== false && $status == 'valid' ) { ?>
									<span style="color:green;"><?php _e('active'); ?></span>
									<?php wp_nonce_field( 'pubml_ebook_nonce', 'pubml_ebook_nonce' ); ?>
									<input type="submit" class="button-secondary" name="pubml_license_deactivate" value="<?php _e('Deactivate License'); ?>"/>
								<?php } else {
									wp_nonce_field( 'pubml_ebook_nonce', 'pubml_ebook_nonce' ); ?>
									<input type="submit" class="button-secondary" name="pubml_license_activate" value="<?php _e('Activate License'); ?>"/>
								<?php } ?>
							</td>
						</tr>
					<?php // } ?>
				</tbody>
			</table>	
			<?php // submit_button(); ?>
		</form>
		</div>
		<div class="license_right_content">	
			<h2><img src="<?php echo PUBML_BASE_URL;?>/images/wgb_banner.jpg" width="400" height="40"  alt=""/></h2>
			<?php // Get RSS Feed(s)
			include_once( ABSPATH . WPINC . '/feed.php' );
			// Get a SimplePie feed object from the specified feed source.
			$rss = fetch_feed( 'http://theworldsgreatestbook.com/feed/' );
			if ( ! is_wp_error( $rss ) ) : // Checks that the object is created correctly
				// Figure out how many total items there are, but limit it to 5. 
				$maxitems = $rss->get_item_quantity( 15 ); 
				// Build an array of all the items, starting with element 0 (first element).
				$rss_items = $rss->get_items( 0, $maxitems );
			endif;
			?>
			<ul>
				<?php if ( $maxitems == 0 ) : ?>
					<li><?php _e( 'No items', 'my-text-domain' ); ?></li>
				<?php else : ?>
					<?php // Loop through each feed item and display each item as a hyperlink. ?>
					<?php foreach ( $rss_items as $item ) : ?>
						<li>
							<a target="_blank" href="<?php echo esc_url( $item->get_permalink() ); ?>" 
								title="<?php printf( __( 'Posted %s', 'my-text-domain' ), $item->get_date('j F Y | g:i a') ); ?>">
								<?php echo esc_html( $item->get_title() ); ?>
							</a>
						</li>
					<?php endforeach; ?>
				<?php endif; ?>
			</ul>
		</div>
</div>
<div class="clear"></div>