/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

(function() {
    tinymce.create('tinymce.plugins.PubML', {
        init : function(ed, url) {		

		 /*	###################################################
		 Footnote button work Starts here 
		 #####################################################*/

		/* Footnote Button */
            ed.addButton('footnote', {
                title : 'Add Footnote',
                cmd : 'footnote',
                image : pluginUrl + '/images/toolbar_icon_photonote.png'
            });
		
		/* Footnote Functionality */
			  ed.addCommand('footnote', function() {
				 ed.windowManager.open(
				{
					// this is the ID of the popups parent element
					id : 'footnote_dialog',
					width : 480,
					title : 'Footnotes',
					height : 225,    //'auto',
					wpDialog : true,
				},
				{
					plugin_url : pluginUrl
				}

				);
				jQuery('.edt_ftnt_post').click(function(){
					footnote_name = jQuery(this).attr('id');
					console.log(footnote_name);
					selected_footnote = tinyMCE.activeEditor.selection.getContent();
					console.log(selected_footnote);
					
                    if( selected_footnote ){
                        //If text is selected when button is clicked
                        //Wrap shortcode around it.
                        footnote_content =  '<a class="footnote" rel="'+ footnote_name+'" href="#">'+selected_footnote+'</a>';
                    } else {
                        footnote_content =  '';
                    }
					console.log(footnote_content);
					ed.execCommand('mceInsertContent', 0, footnote_content);
					ed.windowManager.close();
					
				});
                

            });

		/*	#########  Footnote button work end here ########## */

 
 /*	###################################################
 Media button work Starts here 
 #####################################################*/

 /* Media Button */
            ed.addButton('medialink', {
                title : 'Add Media',
                cmd : 'medialink',
                image : pluginUrl + '/images/toolbar_icon_media.png'
            });
			/* Media Functionality */
            /* ed.addCommand('medialink', function() {
                var media_link = prompt("Provide Media link ? "),
                    shortcode;
                    if (media_link) {
                        shortcode = '[Media URL="' + media_link + '"/]';
                        ed.execCommand('mceInsertContent', 0, shortcode);
                    }

            });  */
			
	// Add a getMedia function in the content of the Book chapter.	

			ed.addCommand('medialink', function() {
				 ed.windowManager.open(
				{
					// this is the ID of the popups parent element
					id : 'mediaLib_dialog',
					width : 480,
					title : 'Media Library',
					height : 225, //'auto',
					wpDialog : true,
				},
				{
					plugin_url : pluginUrl
				}

				);
				jQuery('.edt_medialist_post').click(function(){
					media_slug = jQuery(this).attr('id');
					selected_mediaText = tinyMCE.activeEditor.selection.getContent();

                    if( selected_mediaText ){
                        //If text is selected when button is clicked
                        //Wrap shortcode around it.
                        media_content =  '<a class="media" href="#" rel="'+media_slug+'">'+selected_mediaText+'</a>';
                    } else {
                        media_content =  '';
                    }
					ed.execCommand('mceInsertContent', 0, media_content);
					ed.windowManager.close();
				});                

            });
			
			
			
/*	#########  Media button work end here ########## */

		 /*	###################################################
		 Column Break button work Starts here 
		 #####################################################*/
	
		/* Column Break Button */	
             ed.addButton('columnbreak', {
                title : 'Add Column Break',
                cmd : 'add_columnbreak',
                image : pluginUrl + '/images/toolbar_icon_columnbreak.png'
            });

		/* Column Functionality */	
			var columnbreak_shortcode = "";
			var columnbreakHTML = '<img src="' + url + '/img/trans.gif" class="mce-wp-more mceItemNoResize" title="'+ed.getLang('wordpress.wp_more_alt')+'" />';
            ed.addCommand('add_columnbreak', function() {
				columnbreak_shortcode = '<div class="pubml-columnbreak"></div><br/>';
				ed.execCommand('mceInsertContent', 0, columnbreak_shortcode);
				//ed.execCommand('mceInsertContent', 0, columnbreakHTML);
            });

/*	#########  Column Break button work end here ########## */


 /*	###################################################
 Separator Ornament button work Starts here 
 #####################################################*/
	
/* Separator Ornament Button */	
             ed.addButton('separator_ornament', {
                title : 'Add Separator Ornament',
                cmd : 'add_separator_ornament',
                image : pluginUrl + '/images/toolbar_icon_separator.png'
            });

/* Separator Ornament Functionality */	
			var separator_ornament_shortcode = "";
			//var separator_ornament = pubml_ornament;
			
            ed.addCommand('add_separator_ornament', function() {
				//separator_ornament_shortcode = '<div class="pubml-sep-ornament"><img src="'+separator_ornament+'"></div>';
				separator_ornament_shortcode = '<div class="pubml-separator-ornament"></div><br/>';
				//separator_ornament_shortcode = '<div class="pubml-separator-ornament"></div>';
				ed.execCommand('mceInsertContent', 0, separator_ornament_shortcode);
            });

/*	#########  Separator Ornament button work end here ########## */

/*###################################################
	Chapter Ornament button work Starts here 
#####################################################*/
	
/* Chapter Ornament Button */	
             ed.addButton('chapter_ornament', {
                title : 'Add Chapter Ornament',
                cmd : 'add_chapter_ornament',
                image : pluginUrl + '/images/toolbar_icon_chapter_ornament.png'
            });

/* Chapter Ornament Functionality */	
			var chapter_ornament = "";
			//var chapter_ornament = pubml_chap_ornament;			
			
            ed.addCommand('add_chapter_ornament', function() {
				//chapter_ornament_shortcode = '<div class="pubml-chapter-ornament"><img src="'+chapter_ornament+'"></div>';
				chapter_ornament_shortcode = '<div class="pubml-chapter-ornament"></div><br/>';
				ed.execCommand('mceInsertContent', 2, chapter_ornament_shortcode);
            });

/*	#########  Separator Ornament button work end here ########## */



/*###################################################
 Drop Caps button for the WP Editor Starts here 
 #####################################################*/
	
/* Column Break Button */	
             ed.addButton('dropcaps', {
                title : 'Drop Caps',
                cmd : 'drop_caps',
                image : pluginUrl + '/images/toolbar_icon_dropcap.png'
            });

/* Column Functionality */	
			var dropcaps_shortcode = "";
            ed.addCommand('drop_caps', function() {
				selected_letter = tinyMCE.activeEditor.selection.getContent();
				dropcaps_shortcode = '<span class="pubml-dropcaps">'+selected_letter+'</span>';
				ed.execCommand('mceInsertContent', 0, dropcaps_shortcode);
            });

/*	#########  Drop Caps button for the WP Editor end here ########## */


/*###################################################
 SmallCaps button for the WP Editor Starts here 
 #####################################################*/
	
/* Column Break Button */	
             ed.addButton('smallcaps', {
                title : 'Small Capitals',
                cmd : 'small_caps',
                image : pluginUrl + '/images/toolbar_icon_smallcaps.png'
            });

/* Column Functionality */	
			var small_caps_shortcode = "";
            ed.addCommand('small_caps', function() {
				selected_text = tinyMCE.activeEditor.selection.getContent();
				small_caps_shortcode = '<span class="pubml-smallcaps">'+selected_text+'</span>';
				ed.execCommand('mceInsertContent', 0, small_caps_shortcode);
            });

/*	#########   SmallCaps button for the WP Editor end here ########## */

/*###################################################
 NoIndent button for the WP Editor Starts here 
 #####################################################*/
	
/* Column Break Button */	
             ed.addButton('noindent', {
                title : 'No Indent',
                cmd : 'no_indent',
                image : pluginUrl + '/images/toolbar_icon_noIndent.png'
            });

/* Column Functionality */	
			var no_indent_shortcode = "";
            ed.addCommand('no_indent', function() {
				selected_para = tinyMCE.activeEditor.selection.getContent();
				//alert(tinymce.activeEditor.selection.getNode().nodeName);
				
				tinymce.activeEditor.formatter.register('noindentformat', {
				   selector: 'p,div,ul,ol,li,table,img',
				   classes : 'noIndent'
				});
				tinymce.activeEditor.formatter.apply('noindentformat');
				//no_indent_shortcode = '<p class="noIndent">'+selected_para+'</p>';
				//ed.execCommand('mceInsertContent', 1, no_indent_shortcode);
        });
			


/*	#########   NoIndent button for the WP Editor end here ########## */


			ed.onChange.add(function(ed, l) {                  
				  unSavedData = true;
				  console.log(unSavedData);
			});
					
        },
		
        // ... Hidden code
		
    });

    tinymce.PluginManager.add( 'pubml', tinymce.plugins.PubML );
	
		setTimeout(function() {	
			var styleContent = jQuery('style#editorbookCSS').html();
			//alert(styleContent);
			var $head = jQuery("#pubml_post_content_parent .mceIframeContainer iframe#pubml_post_content_ifr").contents().find("head");
			$head.append("<style>"+styleContent+"</style>");	
		},2000);
	
})();