<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/**************************************************************************
*	Function to generate the ePub files for eReader and Download		  *
**************************************************************************/

/* Function to generate the PubML Zip file for each book separately while Exporting  */
	function pubml_ePub_generate_book() {
		global $pubml, $wpdb;	
		$result = array();	
		$book_id = $_POST['bookId'];
		$pubmlBook = get_term_by('id', $book_id, 'book');
		
			if(!$pubmlBook){		
				$result['bookId'] = $book_id;
				$result['status'] = 'false';
				$result['msg'] = 'No Book found';
				echo json_encode($result);
				exit();		
			}
			if(!$removed = clear_old_ePubs($pubmlBook->slug)){
					$result['bookId'] = $book_id;
					$result['status'] = 'false';
					$result['msg'] = 'Cannot remove old zip files';
				echo json_encode($result);	
				exit(0);
			}
			
			$book_slug = $pubmlBook->slug;
			$chapters_array = array();
			$chapters_query = query_posts(array( 
				'post_type' => 'pubml_books',
				'showposts' => -1,
				'meta_key' => 'sorting_status',
				'orderby' => 'meta_value_num',
				'tax_query' => array(
					array(
						'taxonomy' => 'book',
						'terms' => $book_id,
						'field' => 'term_id',
					)
				),
				// 'orderby' => 'title',
				'order' => 'ASC' )
			);	
				
			// print_r($chapters_query);
			// The Loop
			if ( have_posts() ) {	
				# create zip file
				$file_name = $pubmlBook->slug.'-'.date('m-d-Y_hia');
				$upload_dir = wp_upload_dir();
				$dir = $upload_dir['path'];
				$filename = $dir.'/'.$file_name;		

				if ($upload_dir['error']) { 
						$result['bookId'] = $book_id;
						$result['status'] = 'false';
						$result['msg'] = $upload_dir['error'];
					echo json_encode($result);
					exit(0);
				}
				if (! is_dir($dir)) {
						$result['bookId'] = $book_id;
						$result['status'] = 'false';
						$result['msg'] = 'Upload directory: ' . $dir .'ERROR: Directory does not exist.';
					echo json_encode($result);
					exit(0);				
				}
				if (! is_writable($dir)) {
						$result['bookId'] = $book_id;
						$result['status'] = 'false';
						$result['msg'] = 'Upload directory: ' . $dir .'ERROR: Directory is not writable';
					echo json_encode($result);
					exit(0);				   
				}

				$url = $upload_dir['url'] . '/'. $file_name;			

				// Create a test book for download.
				// ePub uses XHTML 1.1, preferably strict.
				$content_start =
				"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
				. "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n"
				. "    \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n"
				. "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
				. "<head>"
				. "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n"
				. "<meta name=\"generator\" content=\"Created with PubML - http://www.pubml.com\" />\n"
				. "<link rel=\"stylesheet\" type=\"text/css\" href=\"styles.css\" />\n"
				. "<title>$pubmlBook->slug</title>\n"
				. "</head>\n"
				. "<body>\n";
				
				$bookEnd = "</body>\n</html>\n";

				// setting timezone for time functions used for logging to work properly
				date_default_timezone_set('Europe/Berlin');

				include_once("Logger.php");
				$log = new PubML_Logger("$book_slug", TRUE);

				$fileDir = './PHPePub';

				include_once("EPub.php");
				$log->logLine("include PubML_EPub");

				$book = new PubML_EPub(); // Default is PubML_EPub::BOOK_VERSION_EPUB2
				$log->logLine("new PubML_EPub()");
				$log->logLine("PubML_EPub class version: " . PubML_EPub::VERSION);
				$log->logLine("PubML_EPub Req. Zip version: " . PubML_EPub::REQ_ZIP_VERSION);
				$log->logLine("PubML_Zip version: " . PubML_Zip::VERSION);
				$log->logLine("getCurrentServerURL: " . $book->getCurrentServerURL());
				$log->logLine("getCurrentPageURL..: " . $book->getCurrentPageURL());
				
				$book_meta = get_option( "taxonomy_$book_id");
				$book_author = $book_meta['contributor1first']." ".$book_meta['contributor1middle']." ".$book_meta['contributor1last'];
				$book_lang = ($book_meta['language']) ? $book_meta['language'] : 'en';
				$book_publisher = ($book_meta['publisher']) ? $book_meta['publisher'] : 'PubML';
				$book_copyright = ($book_meta['copyright_info']) ? stripslashes($book_meta['copyright_info']) : '';
				$book_short_desc = ($book_meta['short_desc']) ? stripslashes($book_meta['short_desc']) : '';
				$book_cover_image = ($book_meta['cover_meta']) ? stripslashes($book_meta['cover_meta']) : PUBML_BASE_URL."/images/placeholder.png";
				
				if($book_meta['isbn']){
					$book_isbn = $book_meta['isbn'];
					$identifierType = PubML_EPub::IDENTIFIER_ISBN;				
				}else{
					$book_isbn = rand(10000000, 99999999);;	
					$identifierType = PubML_EPub::IDENTIFIER_UUID;
				}	
					
				$book_website = ($book_meta['book_website']) ? stripslashes($book_meta['book_website']) : site_url();
				
				$book_contributor1 = $book_meta['contributor2first']." ".$book_meta['contributor2middle']." ".$book_meta['contributor2last'];
				$book_contributor2 = $book_meta['contributor3first']." ".$book_meta['contributor3middle']." ".$book_meta['contributor3last'];
				
				$contributor1_role = ($book_meta['contributor2role']) ? $book_meta['contributor2role'] : 'aut';
				$contributor2_role = ($book_meta['contributor3role']) ? $book_meta['contributor3role'] : 'aut';

				// Title and Identifier are mandatory!
				$book->setTitle("$pubmlBook->name");
				$book->setIdentifier($book_isbn, $identifierType); // Could also be the ISBN number, prefered for published books, or a UUID.
						
				$book->setLanguage("$book_lang"); // Not needed, but included for the example, Language is mandatory, but EPub defaults to "en". Use RFC3066 Language codes, such as "en", "da", "fr" etc.
				$book->setDescription("$pubmlBook->description");
				$book->setAuthor("$book_author",NULL);
				$book->setPublisher("$book_publisher", "$book_website"); // I hope this is a non existant address :)
				$book->setDate(time()); // Strictly not needed as the book date defaults to time().
				$book->setRights("$book_copyright"); // As this is generated, this _could_ contain the name or licence information of the user who purchased the book, if needed. If this is used that way, the identifier must also be made unique for the book.
				$book->setSourceURL("$book_website");

				// $book->addDublinCoreMetadata(PubML_DublinCore::CONTRIBUTOR, "$_book_contributor");
				if((!empty($book_contributor1)) && (trim($book_contributor1) )){ 
					$book->setContributor($book_contributor1, $contributor1_role);
				}
				if((!empty($book_contributor2)) && (trim($book_contributor2) )){ 
					$book->setContributor($book_contributor2, $contributor2_role);
				}

				$book->setSubject(stripslashes($book_meta['subject1desc']));
				$book->setSubject(stripslashes($book_meta['subject2desc']));
				$book->setSubject(stripslashes($book_meta['subject3desc']));

				// Insert custom meta data to the book, in this cvase, Calibre series index information.
				$book->addCustomMetadata("calibre:series", "$book_slug");
				$book->addCustomMetadata("calibre:series_index", "1");
				$book->addCustomMetadata("description", $book_short_desc);

				$log->logLine("Set up parameters");

				$cssData1 = "body {\n  margin-left: .5em;\n  margin-right: .5em;\n  text-align: justify;\n}\n\np {\n  font-family: serif;\n  font-size: 10pt;\n  text-align: justify;\n  text-indent: 1em;\n  margin-top: 0px;\n  margin-bottom: 1ex;\n}\n\nh1, h2 {\n  font-family: sans-serif;\n  font-style: italic;\n  text-align: center;\n  background-color: #6b879c;\n  color: white;\n  width: 100%;\n}\n\nh1 {\n    margin-bottom: 2px;\n}\n\nh2 {\n    margin-top: -2px;\n    margin-bottom: 2px;\n}\n";

				$cssData2 = file_get_contents(PUBML_BASE_DIR."/ePub/css/pubml-epub-styles.css");
				
				$cssData = ($cssData2) ? $cssData2 : $cssData1;
				
				$cssData .= epub_custom_css($book_id, $book);  // $book is for the object of ePub book
				
				
				$log->logLine("Add css");
				$book->addCSSFile("styles.css", "css1", $cssData);

				// A better way is to let EPub handle the image itself, as it may need resizing. Most Ebooks are only about 600x800
				//  pixels, adding megapix images is a waste of place and spends bandwidth. setCoverImage can resize the image.
				//  When using this method, the given image path must be the absolute path from the servers Document root.
				
				$_cover_image_abs_path = str_replace(WP_CONTENT_URL, WP_CONTENT_DIR, $book_cover_image, $count);
				
				if (@file_exists($_cover_image_abs_path)) {
					$_cover_image_name =  basename($_cover_image_abs_path);
					$image_Array = getimagesize($_cover_image_abs_path); 
					$mimetype = $image_Array['mime'];		
				
					// This test requires you have an image, change "demo/cover-image.jpg" to match your location.
					$log->logLine("Add Cover Image");
					$book->setCoverImage("$_cover_image_name", file_get_contents("$_cover_image_abs_path"), "$mimetype");
				}	
			
				$wp_upload_dir = wp_upload_dir();
				$upload_dir = $wp_upload_dir['basedir'];
				
				$log->logLine("Build Chapters");
				
				if(!empty($chapters_query)) {
					$flag = 0;
					$level = FALSE;
					
					foreach($chapters_query as $chapter){		
						//$chapter_name = $chapter->post_name;
						
						$chapter_name = sanitize_title($chapter->post_title);
						$chapter_title = $chapter->post_title;
						$html_story = $story = do_shortcode(wpautop($chapter->post_content)) ;	
						//$html_data = $html_story;		
						
						$html_data = preg_replace('/<a (class="footnote"|class="media") (.*?)>(.*?)<\/a>/', "$3", $html_story);		
						
						$image_base_dir =  $result_img = ''; $matches = array();
						$custom_section_image = get_post_meta($chapter->ID,'custom_section_image',true);
						$chapter_order = get_post_meta($chapter->ID, 'toc_parent',true);					
						
						if(isset($chapter_order) && !empty($chapter_order) && (!$level)){
							$book->subLevel();
							$level = TRUE;
						}
						else if( isset($chapter_order) && empty($chapter_order) && ($level)){
							$book->rootLevel();
							$level = FALSE;
						}	
						
						if($custom_section_image){							
							$log->logLine("Add $chapter_title");
							$_image_name =  basename($custom_section_image);							
							$html_data = "<p class=\"fullpage-image\"><img src=\"$custom_section_image\" alt=\"$chapter_title\"  /></p>";					
							$book->addChapter("$chapter_title", "$chapter_name.html", $content_start.$html_data, false, PubML_EPub::EXTERNAL_REF_ADD, $fileDir);
						} else {						
							$log->logLine("Add $chapter_title");
							$html_data = ($html_data) ? $html_data : '<p></p>' ;
							$book->addChapter("$chapter_title", "$chapter_name.html", $content_start.$html_data, false, PubML_EPub::EXTERNAL_REF_ADD, $fileDir);
							
							//echo $html_data;
						}					
					}
					//exit();
				}
				
				// If you have nested chapters, you can call ->rootLevel() to return your hierachy to the root of the navMap.
				$book->rootLevel();
				$log->logLine("Add TOC");
				// $book->buildTOC();
				// $book->addChapter("Log", "Log.html", $content_start . $log->getLog() . "\n</pre>" . $bookEnd);

				// if ($book->isLogging) { // Only used in case we need to debug EPub.php.
					// $epuplog = $book->getLog();
					// $book->addChapter("ePubLog", "ePubLog.html", $content_start . $epuplog . "\n</pre>" . $bookEnd);
				// }
				$book->finalize(); // Finalize the book, and build the archive.

				// Save book as a file relative to your script (for local ePub generation)
				// Notice that the extions .epub will be added by the script.
				// The second parameter is a directory name which is '.' by default. Don't use trailing slash!
				$book->saveBook("$file_name", "$dir");

				// Send the book to the client. ".epub" will be appended if missing.
				//$zipData = $book->sendBook("$book_slug");

				// After this point your script should call exit. If anything is written to the output,
				// it'll be appended to the end of the book, causing the epub file to become corrupt.
				
				$result['bookId'] = $book_id;
				$result['status'] = 'TRUE';
				$result['bookpath'] = $url.'.epub';
				$result['msg'] = 'Thanks for supporting PubML. Render successful!';
				echo json_encode($result);
				exit();	
					
			} else {  
					$result['bookId'] = $book_id;
					$result['status'] = 'false';
					$result['msg'] = 'No Pages found';
				echo json_encode($result);
				exit(0);
			}
			wp_reset_query();  	// Restore original Post Data
			
		echo json_encode($result);
		exit();		
	}

add_action('wp_ajax_pubml_ePub_generate_book', 'pubml_ePub_generate_book');

// Function to remove the old zip files from the server Upload directory
	function clear_old_ePubs($book) {
		global $wpdb;
		$removed = FALSE ; 
		
			$files = $book.'*.epub';		
			$upload_dir = wp_upload_dir();
			$dir = $upload_dir['path'];
			$filename = $dir.'/'.$files;		
			$removed = exec("rm $filename", $r);
			
		return true;
	}	

// Function to creating ePub CSS dynamically for reach book
	function epub_custom_css($book_id = '' , $ePubbook) {
		global $wpdb, $pubml;
		$book = get_term_by('id', $book_id, 'book');
		$customStyles = array();	
		$custom_style = "/*-----Custom Style Editor CSS Generated -----*/\n" ;
		$custom_image_dest = $book->slug.'/img/';	// Destination folder path	
		
		//$ePubbook = new EPub(); // Default is EPub::BOOK_VERSION_EPUB2
		
			
		$txtst_query = "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='all-data'";
				
		$txtstyles  = $wpdb->get_row($txtst_query);

		if(count($txtstyles)){
			$textStyles =  unserialize($txtstyles->style_data);			
		}else{
			$textStyles =  PubML_default_style_data();
		}
		
		$i = 1;
		// Chapter Ornament CSS
		$chapt_ornament = $textStyles['text_style']['orn-style-val'];
		if($chapt_ornament){				
			$chapt_ornament_img = basename($chapt_ornament);		
			
			$image_abs_path = str_replace(WP_CONTENT_URL, WP_CONTENT_DIR, $chapt_ornament, $count);
				
			if (@file_exists($image_abs_path)) {
				$image_Array = getimagesize($image_abs_path); 
				$mimetype = $image_Array['mime'];
				$ePubbook->addLargeFile("img/$chapt_ornament_img", "chapter-ornament".$i++, $image_abs_path , $mimetype);
			}

		
			$custom_style .= ".pubml-chapter-ornament{background:url('img/$chapt_ornament_img') no-repeat center center;border: 0;display: block;width: 95%;height:80px;margin: 10px auto;text-align: center;	}\n";	
		}
		// Seperator Ornament CSS
		$sept_ornament = $textStyles['seperator_ornament']['custom-separator'];
		if($sept_ornament){	
			$sept_ornament_path = ($sept_ornament == 'sep_1') ? PUBML_BASE_URL.'/images/separator_ornament_1.png' : $textStyles['seperator_ornament']['upload-sep-link-val'];
			$sept_ornament_img = basename($sept_ornament_path);			

			$image_abs_path = str_replace(WP_CONTENT_URL, WP_CONTENT_DIR, $sept_ornament_path, $count);
			if (@file_exists($image_abs_path)) {
				$image_Array = getimagesize($image_abs_path); 
				$mimetype = $image_Array['mime'];
				$ePubbook->addLargeFile("img/$sept_ornament_img", "separator-ornament".$i++, $image_abs_path , $mimetype);
			}
			
			$custom_style .= ".pubml-separator-ornament{background:url('img/$sept_ornament_img') no-repeat center center ; border: 0;display: block;width: 95%;height:30px;margin: 10px auto;text-align: center;	}\n";	
		}	
			
			
		$custom_query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='style'";	
		$mystyles  = $wpdb->get_row($custom_query);
		
			if(count($mystyles)){
				$customStyles =  unserialize($mystyles->style_data);			
			}else{
				$customStyles = pubml_styles_default_values();
			}		
			
	
		foreach($customStyles as $key => $value){
			if($value['style_slug']!= 'p')
				$class_name = ($value['style_slug']) ? '.'.$value['style_slug'] : '.pubml-'.sanitize_title($value['style_name']);
			else
				$class_name = 'p ';	

		$custom_style .=  $class_name.'{';		
				
			// $margin_left = ($value['style_left_margin']) ? ($value['style_left_margin']/10) : 0 ; 
			// $margin_right = ($value['style_right_margin']) ? ($value['style_right_margin']/10) : 0 ; 
			// $margin_top = ($value['style_lines_before']) ? ($value['style_lines_before']/10) : 0 ; 
			// $margin_bottom = ($value['style_lines_after']) ? ($value['style_lines_after']/10) : 0 ; 
			
		/*	$margin_left = ($value['style_left_margin']) ? ($value['style_left_margin']) : 0 ; 
			$margin_right = ($value['style_right_margin']) ? ($value['style_right_margin']) : 0 ; 
			$margin_top = ($value['style_lines_before']) ? ($value['style_lines_before']) : 0 ; 
			$margin_bottom = ($value['style_lines_after']) ? ($value['style_lines_after']) : 0 ; 
			
			$custom_style .= " margin: $margin_top"."px $margin_right"."px $margin_bottom"."px $margin_left"."px ; ";  */
			
			$custom_style .= ($value['style_font'] == 'Readers Choice') ? "" : "font-family: ".stripslashes($value['style_font']).";" ; 
		/*	$custom_style .= 'text-align: '.(($value['style_align']) ? $value['style_align'] : '').';' ; 
			$custom_style .= 'font-size: '.(($value['style_font_size']) ? ($value['style_font_size']) : '' ).'px;';  
			
			$custom_style .= ($value['style_hyphen']== 'on') ? ' -webkit-hyphens: auto; 	-moz-hyphens: auto;	hyphens: auto; ' : '';
			$custom_style .= ($value['style_line_height']) ? " line-height:".($value['style_line_height'])."px; " : "";
			$custom_style .= ($value['style_body_indent']) ? " text-indent: :".($value['style_body_indent'])."px; " : "";   */
		
		$custom_style .= "}\n";
			 	
		}	
		
		return	$custom_style;
	}
?>
