<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/**
 * PubML Custom WP Editor Functions 
 *
 * This file is used to create Custom Functions for wp editor and it's visual editor button 
 * and contains Hooks and Actions.
 *
 * @author 		SynapseIndia
 * @category 	Core
 * @link		http://www.pubml.com
 * @package 	PubML/inc/CustomEditorFunctions 
 * @version     0.0.1
 */	
	add_action( 'init', 'pubml_editor_buttons' );
	function pubml_editor_buttons() {
		if ( get_user_option('rich_editing') == 'true' ) {
			global $typenow;
			if (empty($typenow) && !empty($_GET['post'])) {
				$post = get_post($_GET['post']);
				$typenow = $post->post_type;
			}
			$page_name = @$_GET['page'];
			if ("pubml_books" == $typenow || $page_name=='book-new-section'){
				add_filter( "mce_external_plugins", "pubml_editor_add_buttons" );
				add_filter( 'mce_buttons', 'pubml_editor_register_buttons' );
				add_filter( 'tiny_mce_before_init', 'tuts_mce_before_init' );  	//Add styles/classes to the "Styles" drop-down 
				add_filter( 'mce_css', 'pubml_mce_css' );	
				
				add_filter( 'mce_buttons_2', 'tuts_mce_editor_buttons' );  		// Add "Styles" drop-down 
				// add_filter( 'mce_buttons_1', 'hide_wp_adv_Option' );  			// Function to hide the wp_adv menu 
				
				
				add_filter('tiny_mce_before_init', 'customformatTinyMCE' ); 	// Modify Tiny_MCE init
				add_filter('mce_buttons_2', 'add_fontselect_row_3' );
				
				add_filter("mce_buttons", "tinymce_editor_buttons", 99); 
				add_filter("mce_buttons_3", "tinymce_editor_buttons_second_row", 99); 
				add_filter("mce_buttons_4", "tinymce_editor_buttons_second_row", 99); 
				
				remove_filter( 'the_content', 'wpautop' );
				remove_filter( 'the_excerpt', 'wpautop' );	
				
				
			}
			if ("pubml_books" == $typenow || $page_name=='book-new-footnote'){
				add_filter('tiny_mce_before_init', 'customformatTinyMCE1' ); 	// Modify Tiny_MCE init
				add_filter('mce_buttons_2', 'add_fontselect_row_3' );
			
			}
			if ("pubml-navigation" == $typenow || $page_name=='book-new-tab'){
				add_filter( "mce_external_plugins", "pubml_editor_buttons_and_content" );
				add_filter('mce_buttons_2', 'add_fontselect_row_3' );
			}
			

			
		}
	}
	// Function to hide the wp_adv menu 
	function hide_wp_adv_Option (){
		
			$remove_wp_adv = array_search( 'wp_adv', $mce_buttons );
			unset( $mce_buttons[ $remove_wp_adv ] );
		
		return $mce_buttons;
	}
	
	function pubml_editor_add_buttons( $plugin_array ) {
		$plugin_array['pubml'] = PUBML_BASE_URL.'/js/pubml_tinymce.js';
		return $plugin_array;
	}

	function pubml_editor_buttons_and_content( $plugin_array ) {
		$plugin_array['pubml'] = PUBML_BASE_URL.'/js/pubml_tinymce-content.js';
		return $plugin_array;
	}

	function pubml_editor_register_buttons( $buttons ) {
		array_push( $buttons, 'footnote', 'medialink', 'columnbreak', 'separator_ornament', 'chapter_ornament','dropcaps','smallcaps','noindent' ); // , dropcap', 'recentposts
		return $buttons;
	}

if ( is_admin() ) {
/**
* hook in only, if current user can
* see the editor and want to have
* a rich text editor
*/

	add_action( 'admin_footer', 'my_plugin_dialog' );
	add_action( 'admin_footer', 'my_mediaLib_dialog' );

}
	function my_plugin_dialog() {
	?>
	<div style="display:none;">
		<div id="footnote_dialog">
			<div class="edt_footnotes">
			<table width="100%">
				<?php
				$book_slug = @$_GET['book'];
				if($book_slug){
					$Book = get_term_by('slug', $book_slug, 'book');
						$footnotes = get_posts(array( 
							'post_type' => 'pubml_footnotes',
							'showposts' => -1,
							'meta_query' => array(
								array(
									'key' => 'book',
									'value' => $Book->term_id,
								)
							),
							'orderby' => 'title',
							'order' => 'ASC' )
						);
					foreach($footnotes as $footnote){
						echo "<tr>";
						// echo "<td></td>";
						echo "<td id='".$footnote->post_name."' class='edt_ftnt_post'>".$footnote->post_title."</td>";
						echo "</tr>";
					} 
				}	
				?>
			</table>
			</div>
		</div>

	</div>
	<?php
	}



		// Function to open a popup for listing of all Media Library
		
		function my_mediaLib_dialog() {
			global $wpdb;
			$book_slug = @$_GET['book'];
			$Book = get_term_by('slug', $book_slug, 'book');

			if ( @$_GET['page'] =='book-new-section'){		

			$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$Book->term_id} AND {$wpdb->prefix}book_style.type='all-data'";

			$myrows = $wpdb->get_results($query, OBJECT);
			$style_data = array();

			foreach($myrows as $row){
					$style_data = unserialize($row->style_data);
				}
			
			$style_sept = ( @$style_data['custom-separator']) ? $style_data['custom-separator'] : 'default-separator';
			$separator = '';
			
			switch ($style_sept) {
				case 'sep_1':
						$separator = PUBML_BASE_URL.'/images/separator_ornament_1.png';
						break;
				case 'sep_2':
						$separator = PUBML_BASE_URL.'/images/separator_ornament_2.png';
						break;
				case 'sep_3':
						$separator = PUBML_BASE_URL.'/images/separator_ornament_3.png';
						break;
				case 'sep_4':
						$separator = PUBML_BASE_URL.'/images/separator_ornament_4.png';
						break;	
				case 'sep_5':
						$separator = PUBML_BASE_URL.'/images/separator_ornament_5.png';
						break;	
				case 'sep_6':
						$separator = PUBML_BASE_URL.'/images/separator_ornament_6.png';
						break;	
				case 'custom_sep':
						$separator = $style_data['upload-sep-link-val'];
						break;	
				default:
						$separator = PUBML_BASE_URL.'/images/separator_ornament_1.png';
						
			}
			$chap_ornament = (@$style_data['orn-style-val']) ? $style_data['orn-style-val'] : PUBML_BASE_URL.'/images/default_section_ornament.png';	

			$custom_query = "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$Book->term_id} AND {$wpdb->prefix}book_style.type='all-data'";
					
			$mystyles  = $wpdb->get_row($custom_query);
			if(count($mystyles)){
				$customStyles =  unserialize($mystyles->style_data);			
			}else{
				$customStyles =  PubML_default_style_data();
			}
			
			// echo "<pre>";	
				// echo ($Book->term_id);
				// print_r($customStyles);
			// echo "</pre>";	
		
			?>
			<script>
				var pubml_ornament = '<?php echo $separator;?>';	
				var pubml_chap_ornament = '<?php echo $chap_ornament;?>';	
					
			</script>	
			<div style="display:none;">
				<div id="mediaLib_dialog">
					<div class="edt_mediaLib">
					<table width="100%">
						<?php
															
						$media_groups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group WHERE {$wpdb->prefix}media_group.book_id ={$Book->term_id} ORDER BY {$wpdb->prefix}media_group.group_slug ASC", OBJECT);			
								
						if ($media_groups) { 		
							foreach($media_groups as $group){
							
								$grp_title = strlen($group->group_title) > 60 ? substr($group->group_title,0,57)."..." : $group->group_title;
								
								echo "<tr>";
								// echo "<td></td>";
								echo "<td id='".stripslashes($group->group_slug)."' class='edt_medialist_post'>".stripslashes($grp_title)."</td>";
								//echo "<td id='".stripslashes($group->group_slug)."' class='edt_medialist_post'>".stripslashes($grp_title)." (".stripslashes($group->group_slug).")</td>";
								echo "</tr>";
							}
						} else {
							echo "<tr>";
							echo "<td colspan='2'>No Media Founds</td>";					
							echo "</tr>";
						}
						?>

					</table>
					</div>
				</div>

			</div>
			<?php
			}
		}
		
		


	/*  Add custom styles in your posts and pages content using TinyMCE WYSIWYG editor. The function adds a Styles dropdown menu in the visual post editor. 
	Based on TinyMCE Kit plug-in for WordPress */  


	/**  * Apply styles to the visual editor 
	 */    
	//add_filter('mce_css', 'tuts_mcekit_editor_style');  
	function tuts_mcekit_editor_style($url) {  
	  
		if ( !empty($url) )  
			$url .= ',';  
	  
		// Retrieves the plugin directory URL  
		// Change the path here if using different directories  
		$url .= trailingslashit( plugin_dir_url(__FILE__) ) . '/editor-styles.css';  
	  
		return $url;  
	}  
	  

	  
	function tuts_mce_editor_buttons( $buttons ) {  
		array_unshift( $buttons, 'styleselect' );  
		return $buttons;  
	}  
	  
	  
	function tuts_mce_before_init( $settings ) {
		$book_slug = @$_GET['book'];
		$Book = get_term_by('slug', $book_slug, 'book');
		
		$style_formats = pubml_custom_styles_dropdown($Book->term_id);    // Retriving the data array from custom styles
		
		// echo "<pre>";
		  // print_r($style_formats);
		// die();  
		
		$settings['style_formats'] = json_encode( $style_formats );  	  // Create the dropdown for custom styles
	  
		return $settings;  
	  
	}  
	  
	/* Learn TinyMCE style format options at http://www.tinymce.com/wiki.php/Configuration:formats */  
	  
	/* 
	 * Add custom stylesheet to the website front-end with hook 'wp_enqueue_scripts' 
	 */  
	// add_action('wp_enqueue_scripts', 'tuts_mcekit_editor_enqueue');  
	  
	/* 
	 * Enqueue stylesheet, if it exists. 
	 */  
	function tuts_mcekit_editor_enqueue() {  
		$StyleUrl = plugin_dir_url(__FILE__).'editor-styles.css'; // Customstyle.css is relative to the current file  
		wp_enqueue_style( 'myCustomStyles', $StyleUrl );  

	}


	function customformatTinyMCE($int) {
				
		$del_buttons = array('fontselect');
		$tempArray = explode(',', $int['toolbar2']);

		foreach($del_buttons as $del){
			if(($key = array_search($del, $tempArray)) !== false){
				unset($tempArray[$key]);
			}
		}
		$tempArray = array_values($tempArray);

		$int['toolbar2'] = implode(',', $tempArray);
		return $int; 		
	}

	function customformatTinyMCE1($int) {	
		
		$del_buttons = array('fontselect');
		$tempArray = explode(',', $int['toolbar2']);

		foreach($del_buttons as $del){
			if(($key = array_search($del, $tempArray)) !== false){
				unset($tempArray[$key]);
			}
		}
		$tempArray = array_values($tempArray);

		$int['toolbar2'] = implode(',', $tempArray);
		return $int; 
	}

	/********************************************************
	*	Function to pull the Styles in the dropdown list 	*
	********************************************************/

		function pubml_custom_styles_dropdown($book_id = ''){
			global $pubML, $wpdb;

			$custom_query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='style'";
			
			$style_array = $customStyles = array();		
			$mystyles  = $wpdb->get_row($custom_query);

			if(count($mystyles)){
				$customStyles =  unserialize($mystyles->style_data);			
			}else{
				$customStyles = pubml_styles_default_values();
			}	
			
			// echo "<pre>";
			// print_r($customStyles);
			// die();
				foreach($customStyles as $key => $value){
					
					if($value['hide_from_section_editor']=='true')
						continue;
						
					$style_slug = ($value['style_slug'])	? $value['style_slug'] : 'pubml-'.sanitize_title($value['style_name']);
					$style_array[] = array('title' => $value['style_name'], 'selector' => 'p',  'classes' => $style_slug);
				}		
			return($style_array);
		}
	
			
	function tinymce_editor_buttons($buttons) {
	return array(
		"bold","italic","strikethrough","bullist","numlist","blockquote","alignleft","aligncenter", 
		"alignright","link","unlink","footnote", "medialink", "columnbreak", "separator_ornament", "chapter_ornament","dropcaps","smallcaps","noindent"
		);
		// ,"wp_adv"
	}

	function tinymce_editor_buttons_second_row($buttons) {
	   //return an empty array to remove this line
		return array();
	}
?>