<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/**
 * PubML Custom Functions Section
 *
 * This file is used to create Custom Functions and contains Hooks and Actions.
 *
 * @author 		SynapseIndia
 * @category 	Core
 * @link		http://www.pubml.com
 * @package 	PubML/inc/Functions
 * @version     0.0.1
 */	

/********************************************************************
*																	*
* Create a custom post type for Sections for PubML eBook.			*
*																	*
********************************************************************/	

add_action( 'init', 'create_post_type' );
function create_post_type() {
        $args = array(
        'labels' => post_type_labels( 'Section' ),
        'public' => false,
        'publicly_queryable' => true,
        'show_ui' => true, 
        'show_in_menu' => false, 
		/*'rewrite' => array( 'slug' => '/%book%', 'with_front' => false ),*/
        'query_var' => true,
		'capability_type' => 'post',
		'has_archive' => true, 
		'can_export' => false,	
        'hierarchical' => true,
        'menu_order' => true,		
		'menu_icon' => PUBML_BASE_URL. '/images/pubml-nav-icon.png',  // Icon Path
        'supports' => array( 'title', 'editor'), //'thumbnail', 'author'
        'show_in_nav_menus' => false
    ); 
 
        register_post_type( 'pubml_books', $args );
        
}
 
// A helper function for generating the labels
function post_type_labels( $singular, $plural = '' )
{
    if( $plural == '') $plural = $singular .'s';
    
    return array(
        'name' => _x( "PubML $plural", 'page type general name' ),
        'singular_name' => _x( $singular, 'post type singular name' ),
        'add_new' => __( 'Add New' ),
        'add_new_item' => __( 'Add New '. $singular ),
        'edit_item' => __( 'Edit '. $singular ),
        'new_item' => __( 'New '. $singular ),
        'all_items' => __('All '.$plural),
        'view_item' => __( 'View '. $singular ),
        'search_items' => __( 'Search '. $plural ),
        'not_found' =>  __( 'No '. $plural .' found' ),
        'not_found_in_trash' => __( 'No '. $plural .' found in Trash' ), 
        'parent_item_colon' => ''
    );
}


/********************************************************************
*																	*
* Create a custom post type for Footnotes for PubML eBook.			*
*																	*
********************************************************************/

// Create Footnotes post type
add_action( 'init', 'create_footnote_post_type' );
function create_footnote_post_type() {
        $args = array(
        'labels' => post_type_labels( 'Footnote' ),
        'public' => false,
        'publicly_queryable' => true,
        'show_ui' => true, 
        'show_in_menu' => false, 
        'query_var' => true,
		/*'rewrite' => array( 'slug' => '/','with_front' => FALSE ),*/
		'capability_type' => 'post',
		'has_archive' => true, 
		'can_export' => false,
        'hierarchical' => true,
        'menu_order' => true,		
		'menu_icon' => PUBML_BASE_URL. '/images/pubml-nav-icon.png',  // Icon Path
        'supports' => array( 'title', 'editor', 'thumbnail'), // 'page-attributes', 'author'
        'show_in_nav_menus' => false
    ); 
 
        register_post_type( 'pubml_footnotes', $args );
        
}
 
// A helper function for generating the labels
function footnote_post_type_labels( $singular, $plural = '' )
{
    if( $plural == '') $plural = $singular .'s';
    
    return array(
        'name' => _x( $singular, 'page type general name' ),
        'singular_name' => _x( $singular, 'post type singular name' ),
        'add_new' => __( 'Add New' ),
        'add_new_item' => __( 'Add New '. $singular ),
        'edit_item' => __( 'Edit '. $singular ),
        'new_item' => __( 'New '. $singular ),
        'all_items' => __('All Footnotes'),
        'view_item' => __( 'View '. $singular ),
        'search_items' => __( 'Search '. $plural ),
        'not_found' =>  __( 'No '. $plural .' found' ),
        'not_found_in_trash' => __( 'No '. $plural .' found in Trash' ), 
        'parent_item_colon' => ''
    );
}

/********************************************************************
*																	*
* Create a custom post type for Navigations Tabs for PubML eBook.	*
*																	*
********************************************************************/

add_action( 'init', 'create_navigation_post_type' );
function create_navigation_post_type() {
        $args = array(
        'labels' => post_type_labels( 'Navigation' ),
        'public' => false,
        'publicly_queryable' => true,
        'show_ui' => true, 
        'show_in_menu' => false, 
		'query_var' => true,
		'capability_type' => 'post',
		'has_archive' => true, 
		'can_export' => false,	
        'hierarchical' => true,
        'menu_order' => true,		
		'supports' => array( 'title', 'editor'), //'thumbnail', 'author'
        'show_in_nav_menus' => false
    );  
    register_post_type( 'pubml-navigation', $args );        
}  // custom post type for Navigations Tabs ends



/**** Remove meta box for post type pubml_books ****/

function remove_post_custom_fields() {
	//remove_meta_box( 'pageparentdiv' , 'pubml_books' , 'normal' ); 
}

add_action( 'admin_menu' , 'remove_post_custom_fields' ); // Hook into WordPress


/**** add meta box for post type pubml_books ****/

// Hook into WordPress
add_action( 'admin_init', 'add_custom_metabox' );

/**
 * Add meta box
*/
function add_custom_metabox() {
	//add_meta_box( 'custom-metabox', __( 'Book Settings & other Details'  ), 'product_custom_metabox', 'pubml_books', 'advanced', 'high' );
}


/**
 * Add custom taxonomies
 *
 * Additional custom taxonomies can be defined here
 * http://codex.wordpress.org/Function_Reference/register_taxonomy
 */
function add_custom_taxonomies() {
	// Add new "Books" taxonomy to Posts
	register_taxonomy('book', 'pubml_books', array(
		// Hierarchical taxonomy (like categories)
		'show_ui' => true,
		'hierarchical' => true
	));
}
add_action( 'init', 'add_custom_taxonomies', 0 );  

####################### Assign book to 'digital book page' post ########################
	function add_hidden_field_script(){
		$book_slug = @$_GET['book'];
		$chapter = @$_GET['chapter'];
		?>
		<script>
		jQuery('<input>').attr({
			type: 'hidden',
			id: '_book',
			name: '_book',
			value: '<?php echo $book_slug;?>'
		}).appendTo('form');
		</script>
		<?php
	}
	$book_slug = @$_GET['book'];
	if(!empty($book_slug)){
		add_action('admin_print_footer_scripts', 'add_hidden_field_script');
	}

########################################################
/*### Functions to create section post using the book###*/
add_action('save_post', 'create_section_posts');
function create_section_posts() {
global $post;

$book_slug = @$_POST['_book'];
$Book = get_term_by('slug', $book_slug, 'book');

    if ($book_slug!='' && get_post_type() == 'pubml_books') {
		$set_term = wp_set_object_terms( $post->ID, $book_slug, 'book' );
    }

    if ($book_slug!='' && get_post_type() == 'pubml_footnotes') {
		update_post_meta($post->ID, 'book', $Book->term_id);
    }

}

########################################################
/*### Functions to create section post using the book###*/
add_action('save_post', 'set_sorting_order');
function set_sorting_order() {
global $post;

$book_slug = @$_POST['_book'];

	$sorting_order = get_post_meta(@$post->ID, 'sorting_status');

	if(!$sorting_order){
	$sec = query_posts(array( 
		'post_type' => 'pubml_books',
		'showposts' => -1,
		'tax_query' => array(
			array(
				'taxonomy' => 'book',
				'terms' => $book_slug,
				'field' => 'slug',
			)
		),
		'order' => 'ASC' )
	);

	$sorting = count($sec)+1;
		update_post_meta(@$post->ID, 'sorting_status', $sorting);
	}

}

########################################################
/*### Redirecting to book sections after action #######*/
add_filter('redirect_post_location', 'redirect_to_book_section');
function redirect_to_book_section()
{
global $post;
	$book_slug = $_POST['_book'];

		if ( (isset($_POST['pubml_save_section'])) && get_post_type() == 'pubml_books' && $book_slug!='') {
			wp_redirect('admin.php?page=book-sections&book="'.$book_slug.'"');	
		} else if( (isset($_POST['save']) || isset($_POST['publish'])) && get_post_type() == 'pubml_books' && $book_slug!=''){
			wp_redirect('post.php?post='.$post->ID.'&book='.$book_slug.'&action=edit');
		} else if ( (isset($_POST['pubml_save_footnote'])) && get_post_type() == 'pubml_footnotes' && $book_slug!='') {
			wp_redirect('admin.php?page=book-footnotes&book="'.$book_slug.'"');	
		} else if ( (isset($_POST['save']) || isset($_POST['publish'])) && get_post_type() == 'pubml_footnotes' && $book_slug!='') {
			wp_redirect('post.php?post='.$post->ID.'&book='.$book_slug.'&action=edit');	
		} else {
			wp_redirect('post.php?post='.$post->ID.'&action=edit');
		}
}



########################################################
############### Functions to create menu ###############
	add_action('admin_menu', 'add_other_menus');
	
	function add_other_menus(){
		add_submenu_page( 'add-new-book', 'Add/Edit New Book', 'New Book', 'manage_options', 'add-new-book', 'pubml_new_book_page');	
		add_submenu_page( 'book-sections', 'Sections', 'Sections', 'manage_options', 'book-sections', 'pubml_book_sections_page');	
		add_submenu_page( 'book-footnotes', 'Footnotes', 'Footnotes', 'manage_options', 'book-footnotes', 'pubml_book_footnotes_page');	
		add_submenu_page( 'book-styles', 'Styles', 'Styles', 'manage_options', 'book-styles', 'pubml_book_styles_page');	
		add_submenu_page( 'book-media', 'Media', 'Media', 'manage_options', 'book-media', 'pubml_book_media_page');	
		add_submenu_page( 'book-new-media', 'Add New Media', 'Add New Media', 'manage_options', 'book-new-media', 'pubml_book_new_media_page');	
		add_submenu_page( 'book-new-section', 'Add New Section', 'Add New Section', 'manage_options', 'book-new-section', 'pubml_book_new_section_page');
		add_submenu_page( 'book-new-tab', 'Add New Tab', 'Add New Tab', 'manage_options', 'book-new-tab', 'pubml_book_new_tabs_page');
		add_submenu_page( 'book-new-footnote', 'Add New Footnote', 'Add New Footnote', 'manage_options', 'book-new-footnote', 'pubml_book_new_footnote_page');
		add_submenu_page( 'pubml-book-navigation', 'PubML eBook Navigation Tab', 'PubML eBook Navigation Tab', 'manage_options', 'pubml-book-navigation', 'pubml_book_navigation_page');
		add_submenu_page( 'book-media-library', 'Media Library', 'Media Library', 'manage_options', 'book-media-library', 'pubml_media_list_page');
		
		if($valid = pubml_ebook_validation()){
		// Add a second submenu to the custom top-level menu:
			// Export Tab for each PubML Book
			add_submenu_page('pubml-book-export','PubML eBook Export Tab', 'PubML eBook Export Tab', 'manage_options', 'pubml-book-export', 'pubml_book_export_page');
		}else{
			add_submenu_page('pubml-book-export','PubML eBook Export Tab', 'PubML eBook Export Tab', 'manage_options', 'pubml-book-export', 'pubml_purchase_license_page');
		}	
		
		add_submenu_page('book-media-group', 'Media Group', 'Media Group', 'manage_options', 'book-media-group', 'pubml_book_media_group_page');
	}

#######################################################
############### Funtions to remove book ###############
add_action('wp_ajax_delete_term_book', 'delete_custom_term_book');

function delete_custom_term_book() {
	$term_id = @$_POST['term_id'];
	
	$Removeterm = wp_delete_term( $term_id, 'book' );
	
	if($Removeterm){
		$chapter_posts	 = get_all_posts_term($term_id, 'pubml_books');
		if(count($chapter_posts)){
			foreach($chapter_posts as $chapter){
				wp_delete_post($chapter->ID);
			}
			wp_reset_query();  
			wp_reset_postdata();
		}	
		
		$footnotes_posts = get_all_posts_term($term_id, 'pubml_footnotes');
		if(count($footnotes_posts)){
			foreach($footnotes_posts as $foot){
				wp_delete_post($foot->ID);
			}
			wp_reset_query();  
			wp_reset_postdata();
		}
		
		$tabs_posts 	 = get_all_posts_term($term_id, 'pubml-navigation');
		if(count($tabs_posts)){
			foreach($tabs_posts as $tab){
				wp_delete_post($tab->ID);
			}
			wp_reset_query();  
			wp_reset_postdata();
		}		
		$out = array('status'=>200, 'term_id'=>$term_id, 'msg'=> 'Book has been successfully deleted.');
		echo json_encode($out);
		exit();
	}
	$out = array('status'=>100, 'term_id'=>$term_id, 'msg'=> 'This Book could not be deleted.');
	echo json_encode($out);
	exit;
}

#########################################################################
###### Funtions to duplicate a PubML Book with Sections, Footnotes ######
add_action('wp_ajax_duplicate_pubml_ebook', 'duplicate_pubml_ebook');

function duplicate_pubml_ebook() {
	$result = Array();
	$term_id = @$_POST['term_id'];
	$Book = get_term_by('id', $term_id, 'book');
	$book_meta = get_option( "taxonomy_$term_id");
	
	if(!$Book) {
		$result['status'] = 'FALSE';
		$result['msg'] = 'This book is not available in our Library';
		$result['term_id'] = $term_id;		
		echo json_encode($result);
		exit;
	}
	
	// adding book term
		$terms = wp_insert_term(
			$Book->name.' - Copy', // the term 
			'book', // the taxonomy
			array(
				'description' => $Book->description,
				'slug' => sanitize_title( $Book->name )
			)
		); 
		$duplicate_t_id = $terms['term_id'];

		//save the option array	
		update_option( "taxonomy_$duplicate_t_id", $book_meta );	
		
		$sectionCount = duplicate_post_pubml($term_id, 'pubml_books', $duplicate_t_id, 'publish'); 	// Copy All Sections/Chapters
		
		$footnotesCount = duplicate_post_pubml($term_id, 'pubml_footnotes', $duplicate_t_id, 'publish'); 	// Copy All Footnotes/Photonotes
		$tabsCount = duplicate_post_pubml($term_id, 'pubml-navigation', $duplicate_t_id, 'publish'); 	// Copy All Navigation Tabs
		
		pubml_duplicate_all_styles_book($term_id,$duplicate_t_id );
		
		$copy_media = pubml_duplicate_all_media_book($term_id, $duplicate_t_id);
			
	
		$result['media_sect'] = $copy_media;
		$result['section_count'] = $sectionCount;
		$result['footnotesCount'] = $footnotesCount;
		$result['tabsCount'] = $tabsCount;
		$result['status'] = 'TRUE';
		$result['msg'] = 'A PubML Book has been Duplicated Sucessfully';
		$result['term_id'] = $duplicate_t_id;
		
	echo json_encode($result);
	exit;
}

###############################################################
########## Funtions to remove sections and footnotes ##########
add_action('wp_ajax_delete_post_custom', 'fn_delete_post_custom');

function fn_delete_post_custom() {
	$post_id = @$_POST['post_id'];
	$RemovePosts = wp_delete_post($post_id);
	
	if($RemovePosts){	
		$out = array('status'=>200, 'post_id'=>$post_id);
		echo json_encode($out);
	}
	exit;
}

add_action('wp_ajax_sortingQuestions', 'fn_sortingQuestions');
function fn_sortingQuestions(){
	foreach ($_POST['listItem'] as $position => $item) :
		update_post_meta($item, 'sorting_status', $position);
	endforeach;	
	$out = array('status'=>200);

	echo json_encode($out);
	exit;
}

add_action('wp_ajax_sortingToc', 'fn_sortingToc');
function fn_sortingToc(){
// print_r($_POST);
	foreach (@$_POST['parent_data'] as $position => $parent) :
		update_post_meta($parent['item_id'], 'sorting_status', $position);
		if(!empty($parent['item_id']) && !empty($parent['parent_id'])){
				update_post_meta( $parent['item_id'], 'toc_parent', $parent['parent_id']);
		} 
	else if(!empty($parent['item_id']) && empty($parent['parent_id'])){
		global $wpdb;
		$wpdb->query($wpdb->prepare( "DELETE FROM {$wpdb->prefix}postmeta WHERE meta_key = 'toc_parent' AND post_id = %d",$parent['item_id']));
		} 		
	endforeach;	
	$out = array('status'=>200);

	echo json_encode($out);
	exit;
}

add_action('wp_ajax_CreateSection', 'fn_CreateSection');
function fn_CreateSection(){
	global $current_user;

	$SecTitle = @$_POST['pubml_post_title'];
	$SecContent = @$_POST['pubml_post_content'];
	$ActType = @$_POST['act_type'];
	$BookSlug = @$_POST['_book'];
	$section = @$_POST['pubml_post'];
	$section_type = @$_POST['section_type'];
	$custom_section_image = @$_POST['custom_section_image'];
	$pubml_post_type = @$_POST['pubml_post_type'];

	$custom_footnote_image = @$_POST['custom_footnote_image'];

	$Book = get_term_by('slug', $BookSlug, 'book');

	if($ActType=='edit'){
		$SecPost = array(
		  'ID'           => $section,
		  'post_title'    => $SecTitle,
		  'post_content'  => $SecContent,
		  'post_name'	  => sanitize_title($SecTitle)
		);
		wp_update_post( $SecPost );
		$pubml_post_id = $section;
		
		if($pubml_post_type=='pubml_books'){
			$set_term = wp_set_object_terms( $pubml_post_id, $BookSlug, 'book' );
			update_post_meta($pubml_post_id, 'section_type', $section_type);
			if($section_type=='image'){
				update_post_meta($pubml_post_id, 'custom_section_image', $custom_section_image);
			}
		}

		if($pubml_post_type=='pubml_footnotes'){
			update_post_meta($pubml_post_id, 'book', $Book->term_id);
			$custom_footnote_image = pubml_image_resize( $custom_footnote_image, 260, 180, true );
			update_post_meta($pubml_post_id, 'custom_footnote_image', $custom_footnote_image);
		}

	} else {
	  $SecPost = array(
		  'post_type'     => $pubml_post_type,
		  'post_title'    => $SecTitle,
		  'post_content'  => $SecContent,
		  'post_name'	  => sanitize_title($SecTitle),
		  'post_status'   => 'publish',
		  'post_author'   => $current_user->ID
		 );
		$pubml_post_id = wp_insert_post( $SecPost );

		if($pubml_post_type=='pubml_books'){
			$set_term = wp_set_object_terms( $pubml_post_id, $BookSlug, 'book' );
			$SortingOrder = count_pubml_posts($BookSlug)+1;

			update_post_meta($pubml_post_id, 'sorting_status', $SortingOrder);
			update_post_meta($pubml_post_id, 'section_type', $section_type);
			if($section_type=='image'){
				update_post_meta($pubml_post_id, 'custom_section_image', $custom_section_image);
			}
		}
		
		if($pubml_post_type=='pubml-navigation'){
			$set_term = wp_set_object_terms( $pubml_post_id, $BookSlug, 'book' );
			$SortingOrder = count_pubml_posts($BookSlug)+1;
			update_post_meta($pubml_post_id, 'sorting_status', $SortingOrder);			
		}

		if($pubml_post_type=='pubml_footnotes'){
			update_post_meta($pubml_post_id, 'book', $Book->term_id);
			$custom_footnote_image = pubml_image_resize( $custom_footnote_image, 260, 180, true );
			update_post_meta($pubml_post_id, 'custom_footnote_image', $custom_footnote_image);
		}

	}

	$out = array('status'=>200,'pubml_post_id'=>$pubml_post_id,'act_type'=>$ActType,'book'=>$BookSlug,'section_type'=>$section_type);
	echo json_encode($out);
	exit;
}
##################### Count PubML Posts ##################
function count_pubml_posts($BookSlug){
		$sec = query_posts(array( 
			'post_type' => 'pubml_books',
			'showposts' => -1,
			'tax_query' => array(
				array(
					'taxonomy' => 'book',
					'terms' => $BookSlug,
					'field' => 'slug',
				)
			),
			'order' => 'ASC' )
		);

		$sorting = count($sec);

		return $sorting;
}

########### Get Last post updated date and time by termid  #############
function get_modify_date_by_term($term_id){
	$pubml_sections = get_posts(array(
		'posts_per_page'   => 1,
		'post_type' => 'pubml_books',
		'orderby'   => 'modified',
		'order'     => 'DESC',
		'tax_query' => array(
			array(
			'taxonomy' => 'book',
			'field' => 'term_id',
			'terms' => $term_id)
		))
	);
	wp_reset_query(); 
	wp_reset_postdata();
	if(count($pubml_sections) > 0){
		return $pubml_sections[0]->post_modified;
	}
	return false;
}

add_action('admin_init', 'get_modify_date_by_term');


###################### Rename publish and update button #####################

class rename_pblish_buttons {
    // store the options
    protected $params;

    /**
     * Set up basic information
     * 
     * @param  array $options
     * @return void
     */
    public function __construct( array $options )
    {
        $defaults = array (
            'domain'       => 'default'
        ,   'context'      => 'backend'
        ,   'replacements' => array ()
        ,   'post_type'    => array ( 'pubml_books' )
        );

        $this->params = array_merge( $defaults, $options );

        // When to add the filter
        $hook = 'backend' == $this->params['context'] 
            ? 'admin_head' : 'template_redirect';

        add_action( $hook, array ( $this, 'register_filter' ) );
    }

    /**
     * Conatiner for add_filter()
     * @return void
     */
    public function register_filter()
    {
        add_filter( 'gettext', array ( $this, 'translate' ), 10, 3 );
    }

    /**
     * The real working code.
     * 
     * @param  string $translated
     * @param  string $original
     * @param  string $domain
     * @return string
     */
    public function translate( $translated, $original, $domain )
    {
        // exit early
        if ( 'backend' == $this->params['context'] )
        {
            global $post_type;

            if ( ! empty ( $post_type ) 
                && ! in_array( $post_type, $this->params['post_type'] ) )
            {
                return $translated;
            }
        }

        if ( $this->params['domain'] !== $domain )
        {
            return $translated;
        }

        // Finally replace
        return strtr( $original, $this->params['replacements'] );
    }
}

// Sample code
// Replace 'Publish' with 'Save' and 'Preview' with 'Lurk' on pages and posts
$rename_pblish_buttons = new rename_pblish_buttons(
    array (
        'replacements' => array ( 
            /*'Publish' => 'Save Section'
        ,  */ 'Update' => 'Update Section' 
        )
    ,   'post_type'    => array ('pubml_books')
    )
);

###########################################################
/* Rewrite the rule and added the book name to the slug */
add_action('init', 'flush_rewrite_rules');

function section_post_link( $post_link, $id = 0 ){
    $post = get_post($id);  
    if ( is_object( $post ) ){
        $terms = wp_get_object_terms( $post->ID, 'book' );
        if( $terms ){
            return str_replace( '%book%' , $terms[0]->slug , $post_link );
        }
    }
    return $post_link;  
}
add_filter( 'post_type_link', 'section_post_link', 1, 3 );

################### Custom Tabs Functions ####################
function fn_custom_tabs_toc($tab_name){
	$book_slug = @$_GET['book'];
	$Book = get_term_by('slug', $book_slug, 'book');
	$book_id = @$Book->term_id;
	
	$check_existance = term_exists("$book_slug", 'book');	
	$_pubml_book_status = ($check_existance !== 0 && $check_existance !== null) ? 'ValidPubMLeBook' : 'InvalidPubMLeBook' ;
	
	?>
	<!--TABS------------------------------>
	<h2 class="nav-tab-wrapper">
		<a class="<?php _e($_pubml_book_status);?> nav-tab <?php if($tab_name=='Book Info') { echo 'nav-tab-active'; } ?> second-nav-tab" title="Book Info" href="admin.php?page=add-new-book&action=edit&taxonomy=book&tag_ID=<?php echo $book_id; ?>&book=<?php echo $book_slug;?>">Book Info</a>
		<a class="<?php _e($_pubml_book_status);?> nav-tab <?php if($tab_name=='Table of Contents') { echo 'nav-tab-active'; } ?> second-nav-tab" title="Sections" href="admin.php?page=book-sections&book=<?php echo $book_slug;?>">Table of Contents</a>
		<a class="<?php _e($_pubml_book_status);?> nav-tab <?php if($tab_name=='Styles') { echo 'nav-tab-active'; } ?> second-nav-tab" title="Media" href="admin.php?page=book-styles&book=<?php echo $book_slug;?>">Styles</a>
		<a class="<?php _e($_pubml_book_status);?> nav-tab <?php if($tab_name=='Media') { echo 'nav-tab-active'; } ?> second-nav-tab" title="Media" href="admin.php?page=book-media-library&book=<?php echo $book_slug;?>">Media</a>
		<a class="<?php _e($_pubml_book_status);?> nav-tab <?php if($tab_name=='Footnotes') { echo 'nav-tab-active'; } ?> second-nav-tab" title="Footnotes" href="admin.php?page=book-footnotes&book=<?php echo $book_slug;?>">Footnotes</a>
		<a class="<?php _e($_pubml_book_status);?> nav-tab <?php if($tab_name=='Navigation') { echo 'nav-tab-active'; } ?> second-nav-tab" title="Navigation" href="admin.php?page=pubml-book-navigation&book=<?php echo $book_slug;?>">Navigation</a>
		<?php if($valid = pubml_ebook_validation()){ ?>
		<a class="<?php _e($_pubml_book_status);?> nav-tab <?php if($tab_name=='Preview') { echo 'nav-tab-active'; } ?> second-nav-tab preview_PubML" title="Preview" href="javascript:void(0);" id="<?php echo $book_id; ?>" >Preview</a>
		<?php } ?>
		<a class="<?php _e($_pubml_book_status);?> nav-tab <?php if($tab_name=='Export') { echo 'nav-tab-active'; } ?> second-nav-tab" title="Export" href="admin.php?page=pubml-book-export&book=<?php echo $book_slug;?>">Export</a>
	</h2>
<?php }
################### Custom Tabs Functions ####################
function fn_custom_tabs_main($tab_name=''){
?>
	<h2 class="nav-tab-wrapper">
		<a class="nav-tab <?php if($tab_name=='Settings') { echo 'nav-tab-active'; } ?>" title="Settings" href="admin.php?page=pubml-ebook-plugin">Settings</a>
	<!--	<a class="nav-tab <?php if($tab_name=='New Book' || $tab_name=='Edit Book') { echo 'nav-tab-active'; $ptitle = $tab_name; } else { $ptitle = "New Book"; } ?>" title="New Book" href="admin.php?page=add-new-book"><?php echo $ptitle;?></a>  -->
		<a class="nav-tab <?php if($tab_name=='My Books') { echo 'nav-tab-active'; } ?>" title="My Books" href="admin.php?page=my-books">My Books</a>
		<a class="nav-tab <?php if($tab_name=='Fonts') { echo 'nav-tab-active'; } ?>" title="Fonts" href="admin.php?page=fonts">Fonts</a>
		<a class="nav-tab <?php if($tab_name=='Help') { echo 'nav-tab-active'; } ?> openhelp" id="help_index" title="Help" href="javascript:void(0)">Help</a>
	</h2>
	
	<div id="popup" class="helpbox" style="display:none;">
		<div class="helpbox-icon"><img src="<?php echo PUBML_BASE_URL;?>/images/pubml-nav-icon.png" width="16" height="16"  alt=""/></div>
		<div class="helpbox-title">PubML Help<span style="float:right;font-size: 14px;"><a href="<?php echo PUBML_BASE_URL; ?>/helps/help_index.html" target="help_iframe">Help Topics</a></span></div>
		<span class="button b-close"><span>X</span></span>
		<div class="help-separator"><hr /></div>
		<div id="helpbox-content"></div>		
	</div>

	<div id="previewPopup" style="width:100%; height:100%;display:none;" class="previewBox">
		<span class="button b-close"><span>X</span></span>
		<div id="preview-content" style="width:100%; height:100%"></div>		
	</div>
	<div id="pluginAlertBox" style="display:none;" class="pluginAlertBox">
		<span class="pluginAlertBox button b-close"><span>X</span></span>
		<div id="pluginAlertBox-content"></div>		
	</div>
	
	
<?php } 
add_action( 'post_submitbox_misc_actions', 'add_custom_button_publish' );

function add_custom_button_publish() {
    global $post;
    if (get_post_type($post) == 'pubml_books') {
        echo "<div class='custom_publish_button'><input type='submit' class='big_green_button' name='pubml_save_section' value='Back to Table of Contents'></div>";
    }
    if (get_post_type($post) == 'pubml_footnotes') {
        echo "<div class='custom_publish_button'><input type='submit' class='big_green_button' name='pubml_save_footnote' value='Back to Footnotes'></div>";
    }
}

###############################################################
########## Funtions to Get footnote ##########
add_action('wp_ajax_get_footnote', 'fn_get_footnote');

function fn_get_footnote() {
	$footnoteSlug = @$_POST['footnote_slug'];
	$args=array(
	  'name' => $footnoteSlug,
	  'post_type' => 'pubml_footnotes',
	  'post_status' => 'publish',
	  'numberposts' => 1
	);
	$FootnotePost = get_posts($args);
	$custom_footnote_image = get_post_meta($FootnotePost[0]->ID,'custom_footnote_image',true);
	$footnote_image = ($custom_footnote_image)? $custom_footnote_image : PUBML_BASE_URL.'/images/default_note_bg.jpg';
	
	if( $FootnotePost ) {
	  $footnoteHTML = "<div class='footnoteContainer'>";
	  $footnoteHTML .= "<div class='footnoteImage'><img src='".$footnote_image."'></div>";
	  $footnoteHTML .= "<div class='footnoteContent'>".$FootnotePost[0]->post_content."</div>";
	  $footnoteHTML .= "</div>";
	}
	
	if($footnoteSlug){	
		$out = array('status'=>200, 'footnoteSlug'=>$footnoteSlug, 'footnoteContent'=>$footnoteHTML);
		echo json_encode($out);
	}
	wp_reset_query(); 
	wp_reset_postdata();
	exit;
}

add_filter('mce_buttons_2', 'add_fontselect_row_2' );
//add_filter('mce_buttons_3', 'add_fontselect_row_3' );
 
function add_fontselect_row_2( $mce_buttons ) {
	/*
	if some items aren't removed from the second row
	the buttons won't fit nicely on a 1024x768 screen
	find the keys of the buttons to be sacrificed
	 
	see WordPress's default buttons in wp_tiny_mce()
	http://phpxref.ftwr.co.uk/wordpress/wp-admin/includes/post.php.source.html#l1415
	*/
	$pastetext = array_search( 'pastetext', $mce_buttons );
	// $pasteword = array_search( 'pasteword', $mce_buttons );
	// $removeformat = array_search( 'removeformat', $mce_buttons );
	 
	unset( $mce_buttons[ $pastetext ] );
	// unset( $mce_buttons[ $pasteword ] );
	// unset( $mce_buttons[ $removeformat ] );
	 
	/*
	insert the new dropdown where the sacrificed buttons used to be
	alter as needed
	*/
	array_splice( $mce_buttons, $pastetext, 0, 'fontselect' );
		return $mce_buttons;
}
function add_fontselect_row_3( $mce_buttons ) {
	/*
	nothing appears in the third row (or forth) by default, so no magic needed
	*/
	// $mce_buttons[] = 'fontselect';
	
	$removeformat = array_search( 'formatselect', $mce_buttons );
	unset( $mce_buttons[ $removeformat ] );
	
	return $mce_buttons;
}
	 
/*
customize available fonts
edit as needed to modify the available fonts
*/
//add_filter('tiny_mce_before_init', 'restrict_font_choices' );

function restrict_font_choices( $initArray ) {
	$initArray['theme_advanced_fonts'] =
	'Alegreya=Alegreya;'.
	'Crimson Text=Crimson Text;'.
	'Old Standard TT=Old Standard TT;'.
	'Andale Mono=andale mono,times;'.
	'Arial=arial,helvetica,sans-serif;'.
	'Arial Black=arial black,avant garde;'.
	'Book Antiqua=book antiqua,palatino;'.
	'Comic Sans MS=comic sans ms,sans-serif;'.
	'Courier New=courier new,courier;'.
	'Georgia=georgia,palatino;'.
	'Helvetica=helvetica;'.
	'Tahoma=tahoma,arial,helvetica,sans-serif;'.
	'Terminal=terminal,monaco;'.
	'Times New Roman=times new roman,times;'.
	'Trebuchet MS=trebuchet ms,geneva;'.
	'Verdana=verdana,geneva;'.
	'';
	return $initArray;
}


function duplicate_post_pubml($term_id, $post_type, $new_book_id, $post_status = 'draft'){
	global $wpdb, $pubml;
	
	/*
	 * if you don't want current user to be the new post author,
	 * then change next couple of lines to this: $new_post_author = $post->post_author;
	 */
	$current_user = wp_get_current_user();
	$new_post_author = $current_user->ID;
	
	$post_key_array = array();
	
	$all_posts	 = get_all_posts_term($term_id, $post_type);
	if(count($all_posts)){
		foreach ($all_posts as $post) {
			$post_id = $post->ID; 	// Get the original post id 
			$post = get_post( $post_id ); 	//and all the original post data then
			
			// if post data exists, create the post duplicate
			if (isset( $post ) && $post != null) {
				$new_post_id = '';
				/*
				 * new post data array
				 */
				$args = array(
					'comment_status' => $post->comment_status,	'ping_status'  	 => $post->ping_status,	
					'post_author'    => $new_post_author,		'post_content'   => $post->post_content,	
					'post_excerpt' 	 => $post->post_excerpt,	'post_name'      => $post->post_name,
					'post_parent'    => $post->post_parent,		'post_password'	 => $post->post_password,	
					'post_status'    => $post_status,			'post_title'     => $post->post_title,		
					'post_type'      => $post->post_type,		'to_ping'        => $post->to_ping,
					'menu_order'     => $post->menu_order
				);
				$new_post_id = wp_insert_post( $args );	//	insert the post by wp_insert_post() function
				unset($args);
				
				$post_key_array[$post_id] = $new_post_id ;
		 
				//	get all current post terms ad set them to the new post draft
				$taxonomies = get_object_taxonomies($post->post_type); // returns array of taxonomy names for post type, ex array("category", "post_tag");
				
				// $taxonomies = get_object_taxonomies('pubml_footnotes');
				// exit(print_r($taxonomies));
				wp_set_object_terms($new_post_id, $new_book_id, 'book', false);
			}			
		}
		wp_reset_query();  	// Restore original Post Data		
		wp_reset_postdata();
		unset($all_posts);
			
			//	duplicate all post meta
			foreach ($post_key_array as $post_id => $new_post_id){
				$post_meta_infos = $wpdb->get_results("SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=$post_id");
				if (count($post_meta_infos)!=0) {
					$sql_query = "INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) ";
					foreach ($post_meta_infos as $meta_info) {
						$meta_key = $meta_info->meta_key;
						$meta_value = addslashes($meta_info->meta_value);
						$meta_value = ($meta_key== 'book' ) ? $new_book_id : $meta_value;
												
						if (array_key_exists( $meta_value, $post_key_array)) {
							$meta_value = $post_key_array[$meta_value];		// Assign the new post id to toc_parent
						}						
						$sql_query_sel[]= "SELECT $new_post_id, '$meta_key', '$meta_value'";
					}
					$sql_query.= implode(" UNION ALL ", $sql_query_sel);										
				}
				wp_reset_query();  
			}
		
		$wpdb->query($sql_query);
		wp_reset_query();  
	}
	wp_reset_query();
	wp_reset_postdata();
	unset($post_key_array);
	return count($all_posts);
}

/************************************************
*	Get all posts for a term with post_type 	*
************************************************/

function get_all_posts_term($term_id, $post_type){
	global $wpdb, $pubml;
	
	if($post_type == 'pubml_footnotes'){
		// All Footnotes of a eBook 
		$pubml_posts = query_posts(array( 
			'post_type' => $post_type,
			'showposts' => -1,
			'meta_query' => array(
				array(
					'key' => 'book',
					'value' => $term_id,
				)
			),
			/*'orderby' => 'title',  */
			'order' => 'ASC' )
		);	
	}else{
		// All Chapters/Sections of a eBook 
		$pubml_posts = get_posts(array(
		'post_type' => $post_type ,
		'showposts' => -1,
		'tax_query' => array(
				array(
				'taxonomy' => 'book',
				'field' => 'term_id',
				'terms' => $term_id)
			),
			'order' => 'ASC' )			
		);
	}	
	wp_reset_query();  
	wp_reset_postdata();
	return $pubml_posts;
}


/************************************************************
*	Get all media source and media group for a pubml book 	*
************************************************************/

function pubml_duplicate_all_media_book($term_id, $new_book_id){
	global $wpdb, $pubml;
	$book_id = $term_id;
	$old_msource_array = array();
	$old_mgroup_array  = array();
	
	// All Media for Pubml eBook 
	$ebook_media_rows = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}book_media WHERE {$wpdb->prefix}book_media.book_id = {$book_id}");
	if (count($ebook_media_rows)!=0) {
		foreach ($ebook_media_rows as $media_info) {
			$wpdb->insert( 
				"{$wpdb->prefix}book_media", 
				array( 
					'media_title' => $media_info->media_title, 
					'media_url'   => $media_info->media_url, 
					'media_slug'  => $media_info->media_slug, 
					'media_type'  => $media_info->media_type, 
					'book_id' 	  => $new_book_id 
				), 
				array( '%s', '%s', '%s', '%s', '%d' ) 
			); 
			$old_msource_array[$media_info->media_id] = $wpdb->insert_id; 
		}
		unset($ebook_media_rows);
	}
	wp_reset_query();  	// Restore original Post Data		
	wp_reset_postdata();
	
	$ebook_gmedia_rows = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}media_group WHERE {$wpdb->prefix}media_group.book_id = {$book_id}");
	$wpdb->flush();
	if (count($ebook_gmedia_rows)!=0) {
		foreach ($ebook_gmedia_rows as $gmedia_info) {
			$wpdb->insert( 
				"{$wpdb->prefix}media_group", 
				array( 
					'group_title' => $gmedia_info->group_title, 
					'group_slug'  => $gmedia_info->group_slug, 
					'book_id' 	  => $new_book_id 
				), 
				array( '%s', '%s', '%d' ) 
			); 
		//die($wpdb->last_error);
			$old_mgroup_array[$gmedia_info->group_id] = $wpdb->insert_id;
		}
	unset($ebook_gmedia_rows);	
	}
	wp_reset_query();  	// Restore original Post Data		
	wp_reset_postdata();
	
	// Copy media association 
	$ebook_media_assoc_rows = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.book_id = {$book_id}");
	$wpdb->flush();
	if (count($ebook_media_assoc_rows)!=0) {
		$assoc_array = array();
		
		foreach ($ebook_media_assoc_rows as $assoc_info) {
			$media_source = $assoc_info->media_id;
			$media_group  = $assoc_info->associate_groups;
		
			//if((isset($old_msource_array[$media_source])) && (isset($old_mgroup_array[$media_group]))){
			if((array_key_exists($media_source, $old_msource_array)) && (array_key_exists($media_group, $old_mgroup_array))){
				$wpdb->insert( 
					"{$wpdb->prefix}media_group_association", 
					array(				
						'media_id'  => $old_msource_array[$media_source] , 
						'associate_groups' 	  => $old_mgroup_array[$media_group] ,
						'book_id' => $new_book_id, 
					), 
					array( '%d', '%s', '%d' ) 
				);			
			}	
				$assoc_array[$old_msource_array[$media_source]] = $old_mgroup_array[$media_group] ;
		} 
		//die($wpdb->last_error);
		unset($ebook_media_assoc_rows);
	}
	wp_reset_query();  	// Restore original Post Data		
	wp_reset_postdata();	
	
	return array($old_msource_array, $old_mgroup_array, $assoc_array);
	//return $old_msource_array[4];
}

/********************************************
*	Get all pubml ebook styling section  	*
********************************************/

function pubml_duplicate_all_styles_book($term_id, $new_book_id){
	global $wpdb, $pubml;
	$book_id = $term_id;
	
	$book_style_info = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}book_style  WHERE {$wpdb->prefix}book_style.book_id = {$book_id}");
	if (count($book_style_info)!=0) {	
		// All Styles for Pubml eBook 
		$myrows = $wpdb->get_results("INSERT INTO {$wpdb->prefix}book_style ( `style_data` , `style_name` , `type` , `book_id`) SELECT t.`style_data` , t.`style_name` , t.`type` , {$new_book_id} FROM {$wpdb->prefix}book_style AS t WHERE t.`book_id` = {$book_id}", OBJECT);
	}
	
	return $term_id;
}



	
/*****************************************************************************************/
/********** Function start to generate the shortcodes as per the book id	 *************/
/*****************************************************************************************/	

	function PubML_book_preview( $atts ) {  		
		global $wpdb, $pubml; // Setup global database table names

		extract( shortcode_atts( array(
			'book' => 1,
			'showbadge' => false
		), $atts ) );

		$book_slug = $book;
		$showBadge = $showbadge;
		$PubMLBook = get_term_by('slug', $book_slug, 'book');
		
		if($book_slug && $PubMLBook){
			
			$book_meta = get_option("taxonomy_$PubMLBook->term_id");
			$style_array = $customStyles = array();	

			$custom_query = "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$PubMLBook->term_id} AND {$wpdb->prefix}book_style.type='all-data'";

			$mystyles  = $wpdb->get_row($custom_query);

			if(count($mystyles)){
				$customStyles =  unserialize($mystyles->style_data);			
			}else{
				$customStyles =  PubML_default_style_data();
			}
			if($customStyles['background']['back-img-val']){
					$imgurl = $customStyles['background']['back-img-val'];
			}
			
			if($customStyles['background']['background-type']== 'full'){
				$back_img = "background:url($imgurl) no-repeat scroll 0 0 / 100% 100% transparent;margin:0";
			}
			if($customStyles['background']['background-type']== 'tile'){
				$back_img = "background:url($imgurl) repeat transparent;margin:0";
			}
		
			
			$plugin_expired_date = pubml_ebook_check_remote_validation('expires');
			$book_modified_date    = strtotime($book_meta['book_modified_date']);
			$content_modified_date = strtotime(get_modify_date_by_term($PubMLBook->term_id));
			//echo $book_modified_date." <> ".$content_modified_date;

			$modified_data = ($book_modified_date < $content_modified_date) ? date("M. d, Y",$content_modified_date) : date("M. d, Y",$book_modified_date) ;
		
			$cover_metadata = ($book_meta['cover_meta']) ? stripslashes($book_meta['cover_meta']) : PUBML_BASE_URL."/images/placeholder.png";
			$preview_img = PUBML_BASE_URL.'/images/full-preview.png';
			$replace_text = "<div id='def_book_prev_$PubMLBook->term_id' style='padding-bottom:1%;text-align:center;min-height:650px;$back_img' class='def-book-prev'><img id='$PubMLBook->term_id' class='preview_PubML_book' showbadge='$showbadge' width='460' height='640' src='$cover_metadata' style='margin-top:32px;cursor:pointer;'/>
			<div style='background: none repeat scroll 0 0 #000000;height: 30px;margin: -0.6% auto 0;
				padding: 2px 0;text-align: center;width: 52%;' id='book-footer'><a style='color:#fff;' id='$PubMLBook->term_id' showbadge='$showbadge' target='_top' class='preview_PubML_book' href='javascript:void(0);'>Click To Read</a><img style='float: right;margin-right: 1%;
				margin-top: 1%;cursor:pointer;' src='$preview_img' id='$PubMLBook->term_id' showbadge='$showbadge' class='preview_PubML' /></div></div>";		
			$output_data = $replace_text; // return displaying links		
		}else{
			$output_data = '<div style="text-align:center;">This book is temporarily unavailable.<br/><br/>Please tell the publisher.</div>'; 		
		}
		
		return 	$output_data;
	}
	
	apply_filters('the_content','PubML_book_preview');

	function register_PubML_shortcodes(){
	   add_shortcode('PubML', 'PubML_book_preview');
	}

	add_action( 'init', 'register_PubML_shortcodes');

/*****************************************************************************************/
/**********  Function end to generate the shortcodes as per the book id		 *************/
/*****************************************************************************************/	

  
  
  /*****************************************************************************************/
/********** Function start to generate the default style data array	 *************/
/*****************************************************************************************/	

	function PubML_default_style_data( ) {  		

	$pubml_default_styles_data =  array
					(
						'book_id' => 34,
						'background' => array
							(
								'back-img-val' => PUBML_BASE_URL.'/images/custom_back.jpg',
								'background-type' => 'tile',
								'custom-image' => PUBML_BASE_URL.'/images/custom_back.jpg',
								'default-image' => PUBML_BASE_URL.'/images/default_back.jpg',
								'custom-image-thumb' => PUBML_BASE_URL.'/images/custom_back_80x80.jpg',
								'default-image-thumb' => PUBML_BASE_URL.'/images/default_back_80x80.jpg',
								'paper-img-val' => PUBML_BASE_URL.'/images/leftpage_white.png',
								'def-paper-img-val' => PUBML_BASE_URL.'/images/default_paper.jpg',
								'color-val' => 'F8EAD0',
							),

						'layout' => array
							(
								'book-page-size' => 69,
								'layout-img-width' => '',
								'layout-img-height' => '',
								'book-page-margin' => 'classic',
								'layout-top-margin' => '',
								'layout-bottom-margin' => '',
								'layout-out-margin' => '',
								'layout-in-margin' => '',
							),
							
						'running_head' => array
							(
								'orn-head-val' => '',
								'def-orn-head-val' => PUBML_BASE_URL.'/images/Running-Heads1.png',
								'book-head-loc' => 'right',
								'head-content' => 'title',
								'custom-val-head' => '',
							),

						'text_style' => array
							(
								'orn-style-val' => PUBML_BASE_URL.'/images/section_ornament_placeholder.png',
								'def-orn-style-val' => PUBML_BASE_URL.'/images/section_ornament_placeholder.png',
							),

						'style' => 1,
						'style_name_val' => 'Running Head',
						'add-new-style-val' => 0,
						'style-slug' => 'pubml-running-head',
						'hide_from_section_editor' => 'false',
						'style-desc' => 'text style for running head at top of page (alignment controlled by running head style editor)',
						'style-prev' => 'Pack my box with five dozen liquor jugs.',
						'text-font-menu' => 'Georgia, serif',
						'text-font-weight' =>'bold',
						'hypen-val' => 'off',
						'runt-val' => 'off',
						'align-val' => 'center',
						'initial_caps' => array
							(
								'capitals-val' => 'dropcaps_2',
							),

						'seperator_ornament' => array
							(
								'custom-separator' => 'sep_1',
								'upload-sep-link-val' => '',
							),
						'page_numbers' => array
							(
								'book-hpos' => 'center',
								'text-before' => ' ',
								'text-after' => ' ',
								'style-two-font-val' => 15,
								'pagenumber-font-weight' => 'normal',
								'font-bold' => 'bold',
								'font-italic' => 'italic',
							),
						'page-number-font-menu'=> 'Crimson Text',
					);
		return $pubml_default_styles_data;
	}
/*****************************************************************************************/
/**********  Function end to generate the default style data array	End		 *************/
/*****************************************************************************************/	

/*****************************************************************************************************/
/**********  Function to display PubML Publishing Tools subscription has expired		 *************/
/*****************************************************************************************************/

	function pubml_ebook_admin_notice() {
		global $current_user ;
		$user_id = $current_user->ID;
		$plugin_status = pubml_ebook_check_remote_validation();
		
		if($plugin_status == 'expired'){
			/* Check that the user hasn't already clicked to ignore the message */
			if (  ! get_user_meta($user_id, 'pubml_ignore_notice')  ) {
				echo '<div class="update-nag"><p>';
				printf(__('<b>&lt;PubML&gt;™ EBook Publisher Plugin : </b>Your subscription has expired. You will not be able to preview or export any updates to eBooks. Existing embedded eBooks will appear in their last saved versions. Previously exported eBooks will continue to function. Please renew your subscription at <a href="https://www.pubml.com">https://www.pubml.com</a> | <a href="%1$s%2$s">Hide Notice</a>'), admin_url(), '?pubml_nag_ignore=0');
				echo "</p></div>";
			}
		}
		
	}
	add_action( 'admin_notices', 'pubml_ebook_admin_notice' );	
	
	
	add_action('admin_init', 'pubml_nag_ignore');
	function pubml_nag_ignore() {
		global $current_user;
			$user_id = $current_user->ID;
			/* If user clicks to ignore the notice, add that to their user meta */
			if ( isset($_GET['pubml_nag_ignore']) && '0' == $_GET['pubml_nag_ignore'] ) {
				 add_user_meta($user_id, 'pubml_ignore_notice', 'true', true);
		}
	}	
	
	
	

/**
 * Filter the link query arguments to change the post types. 
 *
 * @param array $query An array of WP_Query arguments. 
 * @return array $query
 */
	function my_custom_link_query( $query ){

		// custom post type slug to be removed
		$post_type_array = array('pubml_books','pubml_footnotes','pubml-navigation');      // Edit this to your needs
		
		foreach ($post_type_array as $cpt_to_remove ){
			// find the corresponding array key
			$post_key = array_search( $cpt_to_remove, $query['post_type'] ); 
			// remove the array item
			if( $post_key )
			unset( $query['post_type'][$post_key] );
		}
		return $query; 
	}

add_filter( 'wp_link_query_args', 'my_custom_link_query' );

?>