<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	

	*	Media Library File

	*	---------------------------------------------------------------------

	* 	@version	1.0

	* 	@author		SynapseIndia

	* 	@link		http://www.synapseindia.com

	*	---------------------------------------------------------------------

	*	This file is used to manage book media library page.

	*	---------------------------------------------------------------------

	*/

?>

<?php

/**************************

	Media Tab

**************************/

$book_slug = @$_GET['book'];

$Book = get_term_by('slug', $book_slug, 'book');

$book_id=$Book->term_id;

$book_meta = get_option( "taxonomy_$book_id");

$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];

$edition_notes = ($book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';

global $wpdb;

if(@$_GET['mid']){

	$mid = @$_GET['mid'];

	$wpdb->query($wpdb->prepare( "DELETE FROM {$wpdb->prefix}book_media WHERE media_id = {$mid} ") );	

	wp_redirect( admin_url('admin.php?page=book-media-library&book='.$book_slug));

}

?>

<div id="book_meta">

        <h2 class="media-lib-icon">Media Library for <i><?php echo $Book->name ;?><span style="font-size: 14px;font-style: normal;font-weight: bold;margin: 0;">&nbsp;(<?php echo $edition_notes ; ?>)</span></i> <span class="help openhelp" id="media_links" style="margin-left:10px"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span></h2>

	

	<!--TABS------------------------------>

	<div class="primary_menu_bar">

		<?php fn_custom_tabs_main('My Books');?>

	</div>

	<div class="clear"></div>

	<div class="secondary_menu_bar">   

		<?php fn_custom_tabs_toc('Media');?>

	</div>



		<div class="content_container media" style="float:left;">

				<?php if(@$_GET['mid']){ ?>

				<span class="msg-text">Media item deleted successfully for the book.

				</span>

				<div style="clear:both;"></div>

				<?php } ?>

			<div class="left_content_container">

					<div class="media_source_text">

						<h1>Media Sources</h1>

						<b>Media Sources</b> are links to Google Maps, Flicker Galleries,YouTube playlists and images in your Wordpress Media Library. Select a media source on the left to highlight any associated media groups on the right (or to associate it with a new media group). Select the title of a media group on the right to highlight associated media sources on the left.

					</div>

					<div class="media-filter">

						<span>SHOW/HIDE</span>

						<span><input type="checkbox"  checked="checked" class= "media-filter-val" name="media-filter-val[]" value="youtube" /><img src="<?php echo PUBML_BASE_URL;?>/images/media-icon-youtube.png"   alt=""/><br/>VIDEOS</span>

						<span><input type="checkbox"  checked="checked" class= "media-filter-val" name="media-filter-val[]" value="flickr" /><img src="<?php echo PUBML_BASE_URL;?>/images/media-icon-flickr.png"   alt=""/><br/>Flickr</span>

						<span><input type="checkbox" checked="checked" class= "media-filter-val" name="media-filter-val[]" value="map" /><img src="<?php echo PUBML_BASE_URL;?>/images/media-icon-google-map.png"   alt=""/><br/>MAPS</span>

						<span><input type="checkbox" checked="checked" class= "media-filter-val" name="media-filter-val[]" value="wordpress" /><img src="<?php echo PUBML_BASE_URL;?>/images/media-icon-wp-image.png"   alt=""/><br/>IMAGES</span>

						

					</div>

					<div class="media_source_listing">

				<?php 

						$myrows = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}book_media WHERE {$wpdb->prefix}book_media.book_id ={$book_id} ORDER BY {$wpdb->prefix}book_media.media_title ASC", OBJECT);

						if ($myrows) {

							$i=1;

							foreach ( $myrows as $media ) {

								if($i%2==0){$cls='even';}

								else{$cls='odd';}

								if (strpos($media->media_url,'maps') != false){

									$src='/images/media-icon-google-map.png';

								}

								else if (strpos($media->media_url,'youtube') != false){

									$src='/images/media-icon-youtube.png';

								}

								else if (strpos($media->media_url,'flickr') != false){

									$src='/images/media-icon-flickr.png';

								}

								else if (strpos($media->media_url,'wordpress') != false){

									$src='/images/media-icon-wp-image.png';

								}

								else if (strpos($media->media_url,'uploads') != false){

									$src='/images/media-icon-wp-image.png';

								}

							$med_title = strlen($media->media_title) > 30 ? substr($media->media_title,0,30)."..." : $media->media_title;

							?>

								<div class="media-data <?php echo $cls;?>">

									<div>

										<img src="<?php echo PUBML_BASE_URL.$src;?>"   alt=""/>

										<h4><?php echo stripslashes($med_title); ?> </h4>

										<span style="float:right;"><a href="admin.php?page=book-media&book=<?php echo $book_slug;?>&mid=<?php echo  $media->media_id;?>"><img src="<?php echo PUBML_BASE_URL;?>/images/edit.png" class="tbl_icon"></a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="admin.php?page=book-media-library&book=<?php echo $book_slug;?>&mid=<?php echo  $media->media_id;?>"><img src="<?php echo PUBML_BASE_URL;?>/images/delete.png" class="tbl_icon"></a><a href="<?php echo $media->media_url; ?>" target="_blank" class="view-med-source"><img src="<?php echo PUBML_BASE_URL;?>/images/search.png" class="tbl_icon"></a></span>

										<input type="hidden" class="media-id-val" value="<?php echo $media->media_id; ?>"/>

									</div>

							   </div>

							   

					<?php $i++;

						}

					}

				?>

			<input id="book_assoc_id" type="hidden" name="term_id" value="<?php echo $book_id;?>">

			</div>

				<div class="med_btn_right">

					<a href="admin.php?page=book-media&book=<?php echo $Book->slug;?>" class="button button-primary button-large">Add New Media Source</a>

				</div>

			</div>

			<div class="right_content_container">

					<div class="media_group_text">

						<h1>Media Groups</h1>

						<b>Media Groups</b> containes one or more media sources. A media link in a &lt;PubML&gt;™ book can contain any combination of media sources (photos, maps, and/or videos). Select media sources on the left side. Then check any media groups you may wish to associate them with on the right and select the "Associated Media" button to add sources to a group. Add new, empty groups at the bottom right.

					</div>

			<?php 

			$mygroups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group WHERE {$wpdb->prefix}media_group.book_id ={$book_id} ORDER BY {$wpdb->prefix}media_group.group_slug ASC", OBJECT);

		

			?>

			<ul class="media-links">

			<?php if ($mygroups) { 

				$count=1;

			?>

				<?php foreach ( $mygroups as $group ) {

				if($count%2==0){$class='even';}

				else{$class='odd';}

				$related_groups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.book_id ={$book_id} AND  	{$wpdb->prefix}media_group_association.associate_groups ={$group->group_id} ", OBJECT);

				

				$test = "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.book_id ={$book_id} AND  	{$wpdb->prefix}media_group_association.associate_groups ={$group->group_id} ";

				

				$preview_class = "" ;				

				if (count($related_groups)) { 

					$preview_class = "preview " ;

				}

				

				$grp_title = strlen($group->group_title) > 52 ? substr($group->group_title,0,52)."..." : $group->group_title;

				?>

				<li class="<?php echo $class. ' '.$group->group_id; ?>"><span style="float:left;width:5%;"><input type="checkbox" class="med_id" value="<?php echo $group->group_id;?>" /></span><span class="medgrp_title"><?php echo stripslashes($grp_title).' ('.count($related_groups).')'; ?></span><span><span class="del_icon"><a href="javascript:void(0);" class="delete-group"><img src="<?php echo PUBML_BASE_URL;?>/images/delete.png" class="tbl_icon"></a></span><span class="view-media-group <?php echo $preview_class;?>"><a href="javascript:getMedia('<?php echo $group->group_slug ;?>');" class="view-groupdata"><img src="<?php echo PUBML_BASE_URL;?>/images/search.png" class="tbl_icon"></a></span></span></li>

				<?php 

				$count++;

				} ?>

				</ul>

				<div style="float:right;margin-right:3%;"><a class="button button-primary button-large media-assoc" href="javascript:void(0);">Associate Media</a></div>

			<?php }  else{ ?>

				<li><strong>No groups added yet.</strong></li></ul>

			<?php }?>

			<div class="media_group_container">

					<span class="success-text" style="display:none;"></span>

					<form action="" method="POST" id="media_group_form" class="new_media_group">

						<div class="url_media">Media Group Title</div>

						<div class="media_url_field">  

							<input type="text" value="<?php echo @$media_group_title ? $media_group_title : ''; ?>" maxlength="400" id="media_group_title" class="media_group_title " name="media_group_title" size="90" />

						</div>

					</form>

					<div class="med_btn_right">

						<a href="javascript:void(0);" class="button button-primary button-large" id="med_group_add">Add New Media Group</a>

					</div>	

			</div>

	</div>

	<!-- DIV TO ACCOMODATE MEDIA POP --->

	<div id="chromeContainer">

	<?php	

			$mapArray = "\n\n\n";

				$mapArray .= "//-----maps-----\n//https://maps.google.com/maps/ms?\n";

				$mapArray .= "var mapArray = new Array();\n";	

				

				$flickrSet = "\n\n\n";

				$flickrSet .= "//-----flickr set ids-----\n//http://www.flickr.com/photos/davebricker/sets/\n";

				$flickrSet .= "var flickrSet = new Array();\n";

				

				$movieArray = "\n\n\n";

				$movieArray .= "//-----youtube playlist ids-----\n //https://www.youtube.com/playlist?list=\n";

				$movieArray .= "var movieArray = new Array();\n";	

				

				$defaultMedia = "\n\n\n";

				$defaultMedia .= "//-----Wordpress images and other listings-----\n";

				$defaultMedia .= "var defaultMedia = new Array();\n";

				

				$titleArray = "\n\n\n";

				$titleArray .= "//-----window titles-----\n";

				$titleArray .= "var titleArray = new Array();\n";

					

			if ($mygroups) {			

				$count=1;

				foreach ( $mygroups as $group ) {

					

					$related_groups = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}media_group_association WHERE {$wpdb->prefix}media_group_association.book_id ={$book_id} AND  	{$wpdb->prefix}media_group_association.associate_groups ={$group->group_id} ", OBJECT);									

			

					if (count($related_groups)) { 

						foreach ( $related_groups as $media ) {

							$media_source = $wpdb->get_row("SELECT *  FROM {$wpdb->prefix}book_media WHERE media_id = {$media->media_id} and book_id = {$book_id}", ARRAY_A);

							

							$media_type = $media_source['media_type'];

							$media_url = $media_source['media_url'];

		

							switch ($media_type) {

								case 'map':

										$mapArray .= "mapArray[\"$group->group_slug\"] = \"$media_url\";\n" ;

										break;

								case 'youtube':

										$movieArray .= "movieArray[\"$group->group_slug\"] = \"$media_url\";\n";

										break;

								case 'flickr':

										$flickrSet .= "flickrSet[\"$group->group_slug\"] = \"$media_url\";\n";

										break;

								case 'wordpress':

										$defaultMedia .= "defaultMedia[\"$group->group_slug\"] = \"$media_url\";\n";

										break;	

								default:

										$defaultMedia .= "defaultMedia[\"$group->group_slug\"] = \"$media_url\";\n";

										

							}

						}								

					}					

					$titleArray .= "titleArray[\"$group->group_slug\"] = \"$group->group_title\";\n"	;					



				}		

			}

	?>

	</div>

	<!-- DIV TO ACCOMODATE MEDIA POP ---> 

</div>

<script>



<?php 

echo $mapArray; 

echo $flickrSet; 

echo $movieArray; 

echo $titleArray; 

echo $defaultMedia;

 

 ?>





</script>

<script>



jQuery(document).ready(function($) {

	jQuery(".media-data").live('click',function(){

		jQuery(".media-data").removeClass("media-check");

		jQuery(".media-links li").removeClass("media-links-check");

		jQuery(".media-links").find("input").removeAttr("checked");

		jQuery(this).toggleClass( "media-check");

		var mid = jQuery(this).find(".media-id-val").val();

		jQuery.ajax({

			url: ajaxurl,

			type: 'POST', 

			data: {

			'action':'pubml_media_associate_groups',

			'mid' : mid

			},

			dataType:'json',

			success:function(response) {

				console.log(response);

				var grps = jQuery.parseJSON(response.groups);

				for(var i=0;i<grps.length;i++){

					jQuery('.media-links input[type="checkbox"][value="'+grps[i]+'"]').attr('checked', 'checked');

				}				

			},

			error: function(errorThrown){

				console.log(errorThrown);

			}

		});

	});

	jQuery(".msg-text").fadeOut(5000);

	jQuery(".success-text").hide();

	jQuery('.media-assoc').live('click',function(event){

		event.preventDefault();

		var grp_length = jQuery(".media-links input:checkbox:checked").length;

		var med_length = jQuery('.media_source_listing').find('.media-check').length;

		if(med_length ==''){

				alert("Please select a media item to perform association operation.");

				return false;

		}

		if(grp_length ==''){

				var assoc_status ='de-assoc';

				alert("Do you really want to perform disassociation operation.");

		}

		else{

			var assoc_status ='assoc';

		}

					var searchIDs = [];

					jQuery(".media-links input:checkbox:checked").map(function(){

						searchIDs.push(jQuery(this).val());			

					});

					//return true;

					var book_assoc_id = jQuery('#book_assoc_id').val();

					var med_id = jQuery('.media-check .media-id-val').val();

					jQuery.ajax({

						url: ajaxurl,

						type: 'POST', 

						data: {

							'action':'pubml_media_associate',

							'sid' : searchIDs,

							'mid' : med_id,

							'bid' : book_assoc_id,

							'status' : assoc_status

						},

						dataType:'json',

						success:function(response) {

							jQuery('#mCSB_2 .mCSB_container').fadeOut("slow", function(){

								jQuery('#mCSB_2 .mCSB_container').html(response.data);

								jQuery('#mCSB_2 .mCSB_container').fadeIn("slow");

							});

							jQuery(".success-text").html(response.msg);

							jQuery(".success-text").show();

							jQuery(".success-text").fadeOut(5000);

							jQuery(".media-check").trigger("click");

						},

						error: function(errorThrown){

							console.log(errorThrown);

						}

					});

	  });

	  

	  jQuery(".media  .media_source_listing").mCustomScrollbar({

		verticalScroll:true,

		scrollButtons:{

          enable:true

        }

	});

	 jQuery(".media-links").mCustomScrollbar({

			verticalScroll:true,

			scrollButtons:{

			  enable:true

			}

	});

	

	jQuery("#med_group_add").live('click',function(){

		var grp_title = jQuery.trim(jQuery(".media_group_title").val());

		var bookid = jQuery('#book_assoc_id').val();

		

		if(jQuery.trim(grp_title).length ==0){

		   jQuery(".media_group_title").addClass('error'); // Check blank  or space title

		   jQuery(".media_group_title").val("");

		   return false;

		}		

		jQuery.ajax({

			url: ajaxurl,

			type: 'POST', 

			data: {

			'action':'pubml_media_manage_groups',

			'title' : grp_title,

			'bid' : bookid,

			'operation' : 'add'

			},

			dataType:'json',

			success:function(response) {

				console.log(response);

				jQuery('#mCSB_2 .mCSB_container').fadeOut("slow", function(){

				  jQuery('#mCSB_2 .mCSB_container').html(response.data);

				  jQuery('#mCSB_2 .mCSB_container').fadeIn("slow");

				});

				jQuery(".media_group_title").val("").removeClass('error');

				jQuery(".success-text").html(response.msg);

				jQuery(".success-text").show();

				jQuery(".success-text").fadeOut(7000);		

				if(response.status == 'error'){

					//jQuery(".media_group_title").css("border-color","red");

				}

			},

			error: function(errorThrown){

				console.log(errorThrown);

			}

		});

	});

	jQuery(".del_icon").live('click',function(){

		var grpid = jQuery(this).parent().parent().find(".med_id").val();

		var bookid = jQuery('#book_assoc_id').val();

		

		if (confirm("Are you sure, want to delete?")) {		

			jQuery.ajax({

				url: ajaxurl,

				type: 'POST', 

				data: {

				'action':'pubml_media_manage_groups',

				'gid' : grpid,

				'bid' : bookid,

				'operation' : 'delete'

				},

				dataType:'json',

				success:function(response) {

					console.log(response);

					jQuery('#mCSB_2 .mCSB_container').fadeOut("slow", function(){

					  jQuery('#mCSB_2 .mCSB_container').html(response.data);

					  jQuery('#mCSB_2 .mCSB_container').fadeIn("slow");

					});

					jQuery(".success-text").html(response.msg);

					jQuery(".success-text").show();

					jQuery(".success-text").fadeOut(5000);			

				},

				error: function(errorThrown){

					console.log(errorThrown);

				}

			});

		}

	});

	

	jQuery(".media-links li .medgrp_title").live('click',function(){

		jQuery(".media-data").removeClass("media-check");

		jQuery(".media-links li").removeClass("media-links-check");

		jQuery(".media-links").find("input").removeAttr("checked");

		jQuery(this).parent().toggleClass( "media-links-check");

		var groupid = jQuery(this).parent().find(".med_id").val();

		jQuery.ajax({

			url: ajaxurl,

			type: 'POST', 

			data: {

			'action':'pubml_media_associate_show',

			'gid' : groupid

			},

			dataType:'json',

			success:function(response) {

				console.log(response);

				var medias = jQuery.parseJSON(response.med);

				for(var i=0;i<medias.length;i++){

					jQuery('.media input[type="hidden"][value="'+medias[i]+'"]').parent().parent().addClass('media-check');

				}				

			},

			error: function(errorThrown){

				console.log(errorThrown);

			}

		});

	});

	

	jQuery('.media-filter-val').live("change", function(event) {

		        event.preventDefault();

			var bid = <?php echo $book_id; ?>;

			var slug = ' <?php echo $book_slug; ?>';

			var filters = [];

			 jQuery.each(jQuery('.media-filter-val:checked'), function() {

				filters.push(jQuery(this).val()); 

			    });

				jQuery.ajax({

					url: ajaxurl,

					type: 'POST', 

					data: {

						'action':'pubml_media_source_filter',

						'sid' : filters,

						'bid' : bid,

						'slug' : slug

					},

					dataType:'json',

					success:function(response) {

						console.log(response);

					jQuery('.media_source_listing #mCSB_1 .mCSB_container').fadeOut("slow", function(){

					jQuery('.media_source_listing #mCSB_1 .mCSB_container').html(response.data);

					jQuery('.media_source_listing #mCSB_1 .mCSB_container').fadeIn("slow");

					});

					},

					error: function(errorThrown){

						console.log(errorThrown);

					}

				});

				return true;

	  });

	

});

</script>