<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	

	*	Book Media File

	*	---------------------------------------------------------------------

	* 	@version	1.0

	* 	@author		SynapseIndia

	* 	@link		http://www.synapseindia.com

	*	---------------------------------------------------------------------

	*	This file is used to manage book media and media content.

	*	---------------------------------------------------------------------

	*/

?>

<?php

/**************************

	Media Tab

**************************/

$book_slug = @$_GET['book'];

$Book = get_term_by('slug', $book_slug, 'book');

$book_id=$Book->term_id;

global $wpdb;

if($_POST && !$_GET['mid']){



	$media_slug = sanitize_title($_POST['media_title']);			

	if (strpos($_POST['media_url'],'maps') != false){

		$mtype='map';

	}

	else if (strpos($_POST['media_url'],'youtube') != false){

		$mtype='youtube';

	}

	else if (strpos($_POST['media_url'],'flickr') != false){

		$mtype='flickr';

	}

	else if (strpos($_POST['media_url'],'wordpress') != false){

		$mtype='wordpress';

	}

	else if (strpos($_POST['media_url'],'uploads') != false){

		$mtype='wordpress';

	}

	$wpdb->insert(

			$wpdb->prefix.'book_media',

			array(

					'book_id' => $_POST['term_id'],

					'media_url' => $_POST['media_url'],

					'media_title' =>$_POST['media_title'],

					'media_slug' =>$media_slug,

					'media_type' => $mtype

				)

	);

  wp_redirect( admin_url('admin.php?page=book-media-library&book='.$book_slug));



}

else if($_POST && $_GET['mid']){



	$id = @$_GET['mid']; 

	$url = stripslashes_deep($_POST['media_url']);

	$title = stripslashes_deep($_POST['media_title']);

	$med_slug = sanitize_title($title);

	if (strpos($_POST['media_url'],'maps') != false){

		$mtype='map';

	}

	else if (strpos($_POST['media_url'],'youtube') != false){

		$mtype='youtube';

	}

	else if (strpos($_POST['media_url'],'flickr') != false){

		$mtype='flickr';

	}

	else if (strpos($_POST['media_url'],'wordpress') != false){

		$mtype='wordpress';

	}

	else if (strpos($_POST['media_url'],'uploads') != false){

		$mtype='wordpress';

	}

	

	$wpdb->update($wpdb->prefix.'book_media', array('media_id'=>$id, 'media_url'=>$url, 'media_title'=>$title,'media_slug'=>$med_slug,'media_type'=>$mtype), array('media_id'=>$id));

	wp_redirect( admin_url('admin.php?page=book-media-library&book='.$book_slug));

}

if(@$_GET['mid']){

$mid = @$_GET['mid'];

$myrows = $wpdb->get_results( "SELECT *	FROM {$wpdb->prefix}book_media WHERE {$wpdb->prefix}book_media.media_id={$mid} ORDER BY {$wpdb->prefix}book_media.media_id ASC", OBJECT);

if ($myrows) {

	foreach ( $myrows as $media ) {

		$media_url= $media->media_url;

		$media_title= $media->media_title;

	}

}

}

?>

<div id="book_meta">

<form action="" method="POST" id="new_book_media" class="new_book_media">

<input type="hidden" class="term_id" name="term_id" value="<?php echo $book_id;?>">



<!--<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/table_of_contents_icon_64x64.png" width="64" height="64"  alt=""/></div>-->

<!--<h2>Media</h2>-->



<!--TABS------------------------------>

<div class="primary_menu_bar">

	<?php fn_custom_tabs_main('My Books');?>

</div>

<div class="clear"></div>

<div class="secondary_menu_bar">

	<?php fn_custom_tabs_toc('Media');?>

</div>



	<div class="content_container" style="float:left;">

	      <h2 class="media-lib-icon">Add New Media for <i><?php echo $Book->name ;?></i>	 <span class="help openhelp" id="media_links" style="margin-left:10px"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span></h2>

		<div class="left_content_container">

				<span style="display:none;" class="msg-text"></span>

				<div class="url_media">Copy/Paste a link to a Google Map, a Flicker Gallery, a YouTube Playlist, or an image in your WordPress Media Library.</div>

				<div class="media_url_field">  

					<input style="width:90%;" type="text" value="<?php echo @$media_url ? $media_url : ''; ?>" maxlength="400" id="media_url" class="media_url" name="media_url" size="90" />

			   </div>

			   <div class="or_media">OR</div>

			   	<div class="media-inclusion">

					<div class="mtitle">Upload a new image to your media library for inclusion in a media window.</div>

					<div class="media_btn_right">

						<a class="button button-primary button-large" id="upload-media-link" href="#">WordPress Media Library</a>

					</div>

				</div>	

				<div class="media_title">Enter a title for this piece of media.</div>

				<div class="media_title_field">  

					<input style="width:90%;" type="text" value="<?php echo @$media_title ? $media_title : ''; ?>" maxlength="400" id="media_title" name="media_title" size="90" />

			   </div>  

			<div class="media_btn_right">

				<a id="save-insert-new" class="button button-primary button-large" href="javascript:void(0);">Save and Add New</a>

				<input  type="submit"  class="button button-primary button-large" value="Save and Return to Media Manager " />

				<a class="button button-primary button-large" href="admin.php?page=book-media-library&book=<?php echo $book_slug; ?>">Cancel</a>

			</div>	

		</div>

		<div class="right_content_container">

			<ul class="help-text">

				
			</ul>

		</div>

	</div>

</form>

</div>

<script type="text/javascript">

/* Validation controller */

jQuery(function(){

    // Initialise the validator

jQuery('#new_book_media').validate();

    // Add the rules to the classname hooks

	jQuery.validator.addClassRules({

		media_url: {

			 required: true

		}

	});

});



   // When the document is ready set up our sortable with it's inherant function(s)

  jQuery(document).ready(function($) {

		jQuery(".msg-text").fadeOut(7000);

		var custom_uploader;

		jQuery('#upload-media-link').click(function(e) {



				e.preventDefault();

				//If the uploader object has already been created, reopen the dialog

				if (custom_uploader) {

				custom_uploader.open();

				return;

				}



				//Extend the wp.media object

				custom_uploader = wp.media.frames.file_frame = wp.media({

				title: 'Choose Image',

				button: {

				text: 'Choose Image'

				},

				multiple: false

				});



				//When a file is selected, grab the URL and set it as the text field's value

				custom_uploader.on('select', function() {

				attachment = custom_uploader.state().get('selection').first().toJSON();

				jQuery('#media_url').val(attachment.url);

				});



				//Open the uploader dialog

				custom_uploader.open();

		});

		jQuery('.media-button-insert').click(function(e) {

		

				e.preventDefault();		

				alert(attachment);

		});

	jQuery(".msg-text").hide();

	jQuery("#save-insert-new").click(function(){

		var med_url = jQuery("#media_url").val();

		var med_title = jQuery("#media_title").val();

		var bid = jQuery(".term_id").val();

		if(med_url=='' || med_title==''){

			alert('Please enter media source information.');

		}

		else{

				jQuery.ajax({

					url: ajaxurl,

					type: 'POST', 

					data: {

					'action':'pubml_media_insert_new',

					'media_url' : med_url,

					'bid' : bid,

					'media_title' : med_title,

					},

					dataType:'json',

					success:function(response) {

						console.log(response);

						if(response.status=='true'){

							jQuery("#media_url").val("");

							jQuery("#media_title").val("");

							jQuery(".msg-text").html(response.msg);

							jQuery(".msg-text").show();

							jQuery(".msg-text").fadeOut(5000);	

						}

						

					},

					error: function(errorThrown){

						console.log(errorThrown);

					}

				});

		}

	});

		

});	



</script>

<?php

add_action('admin_enqueue_scripts', 'section_media_uploader_scripts');

?>