<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	*	Styles Page File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used for styles main page.
	*	---------------------------------------------------------------------
	*/
?>
<?php

/**************************

	Styles Tab

**************************/

$book_slug = @$_GET['book'];

$Book = get_term_by('slug', $book_slug, 'book');

$book_id=$Book->term_id;

$book_meta = get_option( "taxonomy_$book_id");

$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];

$edition_notes = ($book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';

global $wpdb;
	$query =  "SELECT * FROM {$wpdb->prefix}book_style WHERE {$wpdb->prefix}book_style.book_id ={$book_id} AND {$wpdb->prefix}book_style.type='all-data'";
	$myrows = $wpdb->get_results($query, OBJECT);
	$data = array();
	if(!empty($myrows)){
		foreach($myrows as $row){
			$data = unserialize($row->style_data);
		}
	}
	else{
		$data = PubML_default_style_data();
	}
	
	$pubml_fonts = get_option( 'pubml_fonts' );
	$_pubml_fonts = (empty( $pubml_fonts )) ? pubml_styles_default_fonts() : $pubml_fonts  ;
		
	if( !empty( $_pubml_fonts )){
		foreach($_pubml_fonts as $k => $v){				
			if( !$v['font_type']){
				echo stripslashes($v['link']);
			}
		}
	}
	
	
?>

<div id="book_meta">

<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/styles_icon_64x64.png" width="64" height="64"  alt=""/></div>



		<h2>Styles For <i><?php echo $Book->name;?><span style="font-size: 14px;font-style: normal;font-weight: bold;margin: 0;">&nbsp;(<?php echo $edition_notes ; ?>)</span></i></h2>
		<!--TABS------------------------------>
		<div class="primary_menu_bar">
		<?php fn_custom_tabs_main('My Books');?>
		</div>
		<div class="clear"></div>
		<div class="secondary_menu_bar">
		<?php fn_custom_tabs_toc('Styles');?>
		</div>

		<div class="content_container style-all" style="background:url('<?php echo (!empty($data)) ? $data['background']['back-img-val'] : PUBML_BASE_URL.'/images/wood_brazilianRW.jpg'; ?>');" >
		<form action="" method="POST" id="new_book_styles" class="new_book_styles">

			<input type="hidden" class="bid" name="book_id" id="cur_book_id" value="<?php echo $book_id;?>">

			<div id="wizard">
				  <!-- tabs -->
				  <ul class="tabs">
					<li><a href="#" class="w2">Background</a></li>
					<li><a href="#" class="w2">Layout</a></li>
					<li><a href="#" class="w2">Running Heads</a></li>
					<li><a href="#" class="w2">Text Styles</a></li>
					<li><a href="#" class="w2">Initial Caps</a></li>
                  <li><a href="#" class="w2">Text Ornaments</a></li>
					<li><a href="#" class="w2">Page Numbers</a></li>
				  </ul>		 

				<!-- panes -->

				<div class="panes" style="margin-top:5px;">
					<?php
						require("pubml_background.php");
						require("pubml_layouts.php");
						require("pubml_running-heads.php");
						require("pubml_style.php");
						require("pubml_styles-two.php");
						require("pubml_sep-ornaments.php");
						require("pubml_page-numbers.php");
					?>
				 </div>
			</div>
			<span style="display:none;background: none repeat scroll 0 0 #EEEEEE;border: 1px solid green;color: #000000;float: left;margin-left: 40%;padding: 8px;text-align: center;
    width: 30%;" class="success-form"></span><a href="javascript:void(0);" id="save-style-form" style="float:right;width:130px;margin-right:3%;clear:both;" class="button button-primary button-large">Save Information</a>
		</form>
	</div>
</div>
