<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	*	Book Export File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used for book export section.
	*	---------------------------------------------------------------------
	*/

$book_slug = @$_GET['book'];
$Book = get_term_by('slug', $book_slug, 'book');
$book_id=$Book->term_id;
$book_meta = get_option( "taxonomy_$book_id");
$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];
$edition_notes = ($book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';
$cover_metadata = ($book_meta['cover_meta']) ? stripslashes($book_meta['cover_meta']) : PUBML_BASE_URL."/images/placeholder.png";
?>
<div id="book_meta">
<!--TABS------------------------------>
<div class="primary_menu_bar">
	<?php fn_custom_tabs_main('My Books');?>
</div>
<div class="clear"></div>
<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/export_icon_64x64.png" width="64" height="64"  alt=""/></div>
<h2>Export Settings for <i><?php echo $Book->name;?><span style="font-size: 14px;font-style: normal;font-weight: bold;margin: 0;">&nbsp;(<?php echo $edition_notes ; ?>)</span></i><span class="help openhelp" id="export_ebooks">
			<img src="<?php echo PUBML_BASE_URL;?>/images/help.png" style="margin-left: 10px;vertical-align: middle;">
		</span></h2>
<div class="secondary_menu_bar">
	<?php fn_custom_tabs_toc('Export');?>
</div>


<div class="content_container" style="float:left;">
	<div class="settings_content">
		<div class="clear"></div>
		<div class="export_left_content">
			<div class="export_left_meta">
				<span style="float: left;height: 470px;margin-top: 12%;"><img class="taxonomy-image" src="<?php echo $cover_metadata; ?>" /></span>	
			</div>
		<div class="export_right_meta">
				<p>Metadata is exported with your eBook to aid in identification, sorting and searching-both in eReader device libraries and on the web.</p>
				<p><b>Title : </b><?php echo $Book->name;?></p>
				<p><b>Publisher : </b><?php echo $book_meta['publisher']; ?></p>
				<p><b>ISBN : </b><?php echo $book_meta['isbn']; ?></p>
				<p><b>Copyright : </b><?php echo $book_meta['copyright_info']; ?></p>
				<p><b>Subject 1  : </b><?php echo $book_meta['subject1code'].'/'.$book_meta['subject1desc']; ?></p>
				<p><b>Subject 2  : </b><?php echo $book_meta['subject2code'].'/'.$book_meta['subject2desc']; ?></p>
				<p><b>Subject 3  : </b><?php echo $book_meta['subject3code'].'/'.$book_meta['subject3desc']; ?></p>
				<p><b>Contributor 1 (Name,Role) : </b><?php echo $book_meta['contributor1last'].' , '.$book_meta['contributor1first'].' '.$book_meta['contributor1middle'].' , '.pubml_get_rolename($book_meta['contributor1role']); ?></p>
				<?php 
				if(!empty($book_meta['contributor2last']) && !empty($book_meta['contributor2first']) && !empty($book_meta['contributor2middle']) && !empty($book_meta['contributor2role']) ){
				?>
				
				<p><b>Contributor 2 (Name,Role) : </b><?php echo $book_meta['contributor2last'].' , '.$book_meta['contributor2first'].' '.$book_meta['contributor2middle'].' , '. pubml_get_rolename($book_meta['contributor2role']); ?></p>
				<?php } 
				if(!empty($book_meta['contributor3last']) && !empty($book_meta['contributor3first']) && !empty($book_meta['contributor3middle']) && !empty($book_meta['contributor3role']) ){
				?>	
				<p><b>Contributor 3 (Name,Role) : </b><?php echo $book_meta['contributor3last'].' , '.$book_meta['contributor3first'].' '.$book_meta['contributor3middle'].' , '.pubml_get_rolename($book_meta['contributor3role']); ?></p>
				<?php } ?>
				
				<p><b>This Book's website : </b><?php echo $book_meta['book_website']; ?></p>
				<p><b>Description</b><br/><?php echo stripslashes($Book->description); ?></p>
				<p><b>Description for Search engines</b><br/><?php echo stripslashes($book_meta['short_desc']); ?></p>
			</div>
			<a style="float:left;text-decoration: none;" href="admin.php?page=add-new-book&action=edit&taxonomy=book&tag_ID=<?php echo $Book->term_id; ?>&book=<?php echo $book_slug; ?>" class="license_button">Edit Metadata</a>
		</div>
		<div class="export_right_content">
			<div class="screen_icon">
				<img width="64" height="64" alt="" src="<?php echo PUBML_BASE_URL;?>/images/pubml_icon_64x64.png">
			</div>
			<h1>Export to &lt;PubML&gt;™</h1>
			<p>Export to the  &lt;PubML&gt;™ format to display your eBook in any current web browser or offer your book as a digital download.</p>
			<div class="clear"></div>
			<br/> 
			<p>Copy and paste the following shortcode to display this book on your website inside a Wordpress post or Page:</p>
			<p style="font-weight: bold;" id="pubmlShortcode">[PubML book="<?php echo $Book->slug;?>" showBadge="true"]</p>
            
			<div style="clear:both;">
			<input type="checkbox" name="showBadge" class="showBadge" id="showBadge" value="false" checked="checked" /> Show Badge
			<p style="font-size:12px; color:#900;">Places a tiny graphic in the lower right corner of your screen certifying that your eBook was created with a licensed copy of the &lt;PubML&gt;™ Tools.</p>
            <a style="float:right;text-decoration: none;" href="JavaScript:void(0);">
				<span id="<?php echo $Book->term_id;?>" showbadge="true" class="license_button download_PubML book-export">Download &lt;PubML&gt;™</span>
			</a>
			</div>
 
			<br/> <br/><br/>
			<hr class="clear" />
			<div class="clear"></div><br/> 
			<div class="screen_icon">
				<img width="64" height="88" alt="" src="<?php echo PUBML_BASE_URL;?>/images/ePub_logo_64x88.png">
			</div>
			<h1>Export to ePub</h1>
			<p>Export to ePub2 to submit your book to bookstores for viewing on eReader devices.</p>
			<p class="instructions"><strong>NOTE: </strong>Web fonts, video, maps, photo footnotes, and photo galleries are not exported with ePub eBooks. Create a version of your eBook with images added <em>directly</em> to your pages to include them in your exported eBook.</p>
			<br/>
			<a style="float:right;text-decoration: none;" href="JavaScript:void(0);"><span id="<?php echo $Book->term_id;?>" class="license_button download_ePub">Download ePub</span></a> 
			<br/> <br/><br/>	
			<div class="clear"></div>
		</div>
  </div>
<script>
  
jQuery(document).ready(function($) {
	$("span.book-export" ).click(function() {            
			var ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
			var bookId = jQuery(this).attr('id');
			var showBadge = jQuery(this).attr('showBadge');
			var loadimage = pubmlURL+'/images/loading-dots.gif';
			var downimage = pubmlURL+'/images/download-book.png';
			
			var parent = $(this).parent();
			parent.append('<img title="Loading..." alt="Loading..." src="'+loadimage+'">');
			$(this).remove();			
						
			//alert(bookId);
			jQuery.ajax ({
				type: 'POST',
				url: ajaxurl,
				data: {
					'action':'pubml_generate_book',
					'bookId' : bookId,
					'showBadge' : showBadge
				},
				dataType:'json',
				success: function(response) { 
					//alert(response.bookId);
					if(response.status== 'true'){
						parent.html('<img title="Download" alt="Download" src="'+downimage+'">');	
						parent.attr('href',response.bookpath)
					}else{
						$('#pluginAlertBox').bPopup({
							onOpen: function() { 							
									// alert(title); 
								jQuery('div#pluginAlertBox #pluginAlertBox-content').html(response.msg);		
								}, 
							// autoClose: 2000 							
						});
					}
					
				}
			});			
			
		return true;

	});
	
	$("span.download_ePub" ).click(function() {            
			var ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
			var bookId = jQuery(this).attr('id');			
			var loadimage = pubmlURL+'/images/loading-dots.gif';
			var downimage = pubmlURL+'/images/download-book.png';
			
			var parent = $(this).parent();
			parent.append('<img title="Loading..." alt="Loading..." src="'+loadimage+'">');
			$(this).remove();			
						
			//alert(bookId);
			jQuery.ajax ({
				type: 'POST',
				url: ajaxurl,
				data: {
					'action':'pubml_ePub_generate_book',
					'bookId' : bookId
				},
				dataType:'json',
				success: function(response) { 
					//alert(response.bookId);
					if(response.status== 'TRUE'){
						parent.html('<img title="Download" alt="Download" src="'+downimage+'">');	
						parent.attr('href',response.bookpath)
					}else{
						$('#pluginAlertBox').bPopup({
							onOpen: function() { 							
									// alert(title); 
								jQuery('div#pluginAlertBox #pluginAlertBox-content').html(response.msg);		
								}, 
							// autoClose: 2000 							
						});
					}	
				}
			});			
			
		return true;

	});

	$("span.downloadform_ePub" ).click(function() { 
		$("#depubform").submit();

    });
	
	
	// Check the showBadge TRUE or FALSE for the License badge img
	jQuery('#showBadge').attr('checked','checked');
	jQuery('#showBadge').click(function(){
		if(jQuery(this).prop('checked')){
			jQuery('span.book-export').attr('showBadge', 'true');	
			jQuery('p#pubmlShortcode').html('[PubML book="<?php echo $Book->slug;?>" showBadge="true"]');				
		}else{
			jQuery('span.book-export').attr('showBadge', 'false');
			jQuery('p#pubmlShortcode').html('[PubML book="<?php echo $Book->slug;?>" showBadge="false"]');
		}
	});
	
});
</script>
  </div>
</div>