<?php 
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	* PubML Fonts Section
	*
	* Add Web Fonts for the PubML books and also addeing the fallback fonts.
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used to manage book background data under styles section.
	*	---------------------------------------------------------------------
	*/

############## Saving the font meta options #################
if(isset($_POST['font_action'])){
	$action_type = $_POST['action_type'];
	$action_msg = '';
	if($action_type=='add'){ 
		// updating font options
		if((isset($_POST['pubml_font_link']))||(isset($_POST['pubml_font_family']))||(isset($_POST['fallback-font']))){

			$font_array = array(
				'link'		=>	@$_POST['pubml_font_link'],
				'family'	=>	@$_POST['pubml_font_family'],
				'fallback'	=>	@$_POST['fallback-font'],		
				'font_type'	=>	@$_POST['web-font-check'], 		// fallback_font -> 1, web_font -> 0 
				'font_delete'	=>'false',
			);
					
			$_fonts_array[] = $font_array;
			$_existing_fonts = get_option( 'pubml_fonts' );
			if(empty($_existing_fonts )){
				$_existing_fonts = pubml_styles_default_fonts();
			}
			 if (!in_array($font_array, $_existing_fonts)) {
				$font_array['font_delete'] = 'true';		
				array_push($_existing_fonts, $font_array);
				update_option('pubml_fonts', $_existing_fonts);
				$action_msg = '<div class="pubmlSuccess">A New Font has been added in Your Font Library. <a class="scrollDown">View</a></div>';	
			}
			else{
					$action_msg = '<div class="pubmlWarning">This Font is already exists in Your Library. <a class="scrollDown">View</a></div>';
				}
		}	
	}else if($action_type=='update'){
		
		// updating font options
		if((isset($_POST['pubml_font_link']))||(isset($_POST['pubml_font_family']))||(isset($_POST['fallback-font']))){
		
			//echo "<pre>"; print_r($_POST); echo "</pre>";		
			$font_array = array(
				'link'		=>	$_POST['pubml_font_link'],
				'family'	=>	$_POST['pubml_font_family'],
				'fallback'	=>	$_POST['fallback-font'],		
				'font_type'	=>	$_POST['web-font-check'], 		// fallback_font -> 1, web_font -> 0 	
				'font_delete' => 'true',
			);
					
			$font_id = $_POST['font_id'];
			$_pubml_fonts = get_option( 'pubml_fonts' );
			
			if(array_key_exists($font_id, $_pubml_fonts)){
				$_pubml_fonts[$font_id] = $font_array;
				update_option('pubml_fonts', $_pubml_fonts);	
				$action_msg = '<div class="pubmlSuccess">This font has been updated successfully. <a class="scrollDown"> View</a></div>';
			}			
		}	
		
	}	
}

?>
	
<style>
.font_inner_section {
    margin: 0px !important;
}
table.odd_evenCSS{

}
table.odd_evenCSS tr.even, table.odd_evenCSS tr.even input{
	background-color:#DFDFDF;
    border: medium none;
    box-shadow: none;
	padding:0px 2px 0 2px;;
}

table.odd_evenCSS tr, table.odd_evenCSS tr input{
	background-color:#F4F4F4;
    border: medium none;
    box-shadow: none;
	padding-left:0px;
}

table.odd_evenCSS tr td:first-child{
	padding: 0 0 0 10px;
}
select.error {
    background: none repeat scroll 0 0 #FFD2D2;
    border: 1px solid #FF0000;
}
</style>	

	
<div id="book_meta">
<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/font_settings_icon_64x64.png" width="64" height="64"  alt=""/></div>
<h2>Fonts <span class="help openhelp" id="top_level_settings_fonts"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span></h2>
<!--TABS------------------------------>
<?php fn_custom_tabs_main('Fonts');?>
	<div class="content_container">	
	
	<div id="message"><?php echo @$action_msg;?></div>
	<div class="clear"></div>
	
		<div class=" media" style="float:left;margin: 0 20px; width: 96%;">
			<h3>Add a Font</h3>
			<p>Add web fonts here. You'll use  them later to create and modify  paragraph styles for  individual books.<br/><span style="padding: 0px;" class="instructions"><strong>NOTE: </strong>Web fonts don't work without an Internet connection. Be sure to specify a fallback font as a "second choice.&quot;</span></p>
			
			<div class="clear"></div>
			<form class="validate add_new_font" action="" method="POST" id="frm_add_new_font" >
            <input id="fontationType" type="hidden" name="action_type" value="add">
            <input type="hidden" name="font_action" value="true">
            <input id="fontupdateID" type="hidden" name="font_id" value="">
			<div class="left_content_container">
				<p>Preview and choose free Google Web Fonts at <a href="http://www.google.com/fonts" target="_blank">http://www.google.com/fonts </a></p>
				<div class="font_inner_section" style="background-color: #F4F4F4;">
					<div class="font_by_link">
						<div class="fontsection clear">
							<label><strong>Enter the <?php echo htmlentities('<link>');?> code provided by Google Fonts</strong></label>
							<input id="fontsectionLink" type="text" name="pubml_font_link" class="font_textbox required" value="">
						</div>
						<div class="clear"></div>
						<div class="fontsection clear">
							<label><strong>Enter the @font-family tag provided by Google Fonts</strong></label>
							<input id="fontsectionImport" type="text" name="pubml_font_family" class="font_textbox required" value="">
						</div>		
						<div class="clear"></div>
						<div class="fontsection">   <br/>                   
							<span style="color:#cccccc;font-size:12px"><input type="checkbox" id="onlyFallbackFont" name="web-font-check" value="1" /> <b style="color:#474747" >Don't Use a Web Font</b><br>
							Check this box to add a fallback font  directly your Font library.</span>
						</div>		
					</div>
				</div>	
				
			</div>
			<div class="right_content_container">
				<h3 style="margin-top: 0;">Choose a Fallback Font</h3>
				
				<select id="fallbackSelect" name="fallback-font" class="required" size="16" style="width: 200px;height: 232px;">
				  <optgroup label="SERIF FONTS">
					<option value="Georgia, serif" style="font-family:Georgia;" >Georgia</option>
					<option value="'Palatino Linotype', 'Book Antiqua', Palatino, serif" style="font-family:Palatino;">Palatino</option>
					<option value="'Times New Roman', Times, serif" style="font-family:Times New Roman;">Times New Roman</option>
				  </optgroup>
				  <optgroup label="SANS-SERIF FONTS">
					<option value="Arial, Helvetica, sans-serif" style="font-family:Arial;">Arial</option>
					<option value="'Arial Black', Gadget, sans-serif" style="font-family:Arial Black;">Arial Black</option>					
					<option value="'Comic Sans MS', cursive, sans-serif" style="font-family:Comic Sans;">Comic Sans</option>					
					<option value="Impact, Charcoal, sans-serif" style="font-family:Impact;">Impact</option>					
					<option value="'Lucida Sans Unicode', 'Lucida Grande', sans-serif" style="font-family:Lucida Sans;">Lucida Sans</option>					
					<option value="Tahoma, Geneva, sans-serif" style="font-family:Tahoma;">Tahoma</option>					
					<option value="'Trebuchet MS', Helvetica, sans-serif" style="font-family:Trebuchet;">Trebuchet</option>					
					<option value="Verdana, Geneva, sans-serif" style="font-family:Verdana;">Verdana</option>					
				  </optgroup>
				  <optgroup label="MONOSPACED FONTS">
					<option value="'Courier New', Courier, monospace" style="font-family:Courier;">Courier</option>
					<option value="'Lucida Console', Monaco, monospace" style="font-family:Lucida Console;">Lucida Console</option>
				  </optgroup>
				</select>
			</div>
			<div class="clear"></div><br/>			
				<div class="font_inner_section" style="margin-top: 30px;clear:both;">
					<p>Click "Add Font" to add your selected typeface to the  &lt;PubML&gt;™ Font Menu
						<input type="submit" class="font-button" name="font_button" style="margin-left: 40px;" value="Add Font">
					</p>
				</div>					
			</form>	
			<hr class="clear"/>
			<div style="padding: 0px;" class="instructions"><strong>NOTE: </strong>Each  &lt;PubML&gt;™ book allows you to incorporate some or all of your selected typefaces into its own set of custom styles. This is accomplished in the style editor when setting up a new book.</div>
			<br/>
			<div id="fallbackAndListing" class="font_inner_section" >		
				<?php 
				// echo $fonts_select = pubml_fonts_dropdown('text-font-menu');
				// $new_url = sanitize_title('<i>Zebra Dun</i>');
				// echo $new_url;				
				?>
			
				<h3>My Font Library</h3>
				<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fonts_libray odd_evenCSS">	

					<?php			
						$pubml_fonts = get_option( 'pubml_fonts' );
						if(empty( $pubml_fonts )){
							$_pubml_fonts = pubml_styles_default_fonts();
						}
						else{
							$_pubml_fonts = $pubml_fonts ;
						}
						if( !empty( $_pubml_fonts )){				
							
							foreach($_pubml_fonts as $k => $v){
								// echo "Link :".stripslashes(htmlentities($v['link']))."<br/>";
								// echo "Font family :".stripslashes(htmlentities($v['family']))."<br/>";
								// echo "Fallback :".stripslashes(htmlentities($v['fallback']))."<br/>";
								
								// if ( !$v['font_type'] ){									
									// preg_match("/(font-family:)(.*)\;/", stripslashes(htmlentities($v['family'])), $font_family);
									// echo "Font family :".$font_family[2].stripslashes(htmlentities($v['fallback'])) ."</br>";
								// }
								
								// $font_name = ($v['font_type']) ? stripslashes(htmlentities($v['fallback'])) : $font_matches[1];
								// $font_family = ($v['font_type']) ? 'font-family:'.stripslashes(htmlentities($v['fallback'])).';' : stripslashes(htmlentities($v['family'])) ;
								
								
								$font_family_pattern = '/font-family: \'(.*)\',/i';
								$result = preg_match( $font_family_pattern, stripslashes(htmlentities($v['family'])) , $font_matches );	
								$font_name = ($v['font_type']) ? stripslashes(htmlentities($v['fallback'])) : $font_matches[1];
								$font_family = ($v['font_type']) ? 'font-family:'.stripslashes(htmlentities($v['fallback'])).';' : stripslashes(htmlentities($v['family'])) ;
								
								
								$google_preview = ($v['font_type']) ? '<img src="'.PUBML_BASE_URL.'/images/google_font_preview.png" style="opacity: 0.25;" class="tbl_icon">' : '<a href="http://www.google.com/fonts/specimen/'.$font_matches[1].'" id="fontPreview-'.$k.'" class="fontPreview"><img src="'.PUBML_BASE_URL.'/images/google_font_preview.png" class="tbl_icon"></a>' ; 
						
								$del_fonts =  ($v['font_delete'] == 'false') ? '<img style="opacity: 0.25;" src="'.PUBML_BASE_URL.'/images/delete.png" class="tbl_icon">' : '<a href="#" class="fontDelete" id="'.$k.'"><img src="'.PUBML_BASE_URL.'/images/delete.png" class="tbl_icon"></a>';
								
								$edit_fonts =  ($v['font_delete'] == 'false') ? '<img style="opacity: 0.25;" src="'.PUBML_BASE_URL.'/images/edit.png" class="tbl_icon">' : '<a href="#" id="'.$k.'" class="fontEdit"><img src="'.PUBML_BASE_URL.'/images/edit.png" class="tbl_icon"></a>';
								
								echo '<tr id="fontRow-'.$k.'"><td>'.stripslashes($v['link']).'<span style="font-size:21px;line-height: 26px;'.$font_family.'">'.$font_name.'</span><p style="margin:6px 0;" ><input type="text" value="AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz 0123456789" style="width:97%;font-size:15px;'.$font_family.'"/></p></td> <td width="4%">'.$google_preview.'</td> <td width="4%">'.$edit_fonts.'</td> <td width="4%">'.$del_fonts.'</td></tr>';
							} 
						
						}else{
							echo '<tr><td colspan="4"><h3>No Font Added.</h3></td></tr>';
						}
						
						?>
				</table>				
			</div>			
						
			<div class="clear"></div>	
		</div>
		<div class="clear"></div>
	</div> <!-- content_container -->
	<div class="clear"></div>
</div>	<!-- #book_meta -->
	
   
        

<div class="clear"></div>
	
<script>
    jQuery(function(){
        // Initialise the validator
    	jQuery('#frm_add_new_font').validate({ignore: ".ignore"});
		jQuery('table.odd_evenCSS tr:even, table.odd_evenCSS tr:even input').addClass('even');
    
        // Add the rules to the classname hooks
    	jQuery.validator.addClassRules({			
    		fontsectionLink: {
    			 required: true
    		},
    		fontsectionImport: {
    			required: true
    		},
			fallbackSelect: {
    			required: true
    		}
    	});
		
		jQuery("#onlyFallbackFont").change(function() {
			if(jQuery(this).is(':checked')) {
				jQuery("#fontsectionLink, #fontsectionImport").addClass('ignore'); 
				jQuery("#fontsectionLink, #fontsectionImport").removeClass('error'); 
			}else  {
				jQuery("#fontsectionLink, #fontsectionImport").removeClass('ignore'); 
			}			
		});
    	
    	jQuery('.fontPreview').click(function() {
    		var target = jQuery(this).attr('href');
    		//alert(target);
    		window.open(target, 'fontwindow', 'location=no,status=1,scrollbars=1,width=680,height=625');
    		//tb_show('Font Preview', target+'TB_iframe=1');
    		return false;
    	}); 
    	
    	jQuery('.fontDelete').click(function() {						
            if (confirm("Are you sure, want to delete?")) {
    			var ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
    			var targetId = jQuery(this).attr('id');
    			//alert(targetId);
    			var data = 'action=pubml_webfont_delete&targetId='+targetId;
    			jQuery.ajax ({
    				type: 'POST',
    				url: ajaxurl,
    				data: data,
    				dataType:'json',
    				success: function(response) { 
    					//alert(response.msg);
    					if(response.status){
    						jQuery("tr#fontRow-"+targetId).hide('slow');
    						jQuery("tr#fontRow-"+targetId).remove();							
    					}	
					jQuery('table.odd_evenCSS tr, table.odd_evenCSS tr input').removeClass('even');						
					jQuery('table.odd_evenCSS tr:even, table.odd_evenCSS tr:even input').addClass('even');		
    				}
    			});				
            } 		
    		return false;
    	});
		
		jQuery('.fontEdit').click(function() {						
            	var ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
    			var targetId = jQuery(this).attr('id');
				jQuery('input#fontupdateID').val(targetId);
				jQuery('input#fontationType').val('update');
				jQuery("input[name='font_button']").val('Update Font');
				
				//alert(targetId)	;
				jQuery.ajax ({
    				type: 'POST',
    				url: ajaxurl,
    				data: {
    					'action':'pubml_webfont_fallback_association',
    					'targetId' : targetId
    				},
    				dataType:'json',
    				success: function(response) { 
    					//alert(response.status);		
						
    					jQuery('input#fontsectionLink').val(response.link);
    					jQuery('input#fontsectionImport').val(response.family); 
						jQuery('select#fallbackSelect option[value="'+response.fallback+'"]').attr('selected', 'selected');	
											
						if(response.font_type == 1) {
							jQuery("#fontsectionLink, #fontsectionImport").addClass('ignore'); 
							jQuery("#fontsectionLink, #fontsectionImport").removeClass('error'); 
							jQuery('input#onlyFallbackFont').attr('checked', true);
						}else  {
							jQuery("#fontsectionLink, #fontsectionImport").removeClass('ignore'); 
							jQuery('input#onlyFallbackFont').attr('checked', false);
						}
									
    					//jQuery('select#fallbackSelect').val(response.family);    					
    					if(response.status){
    						jQuery('html, body').animate({scrollTop:jQuery("h2.nav-tab-wrapper").offset().top},750);	
    					}					
    				}
    			});	

    		return false;
    	});
    	
    	jQuery('table.fonts_libray input[type="radio"]').click(function() {						
            
    			var ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
    			var targetId = jQuery(this).val();
    			jQuery('table.fallback_fonts input[name=fallback-font]').attr('checked',false);
				jQuery('table.fonts_libray').css('border','none');
    			
    			//alert(targetId);
    			jQuery.ajax ({
    				type: 'POST',
    				url: ajaxurl,
    				data: {
    					'action':'pubml_webfont_fallback_association',
    					'targetId' : targetId
    				},
    				dataType:'json',
    				success: function(response) { 
    					//alert(response.data);					
    					// jQuery('input#fontsectionLink').val(response.link);
    					// jQuery('input#fontsectionImport').val(response.family);
    					jQuery('table.fallback_fonts input[type="radio"][value="'+response.fallback+'"]').attr('checked', 'checked');
    					// if(response.status){
    						// jQuery("tr#fontRow-"+targetId).hide('slow');
    					// }					
    				}
    			});			
    			
    		return true;		
    	});
		
		
		jQuery('#associateFallbackFont').click(function() {
    		var source_webfont = jQuery('table.fonts_libray input[name=web-font]:checked').val();
    		var target_fallback = jQuery('table.fallback_fonts input[name=fallback-font]:checked').val();
			var ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
						
			if (typeof source_webfont !== "undefined"){
				if(typeof target_fallback !== "undefined") {
					//alert(source_webfont +" - > "+target_fallback); 
					jQuery('div.font_inner_section span.spinner').show();
					jQuery.ajax ({
						type: 'POST',
						url: ajaxurl,
						data: {
							'action':'fallback_association',
							'source_webfont' : source_webfont,
							'target_fallback' : target_fallback
						},
						dataType:'json',
						success: function(response) { 
							//alert(response.msg);					
									
							// if(response.status){
								// jQuery("tr#fontRow-"+targetId).hide('slow');
							// }
							jQuery('div.font_inner_section span.spinner').hide();		
						}
					});						
					
				} else
					jQuery('table.fallback_fonts').css('border','1px solid #FF0000');
			}else 
				jQuery('table.fonts_libray').css('border','1px solid #FF0000');			
    		return false;
    	}); 

		jQuery('table.fallback_fonts input[type="radio"]').click(function() {						
			jQuery('table.fallback_fonts').css('border','1px solid #FFF');
		});		
		
		
		jQuery('a.scrollDown').click(function() {						
			jQuery('html, body').animate({scrollTop:jQuery("#fallbackAndListing").offset().top},500);
		});		
		
    	
    });
    
</script>

