<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/**
 * PubML My Books Library Section
 *
 * My Books Library Section of PubML books and also adding the new book here.
 *
 * @author 		SynapseIndia
 * @category 	Core
 * @package 	PubML/includes/AJAX
 * @version     0.0.1
 */	
?>
<div id="book_meta">
<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/my_books_icon_64x64.png" width="64" height="64"  alt=""/></div>
<h2><?php echo "My Books";?><span class="help openhelp" id="edit_book_add_content" style="margin-left:10px"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span></h2>

<!--TABS------------------------------>
<?php fn_custom_tabs_main('My Books');?>
<div class="content_container">

	<div class="top_btn_right">
		<a href="admin.php?page=add-new-book" class="button button-primary button-large">New Book</a>
	</div>
	<table class="pub_tbl" cellpadding="0" cellspacing="0">
		<div class="tbl_th">
			<tr>
				<th width="5%">&nbsp;</th>
				<th width="43%">Title</th>
				<th width="15%">Edition Notes</th>
				<th width="15%">Author</th>
				<th width="15%">Last Modified</th>	
				<th width="7%">Preview</th>					
			</tr>
		</div>

		<!-- Getting the list of books -->
		<?php
				$args = array(
					'type'                     => 'post',
					'orderby'                  => 'name',
					'order'                    => 'ASC',
					'hide_empty'               => 0,
					'hierarchical'             => 1,
					'taxonomy'                 => 'book',
					'pad_counts'               => false 

				); 

				$bookArray = get_categories( $args );
				foreach($bookArray as $book){
					$book_meta = get_option( "taxonomy_$book->term_id");

					$book_author = $book_meta['contributor1last']." ".$book_meta['contributor1first']." ".$book_meta['contributor1middle'];
					$edition_notes = ($book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';
					$cover_metadata = ($book_meta['cover_meta']) ? stripslashes($book_meta['cover_meta']) : PUBML_BASE_URL."/images/placeholder.png";
		?>

		<tr id="book_row<?php echo $book->term_id;?>">
			<td><img width="37" height="50" src="<?php echo $cover_metadata; ?>"/></td>
			<td class="name column-name"><a href="admin.php?page=book-sections&book=<?php echo $book->slug;?>"><span class="book_name"><strong><i><?php echo $book->name;?> </strong></i></span></a>
				<div class="row-actionss" style="clear: both;">
					<span class="edit"><a href="admin.php?page=book-sections&book=<?php echo $book->slug;?>">Edit Book</a> | </span>
					<span class="edit-metadata"><a href="admin.php?page=add-new-book&action=edit&taxonomy=book&tag_ID=<?php echo $book->term_id;?>&book=<?php echo $book->slug;?>">Edit Metadata</a> | </span>
					<span class="duplicate">
						<a href="JavaScript:void(0);" id="<?php echo $book->term_id;?>" class="duplicate-tag">Duplicate</a> | </span>
					<span class="delete"><a href="JavaScript:void(0);" id="<?php echo $book->term_id;?>" class="delete-tag">Delete</a> | </span>
					<span class="edit-style"><a href="admin.php?page=pubml-book-export&book=<?php echo $book->slug;?>">Export</a></span> <br/>
					<span class="edit-style"><a href="admin.php?page=book-styles&book=<?php echo $book->slug;?>">Edit Styles</a> | </span>
					<span class="edit-style"><a href="admin.php?page=book-media-library&book=<?php echo $book->slug;?>">Edit Media</a> | </span>
					<span class="edit-style"><a href="admin.php?page=book-footnotes&book=<?php echo $book->slug;?>">Edit Photo Notes</a> | </span>
					<span class="edit-style"><a href="admin.php?page=pubml-book-navigation&book=<?php echo $book->slug;?>">Edit Tabs</a></span>
				</div>
			</td>
			<td><?php echo $edition_notes; ?></td>
			<td><?php echo $book_author; ?></td>
			<td><?php 
				$book_modified_date    = strtotime($book_meta['book_modified_date']);
				$content_modified_date = strtotime(get_modify_date_by_term($book->term_id));
				//echo $book_modified_date." <> ".$content_modified_date;
				
				echo $modified_data = ($book_modified_date < $content_modified_date) ? date("M. d, Y",$content_modified_date) : date("M. d, Y",$book_modified_date) ;	
			
			?></td>
			<td>
				<a class="preview_PubML" id="<?php echo $book->term_id;?>" style="float:left;text-decoration: none;" href="JavaScript:void(0);"><img src="<?php echo PUBML_BASE_URL;?>/images/search.png" class="tbl_icon"></a>
			</td>
		</tr>
	<?php } ?>
	</table>
	</div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
	$(".delete-tag" ).click(function() {
	var tagid = $(this).attr('id');
	var data = {
		action: 'delete_term_book',
		term_id: tagid
	};

	if(confirm("Are you sure want to remove this book? If you remove the book, all sections of the book will be deleted.")){
			
			$("#book_row"+tagid).css('background-color','#FF0000');
			// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
			$.post(ajaxurl, data, function(response) {
					$("#book_row"+response.term_id).remove();

			}, "json");
	}
	});
	
	$(".duplicate-tag" ).click(function() {
		var tagid = $(this).attr('id');
		var data = {
			action: 'duplicate_pubml_ebook',
			term_id: tagid
		};
		if(confirm("Are you sure want to Duplicate this book?")){								
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				$.post(ajaxurl, data, function(response) {
					//alert(response.status)	//$("#book_row"+response.term_id).remove();
					if(response.status){
						location.href='admin.php?page=my-books';
					}	
				}, "json");
		}
	});
	
});

// jQuery(document).ready(function($) {
	// $("span.book-export" ).click(function() {            
			// var ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
			// var bookId = jQuery(this).attr('id');			
			// var loadimage = pubmlURL+'/images/loading-dots.gif';
			// var downimage = pubmlURL+'/images/download-book.png';
			
			// var parent = $(this).parent();
			// parent.append('<img src="'+loadimage+'">');
			// $(this).remove();			
						
			/*alert(bookId); */
			// jQuery.ajax ({
				// type: 'POST',
				// url: ajaxurl,
				// data: {
					// 'action':'pubml_generate_book',
					// 'bookId' : bookId
				// },
				// dataType:'json',
				// success: function(response) { 
					/*alert(response.bookId); */
					// if(response.status== 'true'){
						// parent.html('<img  width="80" height="22" src="'+downimage+'">');	
						// parent.attr('href',response.bookpath)
					// }
					/* parent.html('<img  width="80" height="22" src="'+downimage+'">');	*/
				// }
			// });			
			
		// return true;

	// });
// });
</script>