<?php
/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	

	*	New Footnote File

	*	---------------------------------------------------------------------

	* 	@version	1.0

	* 	@author		SynapseIndia

	* 	@link		http://www.synapseindia.com

	*	---------------------------------------------------------------------

	*	This file is used to add new footnote.

	*	---------------------------------------------------------------------

	*/

	

$book_slug = @$_GET['book'];

$Book = get_term_by('slug', $book_slug, 'book');

$action = @$_GET['action'];

$footnote_id = @$_GET['footnote'];





if($action=='edit') { 

	$act_type = 'edit'; 

	$footnote = get_post($footnote_id);

} else { 

	$act_type = 'add'; 

}

?>

<div id="book_meta">

<!--TABS------------------------------>

<div class="primary_menu_bar">

	<?php fn_custom_tabs_main('My Books');?>

</div>

<div class="clear"></div>

<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/photonotes_icon_64x64.png" width="64" height="64"  alt=""/></div>

<h2>New Footnote for <i><?php echo @$Book->name;?></i><span class="help openhelp" id="photo_footnotes" style="margin-left:10px"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span></h2>

<div class="secondary_menu_bar">

	<?php fn_custom_tabs_toc('New Footnote');?>

</div>



	<div class="content_container">

	<div class="top_btn_right" style="padding-bottom:0px;"><a href="admin.php?page=book-new-footnote&book=<?php echo @$Book->slug;?>" class="button-primary">New Footnote</a></div>

	<div id="message"></div>

	<div class="clear"></div>

		<form method="post" id="NewFootnote" action="">

			<div class="div_section_title">

				<input type="text" name="pubml_post_title" class="footnote_title" id="footnote_title" placeholder="Please enter footnote title here" value="<?php echo @$footnote->post_title;?>">

			</div>

			<div class="section_desc">

			<?php



					$footnote_content = @$footnote->post_content;
					$footnote_editor_id = 'pubml_post_content';

					wp_editor( $footnote_content, $footnote_editor_id );

			?>

			</div>



			<div class="footnote_image">

			<?php

					$custom_footnote_image = get_post_meta($footnote_id,'custom_footnote_image',true);

			?>



				<div class="section_main_image" style="width: 100%;">

					<div class="feature_img" style="width: 280px;">

					<div class="pubml_box_heading">Footnote Image</div>

						<div id='sec_img_div' style="border: 1px solid #CCCCCC; padding: 10px;">

							<?php if($custom_footnote_image) { ?><img src="<?php echo $custom_footnote_image;?>" class="custom_footnote_image">

							<?php } else { echo "<h1>Upload image for Footnote</h1>"; }?>

						</div>

						<div class="instructions">Images larger than 260x180px will be cropped.</div>

						<input type="hidden" name="custom_footnote_image" id="custom_footnote_image" value="<?php echo $custom_footnote_image;?>" />

					</div>

					<div class="clear"></div>

					<div class="sec_btns">

						<a class="button-primary button-large" data-editor="custom_footnote_image" id="upload_image_button" href="#">Upload/Add image</a>

						<a class="remove_img_btn button-primary button-large" id="remove_img_button" href="#">Remove Image</a>

					</div>

				</div>

			</div>



			<div class="section_buttons" style="margin-right: 20px; margin-top: -48px;text-align: right;">

				<input type="hidden" name="pubml_post_type" id="pubml_post_type" value="pubml_footnotes">

				<input type="hidden" name="pubml_post" value="<?php echo $footnote_id;?>">

				<input type="hidden" name="act_type" value="<?php echo $act_type;?>">

				<input type="submit" id="save_footnote" name="save_section" value="Save Footnote" class="button_sec button-primary button-large">

			</div>

		</form>

	</div>

</div>



<?php

########### Print sorting js in footer

function submit_section_form() { //javascript calling function above

global $post;

?>

<script type="text/javascript">

/* Validation controller */

jQuery(function(){

    // Initialise the validator

jQuery('#NewFootnote').validate();

    // Add the rules to the classname hooks

	jQuery.validator.addClassRules({

		footnote_title: {

			 required: true

		}

	});

});



  // When the document is ready set up our sortable with it's inherant function(s)

  jQuery(document).ready(function($) {



/* for sorting digital pages */

    jQuery("#NewFootnote").submit(function( event ) {

			tinyMCE.triggerSave();

	//validating title for empty values

		var footnote_title = jQuery.trim(jQuery('.footnote_title').val());

		if(footnote_title==''){ return false; }

		  var footnote_data = jQuery(this).serialize();

		  var data = 'action=CreateSection&'+footnote_data;

			jQuery.ajax ({

				type: 'POST',

				url: ajaxurl,

				data: data,

				dataType:'json',

				success: function(response) {    



					if(response.status == 200){

						jQuery('#message').addClass('success');

						jQuery('#message').html('Footnote Saved');

					}



					if(response.act_type=='add'){

						location.href='admin.php?page=book-new-footnote&footnote='+response.pubml_post_id+'&book='+response.book+'&action=edit';

					} else {

						location.reload(); 

					}

				}

			});



		// Stop form from submitting normally

		event.preventDefault();



    });



// Scripts for the media uploader

    var custom_uploader;

 

// Open wordpress media uploader



		$('#upload_image_button').click(function(e) {

	 

			e.preventDefault();

	 

			//If the uploader object has already been created, reopen the dialog

			if (custom_uploader) {

				custom_uploader.open();

				return;

			}

	 

			//Extend the wp.media object

			custom_uploader = wp.media.frames.file_frame = wp.media({

				title: 'Choose Image',

				button: {

					text: 'Choose Image'

				},

				multiple: false

			});

	 

	 

	 

    // custom_uploader = wp.media.frames.file_frame = wp.media({

        // title: 'Choose Image 1',

        // button: {

            // text: 'Choose Image 1'

        // },

        // multiple: true,



        // displaySettings: true,



        // displayUserSettings: false

    // });

	 

			//When a file is selected, grab the URL and set it as the text field's value

			custom_uploader.on('select', function() {

				attachment = custom_uploader.state().get('selection').first().toJSON();

				$('#custom_footnote_image').val(attachment.url);

				$('#sec_img_div').html("<img src='"+attachment.url+"' class='custom_footnote_image' width='260' height='180'>");

			});

	 

			//Open the uploader dialog

			custom_uploader.open();

	 

		});



	// Remove image

		$('#remove_img_button').click(function(e) {

			jQuery('#sec_img_div').html('<h1>Featured Image</h1>');

			jQuery('#custom_footnote_image').val('');



		});

});



</script>

<?php

}

add_action('admin_print_footer_scripts', 'submit_section_form'); //Sorting script

add_action('admin_enqueue_scripts', 'section_media_uploader_scripts');

?>