<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	*	New Book File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used to create new book.
	*	---------------------------------------------------------------------
	*/

############## Saving the book meta data #################

if(isset($_POST['book'])){

$action_type = $_POST['action_type'];

if($action_type=='edit'){ 

// updating book term

	$t_id = $_POST['term_id'];

	wp_update_term($t_id, 'book', array(

	  'name' => $_POST['book_name'],

	  'description' => htmlspecialchars(addslashes($_POST['description']))

	));

} else {



// adding book term

	$terms = wp_insert_term(

	  $_POST['book_name'], // the term 

	  'book', // the taxonomy

	  array(

		'description'=> htmlspecialchars(addslashes($_POST['description']))

	  )

	); 

$t_id = $terms['term_id'];

}


$term_meta = get_option( "taxonomy_$t_id");

$cat_keys = array_keys($_POST['book']);



	foreach ($cat_keys as $key){


	if (isset($_POST['book'][$key])){

		if($key=='short_desc'){
			$_POST['book'][$key] = htmlspecialchars($_POST['book'][$key], ENT_QUOTES);
		}

		$term_meta[$key] = $_POST['book'][$key];

	}

}

//save the option array	


update_option( "taxonomy_$t_id", $term_meta );

wp_redirect( admin_url('admin.php?page=my-books') );

}



################### update book metadata #######################

if(@$_GET['action']=='edit'){

	$t_id = @$_GET['tag_ID'];

	$Book = get_term_by('id', $t_id, 'book');

	$book_meta = get_option( "taxonomy_$t_id");

	$action_type = "edit";

	$page_title = "Edit Book";

	$Bookname = " - ".$Book->name;

	$book_tab_action_url = "admin.php?page=add-new-book&action=edit&taxonomy=book&tag_ID=".$t_id;

} else {

	$action_type = "add";

	$page_title = "New Book";

	$book_tab_action_url = "admin.php?page=add-new-book";

}

// echo "<pre>";

	// print_r($book_meta);

// echo "</pre>";

$edition_notes = (@$book_meta['edition_notes']) ? $book_meta['edition_notes'] : '&nbsp;';

?>

<div id="book_meta">

<!--TABS------------------------------>
<div class="primary_menu_bar">
	<?php fn_custom_tabs_main('My Books');?>
</div>
<div class="clear"></div>
<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/new_book_icon_64x64.png" width="64" height="64"  alt=""/></div>
<h2><?php echo @$page_title; if(@$Bookname){ echo $Bookname;}?><span style="font-size: 14px;font-style: normal;font-weight: bold;margin: 0;">&nbsp;(<?php echo $edition_notes ; ?>)</span></i><span class="help openhelp" id="edit_metadata">
			<img src="<?php echo PUBML_BASE_URL;?>/images/help.png" style="margin-left: 10px;vertical-align: middle;">
		</span></h2>
<div class="secondary_menu_bar">
	<?php fn_custom_tabs_toc('Book Info');?>
</div>


<form class="validate" action="" method="POST" id="new_book_creation" class="new_book_creation">

<input type="hidden" name="action_type" value="<?php echo $action_type;?>">

<input type="hidden" name="term_id" value="<?php echo $t_id;?>">

<div class="content_container">



		<!--PUBLISHER------------------------------>

		<div class="book_meta_group">

			<div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">Publisher:</div>

		   <div class="book_meta_field"><input name="book[publisher]" type="text" maxlength="400" size="40" id="book[publisher]" aria-required="true" class="formInputSmall" value="<?php echo @$book_meta['publisher'] ? $book_meta['publisher'] : ''; ?>" /></div>

		</div>

		<div class="book_meta_field_description">Enter your own name if you are a self-publisher. Enter the name of your publishing company if you have one.</div>

		

		<!--ISBN------------------------------>

	  <div class="book_meta_group">

			<div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">ISBN:</div>

		   <div class="book_meta_field"><input name="book[isbn]" type="text" maxlength="17" size="20" id="book[isbn]" class="formInputSmall" value="<?php echo @$book_meta['isbn'] ? $book_meta['isbn'] : ''; ?>" /></div>

		</div>

		<div class="book_meta_field_description">A unique International Standard Book Number is "suggested" for each individual edition of a book (by the people who sell them). Webbooks and eBooks uploaded to Amazon.com are not required to have an ISBN number. Publishers uploading ePub files to Google Books can request an ISBN assignment for free. You can elect to purchase an ISBN number to make your book searchable in the International Book database. They are free in many countries but costly in the United States. U.S. publishers can purchase ISBN numbers <a href="https://www.myidentifiers.com/isbn/main" target="_blank">here</a>.</div>

    

		<!--TITLE------------------------------>

		<div class="book_meta_group">

			<div class="field_required">*</div>

			<div class="book_meta_field_label">Title:</div>

		   <div class="book_meta_field">

		   

		   

		   <input size="40" id="book_title" class="book_title" name="book_name" type="text" maxlength="400" value="<?php echo @$Book->name; ?>" class="formInputSmall" /></div>

		</div>

		<div class="book_meta_field_description">What is the title of your book?</div>

		

		<!-- COPYRIGHT YEAR ---------------------------- -->

		<div class="book_meta_group">
			<div class="field_required">&nbsp;</div>
			<div class="book_meta_field_label">Copyright:</div>
			<div class="book_meta_field"> 	   
			<input size="40" id="copyright_info" class="copyright_info" name="book[copyright_info]" type="text" maxlength="400" value="<?php echo @$book_meta['copyright_info'] ? stripslashes($book_meta['copyright_info']) : ''; ?>" class="formInputSmall" /></div>

		</div>
		<div class="book_meta_field_description">Copyright notice for your book. (use "&amp;copy;" for the copyright symbol).</div>
		
	<!-- Edition Notes ---------------------------- -->

		<div class="book_meta_group">
			<div class="field_required">&nbsp;</div>
			<div class="book_meta_field_label">Edition Notes:</div>
			<div class="book_meta_field"> 
			<input size="40" id="edition_notes" class="edition_notes" name="book[edition_notes]" type="text" maxlength="400" value="<?php echo @$book_meta['edition_notes'] ? stripslashes($book_meta['edition_notes']) : ''; ?>" class="formInputSmall" /></div>
		</div>
		<div class="book_meta_field_description">Edition notes for your book. (Version number, etc.)</div>	

	  <!--LANGUAGE------------------------------>

		<div class="book_meta_group">

		  <div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">Language:</div>

		   <div class="book_meta_field">

				<select name="book[language]" id="term_meta_language" class="formInputSmall">

					<?php  

						$selected_lang = @$book_meta['language'] ? $book_meta['language'] : 'en';

						echo @$langoptions = language_selector("$selected_lang");

					?>

				</select>

			</div>

		</div>

			<script type="text/javascript">

				jQuery(document).ready(function($) {

				 	//jQuery('select#term_meta_language option[value="<?php echo $book_meta['language'] ? $book_meta['language'] : ''; ?>"]').attr('selected', 'selected');			

				});

			</script>

	  <div class="book_meta_field_description">What language is your book written in?</div>

	  

		<!--SUBJECTS------------------------------>

		<div class="book_meta_group">

		  <div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">Subjects:</div>

		  <div class="book_meta_field_description_right"><a href="http://www.bisg.org/" target="_blank">The Book Industry Study Group</a> has developed a publishing industry standard classification system for book topics, subjects, and genres. Use the "Find Subjects" links to look up the subject codes and then enter up to three that describe your book.</div>

	  </div> 

	  <div class="book_meta_group">

	  <div class="subject_code">Subject Code</div>

	  <div class="subject_desc">Subject Description</div>

	  </div>      

	  <!--SUBJECT 1------------------------------>

	  <div class="book_meta_group">

			<div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">Subject 1:</div>

		   <div class="book_meta_field"><input name="book[subject1code]" value="<?php echo @$book_meta['subject1code'] ? $book_meta['subject1code'] : ''; ?>" type="text" maxlength="400" size="10" id="book[subject1code]" class="formInputSmall" />&nbsp; <input name="book[subject1desc]" type="text" maxlength="400" size="30" id="book[subject1desc]" value="<?php echo @$book_meta['subject1desc'] ? $book_meta['subject1desc'] : ''; ?>" class="formInputSmall" /><a href="http://www.bisg.org/what-we-do-0-136-bisac-subject-headings-list-major-subjects.php" target="_blank" style="padding-left:10px;">Find subjects</a></div>

	  </div> 

		

		<!--SUBJECT 2------------------------------>

	  <div class="book_meta_group">

			<div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">Subject 2:</div>

		   <div class="book_meta_field"><input name="book[subject2code]" value="<?php echo @$book_meta['subject2code'] ? $book_meta['subject2code'] : ''; ?>" type="text" maxlength="400" size="10" id="book[subject2code]" class="formInputSmall" />&nbsp; <input name="book[subject2desc]" type="text" maxlength="400" size="30" id="book[subject2desc]" value="<?php echo @$book_meta['subject2desc'] ? $book_meta['subject2desc'] : ''; ?>" class="formInputSmall" /><a href="http://www.bisg.org/what-we-do-0-136-bisac-subject-headings-list-major-subjects.php" target="_blank" style="padding-left:10px;">Find subjects</a></div>

	  </div> 

		

		<!--SUBJECT 3------------------------------>

	  <div class="book_meta_group">

			<div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">Subject 3:</div>

		   <div class="book_meta_field"><input name="book[subject3code]" value="<?php echo @$book_meta['subject3code'] ? $book_meta['subject3code'] : ''; ?>" type="text" maxlength="400" size="10" id="book[subject3code]" class="formInputSmall" />&nbsp; <input name="book[subject3desc]" type="text" maxlength="400" size="30" id="book[subject3desc]" value="<?php echo @$book_meta['subject3desc'] ? $book_meta['subject3desc'] : ''; ?>" class="formInputSmall" /><a href="http://www.bisg.org/what-we-do-0-136-bisac-subject-headings-list-major-subjects.php" target="_blank" style="padding-left:10px;">Find subjects</a></div>

	  </div> 

	  <div class="book_meta_field_description">&nbsp;</div>

	  <!--CONTRIBUTORS------------------------------>

	  <div class="book_meta_group">

			<div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">Contributors:</div>

	  </div>

	<div class="book_meta_field_description_right">&nbsp;</div>

	  <div class="book_meta_group">

		<div class="book_contributors" style="border-bottom:0;">

			<div class="book_contributor_last"><span style="color:#F00">*</span> Last Name</div>

			<div class="book_contributor_first">First</div>

			<div class="book_contributor_middle">Middle</div>

			<div class="book_contributor_role"><span style="color:#F00">*</span> Role</div>

		   <div class="book_meta_field_description">&nbsp;</div>

		   

		   <div class="book_contributor">

				<div class="book_contributor_number"><span style="color:#F00">*</span>1. </div>

		   <input name="book[contributor1last]" type="text" size="20" id="contributor1last" class="contributor1last" value="<?php echo @$book_meta['contributor1last'] ? $book_meta['contributor1last'] : ''; ?>" class="formInputSmall" />

			<input name="book[contributor1first]" type="text" size="10" id="book[contributor1first]" value="<?php echo @$book_meta['contributor1first'] ? $book_meta['contributor1first'] : ''; ?>" class="formInputSmall" />

			<input name="book[contributor1middle]" type="text" size="10" id="book[contributor1middle]" value="<?php echo @$book_meta['contributor1middle'] ? $book_meta['contributor1middle'] : ''; ?>" class="formInputSmall" />

				<select name="book[contributor1role]" id="contributor1role" class="formInputSmall contributor1role">

					<?php 

						$selected_role1 = @$book_meta['contributor1role'] ? $book_meta['contributor1role'] : 'aut';

						echo $usersrole = pubml_role_selector("$selected_role1"); 

					?>

				</select>

			</div>

				

			<div class="book_contributor">

				<div class="book_contributor_number">2. </div>

		   <input name="book[contributor2last]" type="text" size="20" id="book[contributor2last]" value="<?php echo @$book_meta['contributor2last'] ? $book_meta['contributor2last'] : ''; ?>" class="formInputSmall" />

			<input name="book[contributor2first]" type="text" size="10" id="book[contributor2first]" value="<?php echo @$book_meta['contributor2first'] ? $book_meta['contributor2first'] : ''; ?>" class="formInputSmall" />

			<input name="book[contributor2middle]" type="text" size="10" id="book[contributor2middle]" value="<?php echo @$book_meta['contributor2middle'] ? $book_meta['contributor2middle'] : ''; ?>" class="formInputSmall" />

			<select name="book[contributor2role]" id="contributor2role" class="formInputSmall">

				<?php 	

					$selected_role2 = @$book_meta['contributor2role'] ? $book_meta['contributor2role'] : 'aut';

					echo $usersrole = pubml_role_selector("$selected_role2"); 

				?>

			</select>

			</div>

				

			<div class="book_contributor">

				<div class="book_contributor_number">3. </div>

		   <input name="book[contributor3last]" type="text" size="20" id="book[contributor3last]" value="<?php echo @$book_meta['contributor3last'] ? $book_meta['contributor3last'] : ''; ?>" class="formInputSmall" />

			<input name="book[contributor3first]" type="text" size="10" id="book[contributor3first]" value="<?php echo @$book_meta['contributor3first'] ? $book_meta['contributor3first'] : ''; ?>" class="formInputSmall" />

			<input name="book[contributor3middle]" type="text" size="10" id="book[contributor3middle]" value="<?php echo @$book_meta['contributor3middle'] ? $book_meta['contributor3middle'] : ''; ?>" class="formInputSmall" />

			<select name="book[contributor3role]" id="contributor1role3" class="formInputSmall">

				<?php 

					$selected_role3 = @$book_meta['contributor3role'] ? $book_meta['contributor3role'] : 'aut';

					echo $usersrole = pubml_role_selector("$selected_role3"); 

					

				?>

			</select>

			</div>

		</div>

		<div class="book_meta_field_description">Enter the names of at least one (and up to three) authors, editors, designers, etc. who contributed to your book</div>



	  </div>

	   <!--SYNOPSIS------------------------------>

	  <div class="book_meta_group">

			<div class="field_required">&nbsp;</div>

			<div class="book_meta_field_label">Description/Annotation:</div>

		<div class="book_meta_field_description_right">&nbsp;</div>

		   <div style="margin-left:20px;clear:both;"><textarea id="tag-description" name="description" cols="40" rows="5" style="width:98%;" ><?php echo @stripslashes($Book->description); ?></textarea></div>

	  <div class="book_meta_field_description">This is the "back cover blurb" describing your book to prospective readers.</div>

	  </div>
	  
	<!-- Short Description ---------------------------- -->

		<div class="book_meta_group">
			<div class="field_required">&nbsp;</div>
			<div class="book_meta_field_label">Short Description:</div>
			<div class="book_meta_field"> 
			<textarea id="short_desc" cols="58" class="short_desc" name="book[short_desc]"><?php echo @stripslashes($book_meta['short_desc']) ? stripslashes($book_meta['short_desc']) : ''; ?></textarea>
			</div>
		</div>
		<div class="book_meta_field_description">A short description that can be read by search engines (160 characters max).</div>  

  
	<!-- "Your  Book's  Website" ---------------------------- -->

		<div class="book_meta_group">
			<div class="field_required">&nbsp;</div>
			<div class="book_meta_field_label">Your Book's Website:</div>
			<div class="book_meta_field"> 
			<input size="60" id="book_website" class="book_website" name="book[book_website]" type="text" maxlength="160" value="<?php echo @$book_meta['book_website'] ? stripslashes($book_meta['book_website']) : ''; ?>" class="formInputSmall" /></div>
			<input id="book_modified_date" class="book_modified_date" name="book[book_modified_date]" type="hidden" maxlength="160" value="<?php echo $today = date("Y-m-d H:i:s"); ?>" class="formInputSmall" />
		</div>
		<div class="book_meta_field_description">Website for your book (include "http://")</div>  



  
	<!-- "Your Book Cover" ---------------------------- -->
		<?php 	$book_cover = @$book_meta['cover_meta'] ? stripslashes($book_meta['cover_meta']) : ''; 
				$cover_img_meta = "<img class='taxonomy-image' src='$book_cover'/>";		
		?>
		<div class="book_meta_group">
			<div class="field_required">&nbsp;</div>
			<div class="book_meta_field_label">Book Cover:</div>
				<div class="book_meta_field">
					<div class="book_img" id="book_cover_meta"><?php echo @$cover_img_meta; ?></div>
					<input type="hidden" name="book[cover_meta]" id="taxonomy_cover_image" value="<?php echo @$book_cover; ?>" />
					
					<div class="sec_btns">
						<a class="button-primary button-large" data-editor="custom_section_image" id="upload_image_button" href="#">Upload/Add image</a>
						<a class="remove_img_btn button-primary button-large" id="remove_img_button" href="#">Remove Image</a>
					</div>					 
				</div>
			<div class="book_meta_field_description" style="border:none;">Upload a front cover image for your book (JPEG, GIF, PNG)</div>	
		</div>
	
		<div class="clear">&nbsp;</div>

	<div style="margin-right: 15px;">  
		<input type="submit" value="Submit Book Metadata" style="float:right;" class="big_green_button">
	</div>
	<div class="clear">&nbsp;</div>

</div>

</form>

</div>

<script>

jQuery(function(){
    // Initialise the validator
	jQuery('#new_book_creation').validate();
    // Add the rules to the classname hooks
	jQuery.validator.addClassRules({
		book_title: {
			 required: true
		},
		contributor1last: {
			required: true
		},
		contributor1role: {
			required: true
		}
	});
});
	// When the document is ready set up our sortable with it's inherant function(s)
	jQuery(document).ready(function($) {
		// Validation for tabs to save data first
		$('.InvalidPubMLeBook').click(function() {
			alert("Please Save this Book info First!");
			return false;
		});
	
	
	// Scripts for the media uploader
    var custom_uploader;
 
	// Open wordpress media uploader
	$('#upload_image_button').click(function(e) {
		e.preventDefault();
			//If the uploader object has already been created, reopen the dialog
			if (custom_uploader) {
				custom_uploader.open();
				return;
			}
	 
			//Extend the wp.media object
			custom_uploader = wp.media.frames.file_frame = wp.media({
				title: 'Choose Image',
				button: {
					text: 'Choose Image'
				},
				multiple: false
			});
	 
			//When a file is selected, grab the URL and set it as the text field's value
			custom_uploader.on('select', function() {
				attachment = custom_uploader.state().get('selection').first().toJSON();
				$('#taxonomy_cover_image').val(attachment.url);
				$('#book_cover_meta').html("<img src='"+attachment.url+"' class='taxonomy-image'>");
				unSavedData = true;
			});
	 
			//Open the uploader dialog
			custom_uploader.open();
	 
		});

		// Remove image
		$('#remove_img_button').click(function(e) {
			e.preventDefault();
			jQuery('#book_cover_meta').html('');
			jQuery('#taxonomy_cover_image').val('');
		});

	});
</script>