<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

	/*	
	*	Page Numbers File
	*	---------------------------------------------------------------------
	* 	@version	1.0
	* 	@author		SynapseIndia
	* 	@link		http://www.synapseindia.com
	*	---------------------------------------------------------------------
	*	This file is used to add page numbers styles under styles section of book.
	*	---------------------------------------------------------------------
	*/

?>
<div class="styles-container" id="book-style-text-three">

	<p>Page number styles use fonts defined in the main FONTS tab. Add custom typefaces there as needed. Adjust built-in styles on a per-book basis here.</p>

	<div>

		<h3 style="float: left;margin-top: 1%;">Page Numbers</h3> 

		<span style="float: left;" id="styles_page_numbers" class="help openhelp"><img src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span>

	</div>

	<div>

		<h4 style="float: left;margin-top: 1%;">Page Number Horizontal Alignment</h4> 

	</div>

	<div class="pnumbers">

		<img src="<?php echo PUBML_BASE_URL;?>/images/page_number_background.jpg">

		<span style="margin-top: 120px;position: absolute;left: 245px;width:auto;text-align:center;" class="pno">&nbsp;1/10&nbsp;</span>

	</div>



	<div class="running-left">

		<?php

			$hpos_checked = (@$option == $data['page_numbers']['book-hpos'])? ' checked="checked"' : '';

			$hpos1 = 'unchecked';

			$hpos2= 'unchecked';

			$hpos3 = 'unchecked';

			if (isset($data)) {

				$selected_radio = $data['page_numbers']['book-hpos'];

				if ($selected_radio == 'left') {

					$hpos1  = 'checked';

				}

				else if ($selected_radio == 'centered') {

					$hpos2 = 'checked';

				}

				else if ($selected_radio == 'right') {

					$hpos3  = 'checked';

				}

			}

		?>

		<span>

			<div><span><input  type="radio" <?php echo $hpos1; ?> class="book-hpos" name="page_numbers[book-hpos]" value="left" /></span><span>Left</span></div>

			<div><span><input  checked="checked" type="radio" <?php echo $hpos2; ?> class="book-hpos" name="page_numbers[book-hpos]" value="center" /></span><span>Centered</span></div>

			<div><span><input  <?php echo $hpos3; ?> type="radio" class="book-hpos" name="page_numbers[book-hpos]" value="right" /></span><span>Right</span></div>

		</span>

		<p>Page Numbers(folios) are vertically centered in the bottom margin	<br/>

			Page Numbers are aligned horizontally with the body text based on your selection.

		</p>

	</div>

	<div>
		<h4 style="float: left;margin-top: 1%;">Text Before and After Page Numbers</h4>
	</div>



	<div style="width: 60%;">
		<span><input maxlength="8" value="<?php echo (!empty($data['page_numbers']['text-before'])) ? $data['page_numbers']['text-before'] : ''; ?>" type="text" name="page_numbers[text-before]" id="text-before" />&nbsp;<i> page number</i>&nbsp;</span>

		<span><input maxlength="8" value="<?php echo (!empty($data['page_numbers']['text-after'])) ? $data['page_numbers']['text-after'] : ''; ?>" type="text" name="page_numbers[text-after]" id="text-after" /></span>

		<p>use this option to add text or dashes adjacent to page numbers.</p>
	</div>
	
	<div>
		<h4 style="float: left;margin-top: 1%;">Font Family and Font Size</h4> 

  </div>

<div style="width: 60%;">
	<?php 
		echo $fonts_select = pubml_fonts_dropdown('page-number-font-menu');
		if ($data['page_numbers']['font-bold'] == 'bold') {
			$fontbold = 'checked';
		}
		if ($data['page_numbers']['font-italic'] == 'italic') {
			$fontitalic = 'checked';
		}			
	?>
	<input style="width:50px;"type="text" id="style-two-font-val" name="page_numbers[style-two-font-val]" value="<?php echo (!empty($data['page_numbers']['style-two-font-val'])) ? $data['page_numbers']['style-two-font-val'] : ''; ?>" />px &nbsp; &nbsp; 	
	<input  <?php echo $fontbold; ?>   type="checkbox" name="page_numbers[font-bold]" id="font-bold" value="bold" />Bold &nbsp; <input  <?php echo $fontitalic; ?>   type="checkbox" name="page_numbers[font-italic]" id="font-italic" value="italic" />Italic
</div>
	

</div>

<script>
	jQuery('#PubML_fonts_page-number-font-menu option[value="<?php echo  $data['page-number-font-menu']; ?>"]').attr('selected', 'selected');
	jQuery('.pagenumber-font-weight option[value="<?php echo  $data['page_numbers']['pagenumber-font-weight']; ?>"]').attr('selected', 'selected');
</script>