<?php

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/


	/*	

	*	Settings File

	*	---------------------------------------------------------------------

	* 	@version	1.0

	* 	@author		SynapseIndia

	* 	@link		http://www.synapseindia.com

	*	---------------------------------------------------------------------

	*	This file is used to manage book settings and license.

	*	---------------------------------------------------------------------

	*/

?>

<div id="book_meta">

<div class="screen_icon"><img src="<?php echo PUBML_BASE_URL;?>/images/settings_icon_64x64.png" width="64" height="64"  alt=""/></div>

<h2>Purchase License <span class="help openhelp" id="top_level_settings_registration"><img style="vertical-align:middle ! important;" src="<?php echo PUBML_BASE_URL;?>/images/help.png"></span></h2>



<!--TABS------------------------------>

<div class="primary_menu_bar">

	<?php fn_custom_tabs_main('My Books');?>

</div>



<div class="clear"></div>

<div class="secondary_menu_bar">

	<?php fn_custom_tabs_toc('Export');?>

</div>



<div class="content_container licenese_container" >

	<div class="settings_content">

	<div class="license_left_content" >

		<p> &lt;PubML&gt;™ is "Publishing with HTML" - a sophisticated web publishing system designed for use by publishers of all sizes.

		<br><br>

		<p> &lt;PubML&gt;™ includes expert publishing and design guidance to help you produce excellent books.</p>

		<p>See our companion website at <a href="http://www.theworldsgreatestbook.com">http://www.theworldsgreatestbook.com</a></p>

		<p> &lt;PubML&gt;™ Publishing Tools export to ePub (for upload to Kindle, Nook, Google Books, Kobo, etc.) and to our unique and powerful  &lt;PubML&gt;™ web book format.

		<h3>Please register the &lt;PubML&gt;™ plugin and/or activate your license key to preview, embed, or export eBooks.</h3>		

		<?php

		//$pubml_updater = new PUBML_Ebook_Plugin_Updater;

		echo "<pre>";

			print_r($pubml_updater);

		echo "</pre>";	

		?>

	

	</div>

<div class="license_right_content">	

	<h2>The World's Greatest Book</h2>

	<?php // Get RSS Feed(s)

	include_once( ABSPATH . WPINC . '/feed.php' );



	// Get a SimplePie feed object from the specified feed source.

	$rss = fetch_feed( 'http://theworldsgreatestbook.com/feed/' );



	if ( ! is_wp_error( $rss ) ) : // Checks that the object is created correctly



		// Figure out how many total items there are, but limit it to 5. 

		$maxitems = $rss->get_item_quantity( 15 ); 



		// Build an array of all the items, starting with element 0 (first element).

		$rss_items = $rss->get_items( 0, $maxitems );



	endif;

	?>



	<ul>

		<?php if ( $maxitems == 0 ) : ?>

			<li><?php _e( 'No items', 'my-text-domain' ); ?></li>

		<?php else : ?>

			<?php // Loop through each feed item and display each item as a hyperlink. ?>

			<?php foreach ( $rss_items as $item ) : ?>

				<li>

					<a target="_blank" href="<?php echo esc_url( $item->get_permalink() ); ?>"

						title="<?php printf( __( 'Posted %s', 'my-text-domain' ), $item->get_date('j F Y | g:i a') ); ?>">

						<?php echo esc_html( $item->get_title() ); ?>

					</a>

				</li>

			<?php endforeach; ?>

		<?php endif; ?>

	</ul>

</div>

  </div>

  </div>

</div>