/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.

<PubML> - Web-Based eBooks

Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

jQuery(window).load(function() {
	change_page_styles(1);
});

jQuery(document).ready(function() {		
		jQuery("ul.tabs", wizard).tabs("div.panes > div.styles-container", function(event, index) {

		});

		// get handle to the tabs API
		var api = jQuery("ul.tabs", wizard).data("tabs");
		// "next tab" button
		jQuery("span.next", wizard).click(function() {
			api.next();
		});

		// "previous tab" button
		jQuery("span.prev", wizard).click(function() {
			api.prev();
		});

		var custom_uploader;
		jQuery('#upload-back-image').click(function(e) {
			e.preventDefault();
			//If the uploader object has already been created, reopen the dialog
			if (custom_uploader) {
				custom_uploader.open();
				return;
			}
			//Extend the wp.media object
			custom_uploader = wp.media.frames.file_frame = wp.media({
				title: 'Choose Image',
				button: {
					text: 'Choose Image'
				},
				multiple: false
			});

			//When a file is selected, grab the URL and set it as the text field's value
			custom_uploader.on('select', function() {
				attachment = custom_uploader.state().get('selection').first().toJSON();
				jQuery("#back-img-val").val(attachment.url);
				jQuery(".cus-image").css("display","block");
				jQuery(".style-all").css("background","url('"+attachment.url+"')");
				jQuery(".style-all").css("background-repeat","repeat");
				jQuery(".custom-back .back-radios").show();
				
				if(jQuery.isEmptyObject(attachment.sizes.chapter_head )){
					jQuery('#custom-image-thumb').val(attachment.url);
					jQuery(".cback").attr("src",attachment.url);
				}
				else {				
					jQuery('#custom-image-thumb').val(attachment.sizes.chapter_head.url);
					jQuery(".cback").attr("src",attachment.sizes.chapter_head.url);
				}
			});
			//Open the uploader dialog
			custom_uploader.open();
		});
/* for restoring background */
		  jQuery('#restore-back-image').click(function(e) {
				var restore_back_val = jQuery('#restore-custom-img').val();
				var restore_back_thumb = jQuery('#restore-custom-img-thumb').val();
				jQuery("#back-img-val").val(restore_back_val);
				jQuery(".cus-image").css("display","block");
				jQuery(".style-all").css("background","url('"+restore_back_val+"')");
				jQuery(".style-all").css("background-repeat","repeat");
				jQuery(".custom-back .back-radios").hide();
				jQuery('#custom-image-thumb').val(restore_back_thumb);
				jQuery(".cback").attr("src",restore_back_thumb);
		});
	

		var texture_val = jQuery("#def-paper-img-val").val();
		jQuery(".custom-back").css("background","url('"+texture_val+"')");
		var paper_custom_uploader;
		jQuery('#upload-paper-image').click(function(e) {
			e.preventDefault();
			//If the uploader object has already been created, reopen the dialog
			if (paper_custom_uploader) {
				paper_custom_uploader.open();
				return;
			}

			//Extend the wp.media object
			paper_custom_uploader = wp.media.frames.file_frame = wp.media({
				title: 'Choose Image',
				button: {
					text: 'Choose Image'
				},
				multiple: false
			});

			//When a file is selected, grab the URL and set it as the text field's value
			paper_custom_uploader.on('select', function() {
				attachment = paper_custom_uploader.state().get('selection').first().toJSON();
				jQuery("#paper-img-val").val(attachment.url);
				jQuery(".custom-back").css("background","url('"+attachment.url+"')");
				jQuery(".custom-back").css("background-repeat","repeat");
			});


			//Open the uploader dialog
			paper_custom_uploader.open();
		});

		
		
		jQuery('.pmargin-custom').hide();
		jQuery('.pmargin-val').click(function(e) {
			if(jQuery(this).attr("checked")){
				var cus_val = jQuery(this).val();
				if(cus_val=='custom'){
					jQuery('.pmargin-custom').show();		
				}
				else{
					jQuery('.pmargin-custom').hide();	
				}
			}
		});



		jQuery('.prop-three').hide();
		jQuery('.prop-val').click(function(e) {
			if(jQuery(this).attr("checked")){
				var pval = jQuery(this).val();
				if(pval=='custom'){
					jQuery('.prop-three').show();		
				}
				else{
					jQuery('.prop-three').hide();	
				}
			}
		});



		var head_custom_uploader;
		jQuery('#upload-head-link').click(function(e) {
			e.preventDefault();
			//If the uploader object has already been created, reopen the dialog
			if (head_custom_uploader) {
				head_custom_uploader.open();
				return;
			}
			//Extend the wp.media object
			head_custom_uploader = wp.media.frames.file_frame = wp.media({
				title: 'Choose Image',
				button: {
				text: 'Choose Image'
				},
				multiple: false
			});

			//When a file is selected, grab the URL and set it as the text field's value
			head_custom_uploader.on('select', function() {
				attachment = head_custom_uploader.state().get('selection').first().toJSON();
				//alert(console.log(attachment.sizes));
			//	alert("Images with size more than 30x30PX will be cropped.");
				if(jQuery.isEmptyObject(attachment.sizes.running_head)){
					jQuery('#orn-head-val').val(attachment.url);
					jQuery(".orn-img").attr("src",attachment.url);
					jQuery('.del-ornament').show();
					jQuery(".orn-img").show();
				}
				else {
					jQuery('#orn-head-val').val(attachment.sizes.running_head.url);
					jQuery(".orn-img").attr("src",attachment.sizes.running_head.url);
					jQuery('.del-ornament').show();
					jQuery(".orn-img").show();
				}
				jQuery('#upload-head-link').hide();
			});

			//Open the uploader dialog
			head_custom_uploader.open();
		});



		var chapter_custom_uploader;
		jQuery('#upload-ornament-link').click(function(e) {
			e.preventDefault();
			//If the uploader object has already been created, reopen the dialog
			if (chapter_custom_uploader) {
				chapter_custom_uploader.open();
				return;
			}

			//Extend the wp.media object
			chapter_custom_uploader = wp.media.frames.file_frame = wp.media({
				title: 'Choose Image',
				button: {
				text: 'Choose Image'
				},
				multiple: false
			});
			//When a file is selected, grab the URL and set it as the text field's value
			chapter_custom_uploader.on('select', function() {
				attachment = chapter_custom_uploader.state().get('selection').first().toJSON();
				//alert("Images with size more than 80x80PX will be cropped.");
				if(jQuery.isEmptyObject(attachment.sizes.chapter_head )){
					jQuery('#orn-style-val').val(attachment.url);
					jQuery(".chap-orn-img").attr("src",attachment.url);
					jQuery(".chap-orn-img").show();
				}
				else {				
					jQuery('#orn-style-val').val(attachment.sizes.chapter_head.url);
					jQuery(".chap-orn-img").attr("src",attachment.sizes.chapter_head.url);
					jQuery(".chap-orn-img").show();
				}
					jQuery(".del-chap-ornament").show();
					jQuery('#upload-ornament-link').hide();
			});

			//Open the uploader dialog
			chapter_custom_uploader.open();
		});



		jQuery('.custom-val-head').hide();
		jQuery('.ornahead-val').click(function(e) {
			if(jQuery(this).attr("checked")){
				var pval = jQuery(this).val();
				if(pval=='custom'){
					jQuery('.custom-val-head').show();		
				}
				else{
					jQuery('.custom-val-head').hide();	
				}
			}
		});



		jQuery('#full-screen').click(function(e) {
			jQuery(".style-all").css("background-repeat","no-repeat");
			jQuery(".style-all").css("background-size","cover");
			jQuery(".style-all").addClass("fullback");
		});

		jQuery('#tile-screen').click(function(e) {
			jQuery(".style-all").css("background-repeat","repeat");
			jQuery(".style-all").css("background-size","");
		});

		var background_val = jQuery('.background-type:checked').val();
		if(background_val=='tile'){
			jQuery(".style-all").css("background-repeat","repeat");
		}
		else if(background_val=='full'){
			jQuery(".style-all").css("background-repeat","no-repeat");
			jQuery(".style-all").addClass("fullback");
			jQuery(".style-all").css("background-size","cover");
		}

		var proportion_val = jQuery('.prop-val:checked').val();
		if(proportion_val=='custom'){
			jQuery(".prop-three").css("display","block");
		}

		var pmargin_val = jQuery('.pmargin-val:checked').val();
		if(pmargin_val=='custom'){
			jQuery(".pmargin-custom").css("display","block");
		}

		var book_head_val = jQuery('.ornahead-val:checked').val();
		if(book_head_val=='custom'){
			jQuery(".custom-val-head").css("display","block");
		}

		var sep_img_val = jQuery('.custom-separator:checked').parent().find("img").attr("src");
		if(sep_img_val !=''){
			jQuery(".sep-preview").attr("src",sep_img_val).show();
		}else{
			jQuery(".sep-preview").hide();
		}

		var caps_val = jQuery('.capitals-val:checked').parent().parent().find("img").attr("src");
		if(caps_val !=''){
			jQuery(".bigfont").attr("src",caps_val);
		}
		
		var cus_sep_val = jQuery('.custom-separator:checked').val();
		if(cus_sep_val=='custom_sep'){
			var imgval = jQuery("#upload-sep-link-val").val();
			if(imgval != '')
				jQuery(".sep-preview").attr("src",imgval).show();
			else
				jQuery(".sep-preview").hide();
		}

		jQuery('.color').blur(function(e) {
			var color = jQuery(this).val();
			jQuery(".custom-back").css("background-color",'#'+color);
		});

		jQuery('.del-ornament').click(function(e) {
			var def_val = jQuery('#def-orn-head-val').val();
			jQuery(".orn-img").attr("src",def_val);
			jQuery(this).hide();
			jQuery('#orn-head-val').val(def_val);
			jQuery('#upload-head-link').show();
		});

		jQuery('.cback').click(function(e) {
			var img_val = jQuery(this).attr('src');
			jQuery("#back-img-val").val(img_val);
			jQuery(".style-all").css("background","url('"+img_val+"')");
			jQuery(".custom-back .back-radios").show();
		});

		jQuery('.def-image').click(function(e) {
			var img_val = jQuery(this).attr('src');
			jQuery("#back-img-val").val(img_val);
			jQuery(".style-all").css("background","url('"+img_val+"')");
			jQuery("#tile-screen").attr("checked","checked");
			jQuery(".custom-back .back-radios").hide();
		});



		jQuery("#save-style").click(function(){
			var style_type = 'style';
			var new_style = jQuery("#add-new-style-val").val();
			var style_name = jQuery("#style-name-val").val();
			var style_slug = jQuery("#style-slug").val();			
			var style_desc = jQuery(".style-desc").val();
			var style_prev =  jQuery("#style_prev").text();
			var style_font = jQuery("#PubML_fonts_text-font-menu").val();
			var style_font_size = jQuery("#style-font-val").val();
			var style_line_indent = jQuery("#line-indent-val").val();
			var style_left_margin = jQuery("#lmargin-val").val();
			var style_right_margin = jQuery("#rmargin-val").val();
			var default_style = jQuery('.text-font-weight').val();
			// var style_hyphen = jQuery(".hypen-val").val();
			// var style_runt = jQuery(".runt-val").val();
			
			var style_hyphen = ( jQuery(".hypen-val").is(":checked") ) ? 'on' : '' ;
			var style_runt = ( jQuery(".runt-val").is(":checked") ) ? 'on' : '' ;
			
			var style_align = jQuery(".align-val").val();
			var style_lines_before = jQuery("#lines-before").val();
			var style_lines_after = jQuery("#lines-after").val();
			var style_line_height = jQuery("#line-height-val").val();
			var bid =jQuery("#cur_book_id").val();
			var style_val = jQuery("#style-val option:selected").val();
			if(style_val == 1){
				var hide_from_section_editor = 'true';
			}
			else{
				var hide_from_section_editor = 'false';
			}
			var hide_from_section_editor = jQuery("#hide_from_section_editor").val();
			jQuery.ajax({
				url: ajaxurl,
				type: 'POST', 
				data: {
					'action':'pubml_media_insert_page_style',
					'bid' : bid,
					'style_name' : style_name,
					'style_slug' : style_slug,
					'style_type' : style_type,
					'style_desc' : style_desc,
					'style_prev' : style_prev,
					'style_val' : style_val,
					'style_font' : style_font,
					'style_font_size' :style_font_size,
					'style_line_indent' : style_line_indent,
					'style_left_margin' :style_left_margin,
					'style_right_margin': style_right_margin,
					'default_style': default_style,
					'style_hyphen': style_hyphen,
					'style_runt' : style_runt,
					'style_align':style_align,
					'style_lines_before' : style_lines_before,
					'style_lines_after':style_lines_after,
					'style_line_height' : style_line_height,
					'hide_from_section_editor' : hide_from_section_editor,
					'new_style' : new_style
				},
				dataType:'json',
				success:function(response) {
				if(response.data){
						jQuery("#style-val").html(response.data);
						jQuery('.msg-text').html(response.msg);
						jQuery('.msg-text').show();
						jQuery('.msg-text').fadeOut(5000);	
					}
					change_page_styles(1);
				},
				error: function(errorThrown){
					console.log(errorThrown);
				}
			});
		});
		
		
		
		jQuery("#save-page-style").click(function(){
			var style_type = 'page-style';
			var style_name = jQuery("#style-two-name-val").val();
			var style_desc = jQuery(".style-two-desc").val();
			var style_prev =  jQuery(".style-two-prev").val();
			var style_font = jQuery("#book-style-text-two #PubML_fonts_text-font-menu").val();
			var style_font_size = jQuery("#style-two-font-val").val();
			var style_line_indent = jQuery("#line-two-indent-val").val();
			var style_body_indent = jQuery("#body-two-indent-val").val();
			var style_left_margin = jQuery("#lmargin-two-val").val();
			var style_right_margin = jQuery("#rmargin-two-val").val();
			var default_style = jQuery('.text-two-font-weight').val();
			var style_hyphen = jQuery(".hypen-two-val").val();
			var style_runt = jQuery(".runt-two-val").val();
			var style_align = jQuery(".align-two-val").val();
			var style_lines_before = jQuery("#lines-before-two").val();
			var style_lines_after = jQuery("#lines-after-two").val();
			var bid =jQuery("#cur_book_id").val();
			var style_val = jQuery("#page-style-val").val();
			jQuery.ajax({
				url: ajaxurl,
				type: 'POST', 
				data: {
					'action':'pubml_media_insert_style',
					'bid' : bid,
					'style_name' : style_name,
					'style_desc' : style_desc,
					'style_prev' : style_prev,
					'style_type' : style_type,
					'style_font' : style_font,
					'style_font_size' :style_font_size,
					'style_line_indent' : style_line_indent,
					'style_body_indent' : style_body_indent,
					'style_left_margin' :style_left_margin,
					'style_right_margin': style_right_margin,
					'default_style': default_style,
					'style_hyphen': style_hyphen,
					'style_runt' : style_runt,
					'style_align':style_align,
					'style_lines_before' : style_lines_before,
					'style_lines_after':style_lines_after
				},
				dataType:'json',
				success:function(response) {
					
					if(response.data){
						jQuery("#page-style-val").html(response.data)
					}
					jQuery('.msg-text').html(response.msg);
					jQuery('.msg-text').show();
					jQuery('.msg-text').fadeOut(5000);	
				},
				error: function(errorThrown){
					console.log(errorThrown);
				}
			});
		});
		
		
		
		
		jQuery(".sep-img").hide();
		var seperator_custom_uploader;
		jQuery('#upload-sep-link').click(function(e) {
			e.preventDefault();
			//If the uploader object has already been created, reopen the dialog
			if (seperator_custom_uploader) {
				seperator_custom_uploader.open();
				return;
			}
			//Extend the wp.media object
			seperator_custom_uploader = wp.media.frames.file_frame = wp.media({
				title: 'Choose Image',
				button: {
					text: 'Choose Image'
				},
				multiple: false
			});
			//When a file is selected, grab the URL and set it as the text field's value
			seperator_custom_uploader.on('select', function() {
				attachment = seperator_custom_uploader.state().get('selection').first().toJSON();
				jQuery('#upload-sep-link-val').val(attachment.url);
				//	jQuery(".sep-img").attr("src",attachment.url);
				jQuery(".sep-preview").attr("src",attachment.url).show();
				jQuery(".sep-img").attr("src",attachment.url).hide();
				jQuery("input:radio[name='seperator_ornament[custom-separator]'][value ='custom_sep']").prop('checked', true);
				// jQuery('#upload-sep-link').hide();
				// jQuery('.del-sep-link').show();
			});
			//Open the uploader dialog
			seperator_custom_uploader.open();
		});	


		jQuery("#style-val").live('change',function(){
			   var style_val = jQuery(this).val();
				change_page_styles(style_val);
		});


		jQuery("#page-style-val").change(function(){
			var style_val = jQuery(this).val();
			var bid =jQuery("#cur_book_id").val();
			jQuery.ajax({
				url: ajaxurl,
				type: 'POST', 
				data: {
					'action':'pubml_media_get_page_style',
					'bid' : bid,
					'style_val' : style_val
				},
				dataType:'json',
				success:function(response) {
					
					if(response.data){
						jQuery("#style-two-name-val").val(response.data.style_name);
						jQuery("#add-new-style-val").val('0');
						jQuery(".style-two-desc").val(response.data.style_desc);
						jQuery(".style-two-prev").val(response.data.style_prev);
						
						var font_f_text = (response.data.style_font).replace(/\\/g,'');

						jQuery("#PubML_fonts_text-font-menu").val(font_f_text);
						jQuery("#style-two-font-val").val(response.data.style_font_size);
						jQuery("#line-two-indent-val").val(response.data.style_line_indent);
						jQuery("#body-two-indent-val").val(response.data.style_body_indent);
						jQuery("#lmargin-two-val").val(response.data.style_left_margin);
						jQuery("#rmargin-two-val").val(response.data.style_right_margin);
						jQuery('.text-two-font-weight').val(response.data.default_style);
						jQuery(".align-two-val").val(response.data.style_align);
						jQuery("#lines-before-two").val(response.data.style_lines_before);
						jQuery("#lines-after-two").val(response.data.style_lines_after);
						jQuery("#hide_from_section_editor").val(response.data.hide_from_section_editor);
						if(response.data.style_hyphen =='off'){
							jQuery(".hypen-two-val").attr("checked","checked");
						}
						if(response.data.style_runt =='off'){
							jQuery("runt-two-val").attr("checked","checked");
						}				
					}
				var fontfamily = jQuery("#book-style-text-three .text-font-menu").val();
				var fontsize  =  jQuery("#book-style-text-three #style-two-font-val").val();
				var left_val   =  jQuery("#book-style-text-three #lmargin-two-val").val();
				var right_val   =  jQuery("#book-style-text-three #rmargin-two-val").val();
				jQuery(".style-two-prev").css("font-size",fontsize + 'px');
				jQuery(".style-two-prev").css("font-family",fontfamily);
				jQuery(".style-two-prev").css("padding-left",left_val + 'px');
				jQuery(".style-two-prev").css("padding-right",right_val + 'px');
				},
				error: function(errorThrown){
					console.log(errorThrown);
				}
			});
		});



		jQuery(".capitals-val").click(function(){
			if(jQuery(this).is(":checked")){
				var src = jQuery(this).parent().parent().find('img').attr("src");
				jQuery(".bigfont").attr("src",src);
			}
		});


		jQuery(".custom-separator").click(function(){
			if(jQuery(this).is(":checked")){
				var src = jQuery(this).parent().find('img').attr("src");
				if(src != '')
					jQuery(".sep-preview").attr("src",src).show();
				else
					jQuery(".sep-preview").hide();
					
				var sep_val = jQuery(this).val();
				jQuery("#upload-sep-link-val").val(src);
							
				if(sep_val=='custom_sep'){
					// jQuery("#upload-sep-link-val").val(jQuery("#uploaded-seprator").val());
					// jQuery("#upload-sep-link").css("display","block");
				}
			}
		});
		
		
		jQuery(".del-sep-link").click(function(){
			jQuery(this).hide();
			jQuery("input:radio[name='seperator_ornament[custom-separator]'][value ='sep_1']").prop('checked', true);
			jQuery("#upload-sep-link").show();
			var sep_img_val = jQuery('.custom-separator:checked').parent().find("img").attr("src");
			if(sep_img_val !=''){
				jQuery(".sep-preview").attr("src",sep_img_val);
				jQuery("#upload-sep-link-val").val(sep_img_val);
			}
		});
		
		jQuery(".book-hpos").click(function(){
			if(jQuery(this).is(":checked")){
				var hpos = jQuery(this).val();
				if(hpos=='left'){
					jQuery(".pno").css("left","100px");
				}
				else if(hpos=='center'){
					jQuery(".pno").css("left","245px");
				}
				else if(hpos=='right'){
					jQuery(".pno").css("left","400px");
				}
			}
		});
		
		jQuery(".del-chap-ornament").click(function(){
			var default_ornament = jQuery("#def-orn-style-val").val();
			jQuery(".chap-orn-img").attr("src",default_ornament);
			jQuery("#orn-style-val").val(default_ornament);
			jQuery(this).hide();
			jQuery('#upload-ornament-link').show();
		});
			
				
		jQuery("#book-style-text .text-font-menu").live('change',function(){
			var font_family_val = jQuery(this).val();
			var font_size_val   =  jQuery("#book-style-text #style-font-val").val();
			jQuery(".style-prev").css("font-size",font_size_val + 'px');
			jQuery(".style-prev").css("font-family",font_family_val);
		});
		
			
		var before_text = jQuery("#text-before").val();
		var after_text = jQuery("#text-after").val();
		var page_number_font = jQuery("#book-style-text-three .text-font-menu").val();
		var page_number_font_size = jQuery("#style-two-font-val").val();
		var page_number_font_style = jQuery("#pagenumber-font-weight").val();
		jQuery(".pno").html(before_text + ' 1/10 ' + after_text);
		jQuery(".pno").css("font-family",page_number_font);
		jQuery(".pno").css("font-size", page_number_font_size + 'px');
		jQuery(".pno").css("font-style", page_number_font_style);
		
		jQuery("#book-style-text #style-font-val").keyup(function(){
			jQuery(".style-prev").css("font-size", jQuery(this).val() + 'px');
		});
		
		jQuery("#book-style-text #line-height-val").keyup(function(){
			jQuery(".style-prev").css("line-height", jQuery(this).val() + 'px');
		});
		
		jQuery("#book-style-text .align-val").change(function(){
			jQuery(".style-prev").css("text-align", jQuery(this).val());
		});
	
		jQuery("#book-style-text .text-font-weight").change(function(){
			var fontval = jQuery(this).val();
			if(fontval=='normal' || fontval=='italic'){
				jQuery(".style-prev").css("font-style", fontval);
				jQuery(".style-prev").css("font-weight", fontval);
			}
			else if(fontval=='bold'){
				jQuery(".style-prev").css("font-weight", fontval);
			}
		});
		
		jQuery("#font-bold").click(function(){
			if(jQuery(this).is(":checked")){
				var fontval = jQuery(this).val();
				jQuery(".pno").css("font-weight", fontval);
			}
			else{
				jQuery(".pno").css("font-weight", "normal");
			}
		});
		
		jQuery("#font-italic").click(function(){
			if(jQuery(this).is(":checked")){
				var fontval = jQuery(this).val();
				jQuery(".pno").css("font-style", fontval);
			}
			else{
				jQuery(".pno").css("font-style", "normal");
			}
		});
		
				var font_val = jQuery("#font-bold:checked").val();
				jQuery(".pno").css("font-weight", font_val);

				var font_italic = jQuery("#font-italic:checked").val();
				jQuery(".pno").css("font-style", font_italic);
				
		jQuery("#book-style-text #style-font-val").keyup(function(){
			jQuery(".style-prev").css("font-size", jQuery(this).val() + 'px');
		});
		
		jQuery("#book-style-text-three .text-font-menu").live('change',function(){
				jQuery(".pno").css("font-family", jQuery(this).val());	
		});
		
		jQuery("#book-style-text-three #style-two-font-val").keyup(function(){
			jQuery(".pno").css("font-size", jQuery(this).val() + 'px');
		});

		jQuery("#book-style-text #lmargin-val").keyup(function(){
			jQuery(".style-prev").css("padding-left", jQuery(this).val() + 'px');
		});
		
		jQuery("#book-style-text #rmargin-val").keyup(function(){
			jQuery(".style-prev").css("padding-right", jQuery(this).val() + 'px');
		});
		
		jQuery("#book-style-text #lines-before").keyup(function(){
			jQuery(".style-prev").css("padding-top", jQuery(this).val() + 'px');
		});
		
		jQuery("#book-style-text #lines-after").keyup(function(){
			jQuery(".style-prev").css("padding-bottom", jQuery(this).val() + 'px');
		});
		
		jQuery("#line-indent-val").keyup(function(){
			jQuery(".style-prev").css("text-indent", jQuery(this).val() + 'px');
		});
		
		jQuery("#save-style-form").click(function(){
			var bid =jQuery("#cur_book_id").val();
			jQuery.ajax({
				url: ajaxurl,
				type: 'POST', 
				data: {
					'action':'pubml_media_save_style_form',
					'bid' : bid,
					'style_data' : jQuery('#new_book_styles').serialize()
				},
				dataType:'json',
				success:function(response) {
					//alert(response.data.bid);
					if(response.msg){
					jQuery('.success-form').html(response.msg);
					jQuery('.success-form').show();
					jQuery('.success-form').fadeOut(5000);	
					}
				},
				error: function(errorThrown){
					console.log(errorThrown);
				}
			});
		});
		
		
		jQuery('.cus-image').click(function() {	
				var background_val = jQuery('.background-type:checked').val();
				if(background_val=='tile'){
					jQuery(".style-all").css("background-repeat","repeat");
					jQuery(".style-all").css("background-size","");
				}
				else if(background_val=='full'){
					jQuery(".style-all").css("background-repeat","no-repeat");
					jQuery(".style-all").css("background-size","100%");
				}
		});
		
		
	jQuery("#del-style").click(function(){
			var bid =jQuery("#cur_book_id").val();
			var style_val = jQuery("#style-val option:selected").val();
			if(style_val < 11){
				alert("You cannot delete the basic styles.");
				return false;
			}
			jQuery.ajax({
				url: ajaxurl,
				type: 'POST', 
				data: {
					'action':'pubml_media_delete_style',
					'bid' : bid,
					'style_val' : style_val
				},
				dataType:'json',
				success:function(response) {
				
					jQuery("#style-val").html(response.data);
					jQuery('.msg-text').html(response.msg);
					jQuery('.msg-text').show();
					jQuery('.msg-text').fadeOut(5000);
					change_page_styles(1);
				},
				error: function(errorThrown){
					console.log(errorThrown);
				}
			});
		});
		
		jQuery("#restore-style").click(function(){
			var bid =jQuery("#cur_book_id").val();
			var style_val = jQuery("#style-val option:selected").val();
			jQuery.ajax({
				url: ajaxurl,
				type: 'POST', 
				data: {
					'action':'pubml_media_restore_style',
					'bid' : bid,
					'style_val' : style_val
				},
				dataType:'json',
				success:function(response) {
				console.log(response.data);
					jQuery("#style-val").html(response.data);
					jQuery("#del-style").remove();
					jQuery('.msg-text').html(response.msg);
					jQuery('.msg-text').show();
					jQuery('.msg-text').fadeOut(5000);	
					change_page_styles(1);
				},
				error: function(errorThrown){
					console.log(errorThrown);
				}
			});
		});
		
		if(jQuery(".hypen-two-val").is(':checked')){
			jQuery(".hypen-two-val").addClass("hyphen-style");
		}
		if(jQuery(".hypen-val").is(':checked')){
			jQuery(".hypen-val").addClass("hyphen-style");
			jQuery(".style-prev").addClass("hyphen-style");
		}
		jQuery(".hypen-val").click(function(){
			if(jQuery(this).is(':checked')){
				jQuery(this).addClass("hyphen-style");
				jQuery(".style-prev").addClass("hyphen-style");
			}
		});
		
		jQuery(".hypen-two-val").click(function(){
			if(jQuery(this).is(':checked')){
				jQuery(this).addClass("hyphen-style");
			}
		});		
		jQuery('#add-new-style').click(function(e) {
			var img_val = jQuery(this).attr('src');
			jQuery("#book-style-text .headline-add-data input").val("");
			jQuery("#book-style-text .headline-add-data textarea").val("Your text here");
			jQuery("#book-style-text #style_prev").val("Your text here");
			jQuery("#style-name-val").removeAttr("readonly");
			jQuery("#add-new-style-val").val("1");
			jQuery("#hide_from_section_editor").val("false");
			
		});
		

		jQuery("#text-before").focusout(function(){
			jQuery(".pno").html(jQuery(this).val() + ' 1/10 ' + jQuery("#text-after").val());
		});
		
		jQuery("#text-after").focusout(function(){
			jQuery(".pno").html(jQuery("#text-before").val() + ' 1/10 ' + jQuery(this).val());
		});
		
		jQuery(".runt-val").click(function(){
			if(jQuery(this).is(":checked")){
				style_runt_control();
			}
		});
		
		
		
});

function page_style_change(sid){
	    jQuery("#style-val").each(function () {
          jQuery('option', this).each(function () {
			var optVal = jQuery.trim(jQuery(this).text());
		
            if (optVal == sid ) {
             jQuery(this).attr('selected', 'selected');
			  jQuery("#style-val").trigger("change");
            };
          });
         }); 
}

function style_runt_control(){
		  var wordArray = jQuery(".style-prev").val().split(" ");
		  if (wordArray.length > 1) {
			wordArray[wordArray.length-2] += " " + wordArray[wordArray.length-1];
			wordArray.pop();
			jQuery(".style-prev").val(wordArray.join(" "));
		  }
}

function change_page_styles(style_id){
			var style_val = style_id;
			if(style_val > 11){
				jQuery("#del-style").show();
			}
			else{
				jQuery("#del-style").hide();
			}
			if(jQuery("#style-val").hasClass("default-style-menu")){
				var style_class= 'default';
			}
			else{
				var style_class= 'custom';
			}
			jQuery("#style-name-val").attr("readonly","readonly");
			var bid =jQuery("#cur_book_id").val();
			jQuery.ajax({
				url: ajaxurl,
				type: 'POST', 
				data: {
					'action':'pubml_media_get_style',
					'bid' : bid,
					'style_val' : style_val,
					'style_class' : style_class
				},
				dataType:'json',
				success:function(response) {
					if(response.data){
					jQuery(".runt-val").removeAttr("checked");
					jQuery(".hypen-val").removeAttr("checked");
						jQuery("#style-name-val").val(response.data.style_name);
						jQuery(".style-desc").val(response.data.style_desc);
						jQuery(".style-prev").val(response.data.style_prev);
						jQuery("#style_prev").html(response.data.style_prev);

						var font_f_text = (response.data.style_font).replace(/\\/g,'');
						jQuery("#PubML_fonts_text-font-menu").val(font_f_text);
											
						jQuery("#style-font-val").val(response.data.style_font_size);
						jQuery("#line-indent-val").val(response.data.style_line_indent);
						jQuery("#lmargin-val").val(response.data.style_left_margin);
						jQuery("#rmargin-val").val(response.data.style_right_margin);
						jQuery('.text-font-weight').val(response.data.default_style);
						jQuery(".align-val").val(response.data.style_align);
						jQuery("#lines-before").val(response.data.style_lines_before);
						jQuery("#lines-after").val(response.data.style_lines_after);
						jQuery("#line-height-val").val(response.data.style_line_height);
						jQuery("#style-slug").val(response.data.style_slug);
						jQuery("#hide_from_section_editor").val(response.data.hide_from_section_editor);
						if(response.data.style_hyphen =='on'){
							jQuery(".hypen-val").attr("checked","checked");
						}
						// else
						if(response.data.style_runt =='on'){
							jQuery(".runt-val").attr("checked","checked");
						}	
					}
					
					var fontfamily_val = jQuery("#book-style-text .text-font-menu").val();
					var fontsize_val   =  jQuery("#book-style-text #style-font-val").val();
					var leftmargin_val   =  jQuery("#book-style-text #lmargin-val").val();
					var rightmargin_val   =  jQuery("#book-style-text #rmargin-val").val();	
					var line_height_val	 = 	jQuery("#book-style-text #line-height-val").val();	
					var align_val	 = 	jQuery("#book-style-text .align-val").val();	
					var page_font_style = jQuery(".text-font-weight").val();
					var indentval = jQuery("#line-indent-val").val();
					jQuery(".style-prev").css("font-size",fontsize_val + 'px');
					jQuery(".style-prev").css("font-family",fontfamily_val);
					jQuery(".style-prev").css("padding-left",leftmargin_val + 'px');
					jQuery(".style-prev").css("padding-right",rightmargin_val + 'px');
					jQuery(".style-prev").css("line-height",line_height_val + 'px');
					jQuery(".style-prev").css("text-align",align_val);
					jQuery(".style-prev").css("font-style", page_font_style);
					jQuery(".style-prev").css("text-indent", indentval + 'px');

				},
				error: function(errorThrown){
					console.log(errorThrown);
				}
			});
}