<?php
/*
	Plugin Name: PubML™ Publishing Tools
	Plugin URI: http://pubml.com/
	Description: &lt;PubML&gt;™ allows publishers to create HTML5 eBooks that work in a web browser. Add maps, images, videos, and photo footnotes. Export beautiful ePub eBooks for conventional eReaders. Includes expert publishing and design guidance.  
	Author: Dave Bricker
	Author URI: http://theworldsgreatstbook.com
	Version: 0.9.20
	Domain Path: /languages
	License: Absolutely Proprietary
	Copyright 2014 Essential Absurdities Press  (email : dave@davebricker.com)
*/

/*This file is part of <PubML>™ Publishing Tools ©2014 by Spot Grafix, Inc.
<PubML> - Web-Based eBooks
Copyright 2014 by Spot Grafix, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

<PubML>™ eBooks rely on third-party libraries offered under various open 
source licenses (MIT, Apache, etc.). The licensing terms for these files 
are described within these files. 

This <PubML>™ eBook includes files and images released under the GNU 
General Public License that are used to display YOUR content. Most of 
these files are named with a "pubml_" prefix. Any modifications you make 
to the <PubML>™ eBook platform or its css styles are considered derivative 
works that others may use and modify as provided for by, and subject to, 
the GNU General Public License. 

And any modifications or additions to such CONTENT remains the property 
of the applicable  author or rights holder and is not subject to the GNU 
General Public License. The goal is to ensure that the <PubML>™ eBook 
platform remains open source and free for anyone to modify or customize, 
while not infringing on the rights of authors to retain control, over the
rights to their content. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/


/**
 * 	public constant for plugins PUBML_VERSION
 * 	@var string 
 * 	@access public
 */	
	if ( ! defined( 'PUBML_VERSION' ) ) {
		define( 'PUBML_VERSION', '0.9.20' );
	}

/**
 * 	public constant for plugins base url
 * 	@var string 
 * 	@access public
 */		

	if ( ! defined( 'PUBML_BASE_URL' ) )
		define( 'PUBML_BASE_URL', untrailingslashit(  plugins_url() . '/' . basename(dirname(__FILE__)) ) );

/**
 * 	public constant for plugins base directory
 * 	@var string 
 * 	@access public
 */

	if ( ! defined( 'PUBML_BASE_DIR' ) )
		define( 'PUBML_BASE_DIR', untrailingslashit( dirname( __FILE__ ) ) );

/**
 * 	public constant for plugins name
 * 	@var string 
 * 	@access public
 */
	if ( ! defined( 'PLUGINS_NAME' ) )
		define( 'PLUGINS_NAME', untrailingslashit( basename(dirname(__FILE__)) ) );

/**
 * 	public constant for website url which come from wordpress site url option settings
 * 	@var string url
 * 	@access public
 */

	if ( ! defined( 'SITE_URL' ) )
		define( 'SITE_URL', untrailingslashit( get_option('siteurl')) );

/**
 * 	public constant for render server url which will use for the rendering functionality for the pubml and epub book and used to validate other info
 * 	@var string url
 * 	@access public
 */

	if ( ! defined( 'RENDER_URL' ) )
		define( 'RENDER_URL', untrailingslashit( 'https://render.pubml.com/pubml-soap-service.php?wsdl' ) );

/**
 * 	public constant for pubml error message and staus for notifications for the pubml and epub book and used to validate other info
 * 	@var string url
 * 	@access public
 */

	if ( ! defined( 'PUBML_ERROR_MESSAGE' ) )
		define( 'PUBML_ERROR_MESSAGE', '' );	
	if ( ! defined( 'PUBML_ERROR_STATUS' ) )
		define( 'PUBML_ERROR_STATUS', false );

/**
 * 	public constant for plugins details or support url
 * 	@var string url
 * 	@access public
 */

	define('PLUGINS_WEBSITE', 'http://pubml.com');

/*********************************************************************************
 Settings for the license control and version control of the PubML eBook Plugin 
**********************************************************************************/ 
	set_site_transient( 'update_plugins', null );

// this is the URL our updater / license checker pings. This should be the URL of the site with EDD installed
	define( 'PUBML_STORE_URL', 'http://pubml.com' ); // you should use your own CONSTANT name, and be sure to replace it throughout this file

// the name of your product. This should match the download name in EDD exactly
	define( 'PUBML_EBOOK_PUBLISHER', 'PubML™ Publishing Tools' ); // you should use your own CONSTANT name, and be sure to replace it throughout this file

	if( !class_exists( 'PUBML_Ebook_Plugin_Updater' ) ) {
		// load our custom updater
		include( dirname( __FILE__ ) . '/pubml-plugin-updater.php' );
	}

	function pubml_ebook_plugin_updater() {
		// retrieve our license key from the DB
		$license_key = trim( get_option( 'pubml_ebook_license_key' ) );
		// setup the updater
		$pubml_updater = new PUBML_Ebook_Plugin_Updater( PUBML_STORE_URL, __FILE__, array( 
				'version' 	=> PUBML_VERSION, 				// current version number
				'license' 	=> $license_key, 		// license key (used get_option above to retrieve from DB)
				'item_name' => PUBML_EBOOK_PUBLISHER, 	// name of this plugin
				'author' 	=> 'Dave Bricker'  // author of this plugin
			)
		);
	}
	add_action( 'admin_init', 'pubml_ebook_plugin_updater' );

	/***************************************************************************
	the code below is just a standard options page. Substitute with your own.
	****************************************************************************/

	function pubml_ebook_license_menu() {
		// add_plugins_page( 'PubML eBook Publisher', 'PubML', 'manage_options', 'pubml-ebook-plugin', 'pubml_ebook_license_page' );
		add_menu_page( 'Settings', 'PubML', 'manage_options', 'pubml-ebook-plugin', 'pubml_ebook_license_page', plugins_url( 'pubml/images/pubml-nav-icon.png' )); 

		// Add a second submenu to the custom top-level menu:
		add_submenu_page('pubml-ebook-plugin', __('My Books','My Books'), __('My Books','pubml-menu'), 'manage_options', 'my-books', 'pubml_my_books_page');
		// Add a second submenu to the custom top-level menu:
		add_submenu_page('pubml-ebook-plugin', __('Fonts','Fonts'), __('Fonts','pubml-menu'), 'manage_options', 'fonts', 'pubml_fonts_page');
	}

	add_action('admin_menu', 'pubml_ebook_license_menu');

	function pubml_ebook_license_page() {
		$license 	= get_option( 'pubml_ebook_license_key' );
		$status 	= get_option( 'pubml_ebook_license_status' );
		?>
		<div id="book_meta">
			<div class="screen_icon">
				<img src="<?php echo PUBML_BASE_URL;?>/images/settings_icon_64x64.png" width="64" height="64"  alt=""/>
			</div>
			<h2>Settings</h2>
			<!--TABS------------------------------>
			<?php fn_custom_tabs_main('Settings');	?>
				<div class="content_container">
					<?php require_once('includes/pubml_settings-tab.php'); ?>
				</div>
		</div>
		<?php
	}

	function pubml_ebook_register_option() {
		// creates our settings in the options table
		register_setting('pubml_ebook_license', 'pubml_ebook_license_key', 'pubml_sanitize_license' );
	}
	add_action('admin_init', 'pubml_ebook_register_option');

	function pubml_sanitize_license( $new ) {
		$old = get_option( 'pubml_ebook_license_key' );
		if( $old && $old != $new ) {
			delete_option( 'pubml_ebook_license_status' ); // new license has been entered, so must reactivate
		}
		return $new;
	}

	/*************************************************
	* this illustrates how to activate a license key
	**************************************************/
	function pubml_ebook_activate_license() {
		// listen for our activate button to be clicked
		if( isset( $_POST['pubml_license_activate'] ) ) {
			// run a quick security check 
			if( ! check_admin_referer( 'pubml_ebook_nonce', 'pubml_ebook_nonce' ) ) 	
				return; // get out if we didn't click the Activate button
			// retrieve the license from the database
			$license = trim( $_POST['pubml_ebook_license_key'] );	// trim( get_option( 'pubml_ebook_license_key' ) );
			// data to send in our API request
			$api_params = array( 
				'edd_action'=> 'activate_license', 
				'license' 	=> $license, 
				'item_name' => urlencode( PUBML_EBOOK_PUBLISHER ) // the name of our product in EDD
			);
			// Call the custom API.
			$response = wp_remote_get( add_query_arg( $api_params, PUBML_STORE_URL ), array( 'timeout' => 15, 'sslverify' => false ) );
			// make sure the response came back okay
			if ( is_wp_error( $response ) )
				return false;
			// decode the license data
			$license_data = json_decode( wp_remote_retrieve_body( $response ) );
			// $license_data->license will be either "active" or "inactive"
			update_option( 'pubml_ebook_license_status', $license_data->license );
			update_option( 'pubml_ebook_license_key',  $license );
		}
	}

	add_action('admin_init', 'pubml_ebook_activate_license');

	/**********************************************************************************
	* Illustrates how to deactivate a license key. This will descrease the site count
	**********************************************************************************/
	function pubml_ebook_deactivate_license() {
		// listen for our activate button to be clicked
		if( isset( $_POST['pubml_license_deactivate'] ) ) {
			// run a quick security check 
			if( ! check_admin_referer( 'pubml_ebook_nonce', 'pubml_ebook_nonce' ) ) 	
				return; // get out if we didn't click the Activate button
			// retrieve the license from the database
			$license = trim( get_option( 'pubml_ebook_license_key' ) );
			// data to send in our API request
			$api_params = array( 
				'edd_action'=> 'deactivate_license', 
				'license' 	=> $license, 
				'item_name' => urlencode( PUBML_EBOOK_PUBLISHER ) // the name of our product in EDD
			);

			// Call the custom API.
			$response = wp_remote_get( add_query_arg( $api_params, PUBML_STORE_URL ), array( 'timeout' => 15, 'sslverify' => false ) );
			// make sure the response came back okay
			if ( is_wp_error( $response ) )
				return false;
			// decode the license data
			$license_data = json_decode( wp_remote_retrieve_body( $response ) );
			// $license_data->license will be either "deactivated" or "failed"
			if( $license_data->license == 'deactivated' )
				delete_option( 'pubml_ebook_license_status' );
		}
	}

	add_action('admin_init', 'pubml_ebook_deactivate_license');

	/****************************************************************
	* this illustrates how to check if a license key is still valid the updater does this for you, so this is only needed if you want to do something custom
	*******************************************************************/

	function pubml_ebook_check_license() {
		global $wp_version;
		$license = trim( get_option( 'pubml_ebook_license_key' ) );
		$api_params = array( 
			'edd_action' => 'check_license', 
			'license' => $license, 
			'item_name' => urlencode( PUBML_EBOOK_PUBLISHER ) 
		);

		// Call the custom API.
		$response = wp_remote_get( add_query_arg( $api_params, PUBML_STORE_URL ), array( 'timeout' => 15, 'sslverify' => false ) );
		if ( is_wp_error( $response ) )
			return false;
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		if( $license_data->license == 'valid' ) {
			echo 'valid'; exit;
			// this license is still valid
		} else {
			echo 'invalid'; exit;
			// this license is no longer valid
		}
	}

	/*****************************************************************************
	*	Check for Valid License key												 *	
	*****************************************************************************/

	function pubml_ebook_validation() {
		global $wp_version;
		$license = trim( get_option( 'pubml_ebook_license_key' ) );
		$api_params = array( 
			'edd_action' => 'check_license', 
			'license' => $license, 
			'item_name' => urlencode( PUBML_EBOOK_PUBLISHER ) 
		);
		// Call the custom API.
		$response = wp_remote_get( add_query_arg( $api_params, PUBML_STORE_URL ), array( 'timeout' => 15, 'sslverify' => false ) );
		if ( is_wp_error( $response ) )
			return false;
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
			if( $license_data->license == 'valid' ) {
				return true;	// this license is still valid		
			} else {
				return false;	// this license is no longer valid		
			}
	}

	/************************************************************************************	
	*	Check for pubml_ebook_check_remote_validation for License key and expiry date	*
	*************************************************************************************/

	function pubml_ebook_check_remote_validation($key = 'license') {
		global $wp_version;
		$license = trim( get_option( 'pubml_ebook_license_key' ) );
		$api_params = array( 
			'edd_action' => 'check_license', 
			'license' => $license, 
			'item_name' => urlencode( PUBML_EBOOK_PUBLISHER ) 
		);

		// Call the custom API.
		$response = wp_remote_get( add_query_arg( $api_params, PUBML_STORE_URL ), array( 'timeout' => 15, 'sslverify' => false ) );
		if ( is_wp_error( $response ) )
			return false;
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		switch($key){
			case 'license':
				return $license_data->license;	
			case 'expires':
				return $license_data->expires;	
			case 'customer_name':
				return $license_data->customer_name;	
			case 'customer_email':
				return $license_data->customer_email;	
			default:			
				return $license_data->license;	
		}
	}
	
	/*****************************************************************************/
/* 
*	supported thumbnails 
*/
	if ( function_exists( 'add_image_size' ) ) { 
		add_image_size( 'running_head', 30, 30,TRUE );
		add_image_size( 'chapter_head', 80, 80 ,TRUE); 
	}

	/* Manage redirection in the admin */
	ob_start();
if ( ! class_exists( 'PubML' ) ) {
/**
 * Main PubML Class
 *
 * Contains the main functions for PubML, stores variables, and handles error messages
 *
 * @class PubML
 * @version	0.0.1
 * @since 0.1
 * @package	PubML
 * @author SynapseIndia
*/

	class PubML {
		/*  @var string 	 */
		var $version = '0.0.1';
		/*  @var array 	 */
		var $messages = array();	
		/*  @var array 	 */
		var $errors = array();	
		/* @var PUBML_Query  */
		var $query;
		/**
		 * PubML Constructor.
		 *
		 * @access public
		 * @return void
		 */

		function __construct() {
			// Start a PHP session, if not yet started
			// if ( ! session_id() )
				// session_start();

			// Define version constant
			if ( ! defined( 'PUBML_VERSION' ) ) {
				define( 'PUBML_VERSION', $this->version );
			}

			// Include required files
			$this->includes();

			// Installation
			//if ( is_admin() && ! defined('DOING_AJAX') ) $this->install();
			// Actions
			add_action( 'init', array( &$this, 'init' ), 0 );
			// Loaded action
			do_action( 'pubml_loaded' );
		}

		/**
		* Include required core files.
		*
		* @access public
		* @return void
		*/
		function includes() {
			if ( is_admin() ) $this->admin_includes();
			if ( defined('DOING_AJAX') ) $this->ajax_includes();
			if ( ! is_admin() || defined('DOING_AJAX') ) $this->frontend_includes();
		// Include Core Integrations
		// include( 'includes/settings.php' );
		}
		
		/**
		* Include required admin files.
		*
		* @access public
		* @return void
		*/			

		function admin_includes() {
			// include( 'inc/init.php' );								// admin Init			
			include( 'settings/pubml_categories-images.php' );			// Admin section			
		}
		/**
		 * Include required ajax files.
		 *
		 * @access public
		 * @return void
		 */
		function ajax_includes() {
			// include( 'pubml-ajax.php' );							// Ajax functions for admin and the front-end
		}
		/**
		 * Include required frontend files.
		 *
		 * @access public
		 * @return void
		 */

		function frontend_includes() {
			// include( 'pubml-hooks.php' );						// Template hooks used on the front-end
			// include( 'pubml-functions.php' );					// Contains functions for various front-end events
		}

		/**
		 * Init PubML when WordPress Initialises.
		 *
		 * @access public
		 * @return void
		 */

		function init() {
			// Set up localisation	
			// Register globals for PubML environment
			$this->register_globals();
		}

		
		/**
		 * Register PubML environment globals.
		 *
		 * @access public
		 * @return void
		 */

		function register_globals() {
			$GLOBALS['pubml'] = null;
			//$GLOBALS['pubml']['helps'] = $helps_array;
		}
	}
	$GLOBALS['pubml'] = new PubML();

}

	// ini_set to process
	if(function_exists('ini_set')) {
		//change memory_limit setting
		@ini_set('memory_limit', '256M');	
	}

	// function to create the DB / Options / Defaults					

	function pubml_install() {

		global $wpdb;

		$media_tbl = $wpdb->prefix . 'book_media';

		$style_tbl = $wpdb->prefix . 'book_style';

		$group_tbl = $wpdb->prefix . 'media_group';

		$association_tbl = $wpdb->prefix . 'media_group_association';

		$sql = '';

		// create the ECPT metabox database table

		if($wpdb->get_var("show tables like '$media_tbl'") != $media_tbl) 

		{

			$sql .= "CREATE TABLE " . $media_tbl . " (

				`book_id` int(11) NOT NULL,

				`media_id` int(11) NOT NULL auto_increment,

				`media_url` varchar(200) NOT NULL,

				`media_title` varchar(200) NOT NULL,

				`media_slug` varchar(150) NOT NULL,

				`media_type` varchar(100) default NULL,

				PRIMARY KEY  (`media_id`)

			);";

		}

		if($wpdb->get_var("show tables like '$style_tbl'") != $style_tbl) 

		{

			$sql .= "CREATE TABLE " . $style_tbl . " (

				`id` int(11) NOT NULL auto_increment,

				`book_id` int(11) NOT NULL,

				`style_name` varchar(200) NOT NULL,

				`style_data` text NOT NULL,

				`type` varchar(100) NOT NULL,

				PRIMARY KEY  (`id`)

			);";

		}

		if($wpdb->get_var("show tables like '$group_tbl'") != $group_tbl) 

		{

			$sql .= "CREATE TABLE " . $group_tbl . " (

				`group_id` int(11) NOT NULL auto_increment,

				`book_id` int(11) NOT NULL,

				`group_title` varchar(200) NOT NULL,

				`group_slug` varchar(200) NOT NULL,

				`related_ids` varchar(200) default NULL,

				PRIMARY KEY  (`group_id`),

				UNIQUE KEY `group_title` (`group_title`,`book_id`,`group_slug`)

			);";

		}

		if($wpdb->get_var("show tables like '$association_tbl'") != $association_tbl) 

		{

			$sql .= "CREATE TABLE " . $association_tbl . " (

				`rid` int(11) NOT NULL auto_increment,

				`book_id` int(11) NOT NULL,

				`media_id` int(11) NOT NULL,

				`associate_groups` varchar(200) NOT NULL,

				PRIMARY KEY  (`rid`)

			);";

		}

		

			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

			dbDelta($sql);

		pubml_copy_fonts();

		update_option('pubml_active_version', PUBML_VERSION);

	}

	/*

	Uninstall tables on deactivation of plugin

	*/

	function pubml_uninstall() {

		global $wpdb;

		$media_tbl = $wpdb->prefix . 'book_media';

		$style_tbl = $wpdb->prefix . 'book_style';

		$group_tbl = $wpdb->prefix . 'media_group';

		$association_tbl = $wpdb->prefix . 'media_group';

		$wpdb->query("DROP TABLE IF EXISTS $media_tbl");

		$wpdb->query("DROP TABLE IF EXISTS $style_tbl");

		$wpdb->query("DROP TABLE IF EXISTS $group_tbl");

		$wpdb->query("DROP TABLE IF EXISTS $association_tbl");

	}



	// run the install scripts upon plugin activation

	register_activation_hook(__FILE__,'pubml_install');

	// run the uninstall scripts upon plugin deactivation

	register_uninstall_hook(__FILE__,'pubml_uninstall');





	function pubml_copy_fonts(){

		// $font_url = "http://helps.pubml.com/addons.zip";

		$addon_url = "https://s3.amazonaws.com/pubml_plugin/addons.zip";

		$destination = wp_upload_dir();

		// $font_path = WP_PLUGIN_DIR.'/pubml/addons.zip';

		$addon_path = $destination['basedir'].'/pubml_addons.zip';

		

		// chmod(dirname( __FILE__ ), 0777);		

		// die ( var_dump(is_writable(dirname( __FILE__ ))) );

		// download($font_url, $font_path);

		

		if(!@copy("$addon_url", "$addon_path")){

			$errors= error_get_last();

			// die("<br />\n".$errors['message']);

			// pubml_admin_notice('Error - '.$errors['message'], true);

		

		}else {

			$zip = new ZipArchive;

			if ($zip->open("$addon_path") === TRUE) {

				if(is_writable(dirname( __FILE__ ))){

					if( $zip->extractTo(dirname( __FILE__ )) === TRUE){

						unlink("$addon_path");

					}else {

						// pubml_admin_notice('Error - Permission denied', true);

					}

				}else{	

					// pubml_admin_notice('Error - Permission denied', true);

					// do_action( 'admin_notices', 'Error - Permission denied', true );

				}	

			} 

			$zip->close();	

		}				

	}

	 

	/**

	* Download

	 * @param str $url, $path

	 * @return bool || void

	 */

	 

	 function download($url, $path)	{

	  # open file to write

	  // die(print_r($path));

	  // $fp = fopen ($path, 'w+');

	  

		if(!@copy("$url", "$path"))

		{

			$errors= error_get_last();

			// echo "COPY ERROR: ".$errors['type'];

			// die("<br />\n".$errors['message']);

		} else {

			// die("File copied from remote!");

		}

	  

	  

	  // # start curl

	  // $ch = curl_init();

	  // curl_setopt( $ch, CURLOPT_URL, $url );

	  // # set return transfer to false

	  // curl_setopt( $ch, CURLOPT_RETURNTRANSFER, false );

	  // curl_setopt( $ch, CURLOPT_BINARYTRANSFER, true );

	  // curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );

	  // # increase timeout to download big file

	  // curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 10 );

	  // # write data to local file

	  // curl_setopt( $ch, CURLOPT_FILE, $fp );

	  // # execute curl

	  // curl_exec( $ch );

	  // # close curl

	  // curl_close( $ch );

	  // # close local file

	  // fclose( $fp );



	  // if (filesize($path) > 0) 

	  

	  return true;

	}

	

	

	/* Add JS to the plugin for admin */

	add_action( 'admin_init', 'add_scripts_admin_' );

	function add_scripts_admin_() {

		/* Register our script. */

		add_action('admin_enqueue_scripts', 'pubml_admin_scripts');

		wp_register_script( 'custom-js-script', plugins_url( 'js/pubml_custom-scripts.js', __FILE__ ) );		

	}

	

	

	add_action( 'admin_init', 'add_styles_admin_' );

	/* Register admin style. */

	function add_styles_admin_() {

		/* Register our style. */

		wp_register_style( 'pub-css', plugins_url('css/pubml_admin.css', __FILE__) );

	}

	/* check the activation hook on plugin update */

	function addon_upgrade_pubml(){

		$pubml_active_version = get_option( 'pubml_active_version', '0' );

		// Outdated

		if ( version_compare( $pubml_active_version, PUBML_VERSION, '<' ) ) {

			// Run specific upgrade routines

			pubml_copy_fonts();		

		}

	}

	// add_action( 'admin_init', 'addon_upgrade_pubml' );	// Run specific upgrade routines

	

	/* check the activation hook on plugin update */	

	function pubml_post_upgrader( ) {		

		pubml_copy_fonts();

	}

	add_filter( 'upgrader_post_install' , 'pubml_post_upgrader' );

	



	/* Add stylesheet to the plugin for admin */

	function my_plugin_admin_scripts() {

		/* Link our already registered script to a page */

		wp_enqueue_script( 'custom-js-script' );

		echo "<script type='text/javascript'>\n";

		echo 'var pluginUrl = "'.PUBML_BASE_URL . '"';

		echo "\n</script>";

	}

	add_action('admin_print_scripts', 'my_plugin_admin_scripts');



	function pub_plugin_admin_style() {

		/* Link our already registered script to a page */

		wp_enqueue_style( 'pub-css' );

	}

	add_action('admin_print_styles', 'pub_plugin_admin_style');



	#################### javscript variable defination for PubML ##########################

	add_action('admin_head', 'pubml_script_defination', 999);



	function pubml_script_defination(){

		$upload_dir = wp_upload_dir();

		echo '<script type="text/javascript">var pubmlURL = "'.PUBML_BASE_URL.'";var uploadURL = "'.$upload_dir['baseurl'].'"; var pubmlAjaxURL = "'.admin_url( "admin-ajax.php" ).'";</script>';

	}



	#################### Form Validation Js ##########################

	add_action('admin_footer', 'pubml_scripts_updates', 999);



	function pubml_scripts_updates(){

			// page specific validation here...

			wp_enqueue_script('form_validation', PUBML_BASE_URL.'/js/jquery.validate.min.js');

			wp_enqueue_script('help_sections_popup', PUBML_BASE_URL.'/js/jquery.bpopup-0.9.4.min.js');

			wp_enqueue_script('help_sections_script', PUBML_BASE_URL.'/js/jquery.pubmlscripts.me.js');

			

			wp_enqueue_script('media_list', PUBML_BASE_URL.'/js/jquery.mCustomScrollbar.concat.min.js');

			wp_enqueue_style( 'media_list_style', PUBML_BASE_URL.'/css/jquery.mCustomScrollbar.css' );

			wp_enqueue_style( 'help_sections_style', PUBML_BASE_URL.'/css/pubml_popup.css' );

	}



	add_action('wp_head', 'pubml_preview_scripts_updates', 999);



	function pubml_preview_scripts_updates(){

			$upload_dir = wp_upload_dir();

			

			wp_enqueue_script('jquery');

			echo '<script type="text/javascript">var pubmlURL = "'.PUBML_BASE_URL.'";var uploadURL = "'.$upload_dir['baseurl'].'"; var pubmlAjaxURL = "'.admin_url( "admin-ajax.php" ).'";</script>';

			wp_enqueue_script('help_sections_popup', PUBML_BASE_URL.'/js/jquery.bpopup-0.9.4.min.js');

			wp_enqueue_script('help_sections_script', PUBML_BASE_URL.'/js/jquery.pubmlscripts.me.js');

			wp_enqueue_style( 'help_sections_style', PUBML_BASE_URL.'/css/pubml_popup.css' );

			echo '<div class="iframe-sol"><div id="previewPopup" style="width:100%; height:100%;display:none;" class="previewBox"> <span class="button b-close"><span>X</span></span> <div id="preview-content" style="width:100%; height:100%"></div></div></div>';

			echo '<div id="pluginAlertBox" style="display:none;" class="pluginAlertBox"><span class="pluginAlertBox button b-close"><span>X</span></span>	<div id="pluginAlertBox-content"></div></div>';

			

	}



	/* 

	** Include the functions file 

	** This file includes all functions used for this plugin

	*/

	require_once('lib/nusoap.php');						// Pull in the NuSOAP code

	require_once("inc/pubml_init.php");					//	General init fuctions, variable and Array()

	require_once("inc/pubml_image_resizer.php");

	require_once("inc/pubml_custom-functions.php");

	require_once("inc/pubml_custom-editor-buttons.php");

	require_once("inc/pubml_ajax.php");

	require_once("ePub/pubml_ePub-init.php");			// Export the ebook as epub Pubml

	

	// pubml_my_books_page() displays the page content for the second submenu

	// of the PubML menu

	function pubml_my_books_page() {

		require_once("includes/pubml_mybook.php");

	}



	// pubml_new_book_page() displays the page content for the second submenu

	// of the PubML menu

	function pubml_new_book_page() {

		require_once("includes/pubml_newbook.php");

	}



	// pubml_fonts_page() displays the page content for the second submenu

	// of the PubML menu

	function pubml_fonts_page() {

		require_once("includes/pubml_fonts.php");

	}



	// pubml_book_sections_page() displays the page content for the sections/book content

	// of the PubML menu

	function pubml_book_sections_page() {

		require_once("includes/pubml_sections.php");

		wp_enqueue_script('nestedsort', PUBML_BASE_URL.'/js/jquery.mjs.nestedSortable.js');	

		wp_enqueue_script('nesort', PUBML_BASE_URL.'/js/jquery.nestable.js');	

		

	}



	// pubml_book_navigation_page() displays the navigation tabs for the PubML eBook

	// of the PubML Book menu

	function pubml_book_navigation_page() {

		require_once("includes/pubml_navigations-tab.php");

	}



	// pubml_book_export_page() displays the options to download the books using the allowed options

	// of the PubML Book menu

	function pubml_book_export_page() {

		require_once("includes/pubml_export-tab.php");

	}



	// pubml_book_footnotes_page() displays the footnotes content for the book content

	// of the PubML menu

	function pubml_book_footnotes_page() {

		require_once("includes/pubml_footnotes.php");

	}





	// pubml_book_styles_page() displays the page content for the styles page

	// of the PubML menu

	function pubml_book_styles_page() {

		require_once("includes/pubml_book-styles.php");

			wp_enqueue_script('tab_wizard', PUBML_BASE_URL.'/js/jquery.tools.min.js');

			wp_enqueue_script('color_js', PUBML_BASE_URL.'/js/jscolor.js');

			wp_enqueue_script('book_styles', PUBML_BASE_URL.'/js/pubml_styles.js');

			wp_enqueue_style( 'tabs', PUBML_BASE_URL.'/css/pubml_tabs.css' );

			wp_enqueue_style( 'fontcss', 'http://fonts.googleapis.com/css?family=Cinzel+Decorative:400,700,900' );
			

	}



	// pubml_book_media_page() displays the page content for the Media page

	// of the PubML menu

	function pubml_book_media_page() {

		require_once("includes/pubml_book-media.php");

	}



	// pubml_book_new_media_page() displays the page content for the add media

	// of the PubML menu

	function pubml_book_new_media_page() {

		require_once("includes/pubml_new-media.php");

	}

	

	// pubml_book_new_section_page() displays the page content for the add section

	// of the PubML menu

	function pubml_book_new_section_page() {

		require_once("includes/pubml_new-section.php");

	}

	

	// pubml_book_new_tabs_page() displays the page content for the add or edit Tabs

	// of the PubML menu

	function pubml_book_new_tabs_page() {

		require_once("includes/pubml_new-navigation.php");

	}	

	

	// pubml_book_new_footnote_page() displays the page content for the add section

	// of the PubML menu

	function pubml_book_new_footnote_page() {

		require_once("includes/pubml_new-footnote.php");

	}

	

	// pubml_media_list_page() displays the page content for the media added

	function pubml_media_list_page() {

		require_once("includes/pubml_book-media-library.php");

		wp_enqueue_script('book_styles', PUBML_BASE_URL.'/js/pubml_custom.js');	

		wp_enqueue_style( 'popup', PUBML_BASE_URL.'/css/pubml_mediapop.css' );		

	}

	

	// pubml_book_export() to export all chapters and footnotes added

	function pubml_book_export() {

		require_once("includes/pubml_book_export.php");	

	}



	// pubml_book_media_group_page() displays the form to add media group

	// of the PubML menu

	function pubml_book_media_group_page() {

		require_once("includes/pubml_book-media-group.php");

	}



	// pubml_manage_media_group_page() displays the list to manage media group

	// of the PubML menu

	function pubml_manage_media_group_page() {

		require_once("includes/manage-media-group.php");

	}



	// Add new image sizes

	function pubml_insert_custom_image_sizes( $image_sizes ) {

		// get the custom image sizes

		global $_wp_additional_image_sizes;

		// if there are none, just return the built-in sizes

		if ( empty( $_wp_additional_image_sizes ) )

		return $image_sizes;

		 

		// add all the custom sizes to the built-in sizes

		foreach ( $_wp_additional_image_sizes as $id => $data ) {

		// take the size ID (e.g., 'my-name'), replace hyphens with spaces,

		// and capitalise the first letter of each word

		if ( !isset($image_sizes[$id]) )

		$image_sizes[$id] = ucfirst( str_replace( '-', ' ', $id ) );

		}

		 

		return $image_sizes;

	}

 

	function pubml_custom_image_setup () {

		add_theme_support( 'post-thumbnails' );

		add_image_size( 'running_head', 30, 30,TRUE );

		add_image_size( 'chapter_head', 80, 80 ,TRUE); 

		add_filter( 'image_size_names_choose', 'pubml_insert_custom_image_sizes' );

	}

	add_action( 'after_setup_theme', 'pubml_custom_image_setup' );



	// pubml_purchase_license_page() displays the options to purchase the license page using the allowed options

	// of the PubML Book menu

		function pubml_purchase_license_page() {

			require_once("includes/pubml_purchase-license.php");

		}

	// Function to enqueue media scripts when the admin_init

	function pubml_admin_scripts() {

        if(function_exists( 'wp_enqueue_media' )){

			wp_enqueue_media();

		}else{

			wp_enqueue_style('thickbox');

			wp_enqueue_script('media-upload');

			wp_enqueue_script('thickbox');

		}

    }



add_action( 'after_setup_theme', 'default_attachment_display_settings' );

/**

 * Set the Attachment Display Settings "Link To" default to "none"

 *

 * This function is attached to the 'after_setup_theme' action hook.

 */

	function default_attachment_display_settings() {

		update_option( 'image_default_link_type', 'none' );

	}



/* Notice the admin message */	

	function pubml_admin_notice( $message = '', $show = false ) {		

		if( $show == true){

			?>

			<div class="update-nag">

				<p><b>PubML eBook Publisher Plugin : </b><?php _e( "$message" ); ?></p>

			</div>

			<?php

		}

	}

	add_action( 'admin_notices', 'pubml_admin_notice');		

?>